/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.network.client;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.marker.GlobalMarkersData;
import hunternif.mc.atlas.marker.Marker;
import hunternif.mc.atlas.marker.MarkersData;
import hunternif.mc.atlas.network.AbstractMessage;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.minecraft.class_1657;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

public class MarkersPacket
extends AbstractMessage.AbstractClientMessage<MarkersPacket> {
    private static final int GLOBAL = -1;
    private int atlasID;
    private class_5321<class_2874> dimension;
    private final ListMultimap<String, Marker> markersByType = ArrayListMultimap.create();

    public MarkersPacket() {
    }

    public MarkersPacket(int atlasID, class_5321<class_2874> dimension, Marker ... markers) {
        this.atlasID = atlasID;
        this.dimension = dimension;
        for (Marker marker : markers) {
            this.markersByType.put((Object)marker.getType(), (Object)marker);
        }
    }

    public MarkersPacket(class_5321<class_2874> dimension, Marker ... markers) {
        this(-1, dimension, markers);
    }

    public MarkersPacket putMarker(Marker marker) {
        this.markersByType.put((Object)marker.getType(), (Object)marker);
        return this;
    }

    private boolean isGlobal() {
        return this.atlasID == -1;
    }

    @Override
    public void read(class_2540 buffer) throws IOException {
        this.atlasID = buffer.method_10816();
        this.dimension = class_5321.method_29179((class_5321)class_2378.field_25095, (class_2960)buffer.method_10810());
        int typesLength = buffer.method_10816();
        for (int i = 0; i < typesLength; ++i) {
            String type = buffer.method_10800(512);
            int markersLength = buffer.method_10816();
            for (int j = 0; j < markersLength; ++j) {
                Marker marker = new Marker(buffer.method_10816(), type, buffer.method_10800(512), this.dimension, buffer.readInt(), buffer.readInt(), buffer.readBoolean());
                this.markersByType.put((Object)type, (Object)marker);
            }
        }
    }

    @Override
    public void write(class_2540 buffer) throws IOException {
        buffer.method_10804(this.atlasID);
        buffer.method_10812(this.dimension.method_29177());
        Set types = this.markersByType.keySet();
        buffer.method_10804(types.size());
        for (String type : types) {
            buffer.method_10814(type);
            List markers = this.markersByType.get((Object)type);
            buffer.method_10804(markers.size());
            for (Marker marker : markers) {
                buffer.method_10804(marker.getId());
                buffer.method_10814(marker.getLabel());
                buffer.writeInt(marker.getX());
                buffer.writeInt(marker.getZ());
                buffer.writeBoolean(marker.isVisibleAhead());
            }
        }
    }

    @Override
    protected void process(class_1657 player, EnvType side) {
        GlobalMarkersData markersData = this.isGlobal() ? AntiqueAtlasMod.globalMarkersData.getData() : AntiqueAtlasMod.markersData.getMarkersData(this.atlasID, player.method_5770());
        for (Marker marker : this.markersByType.values()) {
            ((MarkersData)markersData).loadMarker(marker);
        }
    }
}

