/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.network.client;

import hunternif.mc.atlas.client.BiomeTextureMap;
import hunternif.mc.atlas.client.TextureSet;
import hunternif.mc.atlas.ext.ExtTileIdMap;
import hunternif.mc.atlas.ext.ExtTileTextureMap;
import hunternif.mc.atlas.ext.TileIdRegisteredCallback;
import hunternif.mc.atlas.network.AbstractMessage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class TileNameIDPacket
extends AbstractMessage.AbstractClientMessage<TileNameIDPacket> {
    private final Map<class_2960, Integer> nameToIdMap;

    public TileNameIDPacket() {
        this.nameToIdMap = new HashMap<class_2960, Integer>();
    }

    public TileNameIDPacket(Map<class_2960, Integer> nameToIdMap) {
        this.nameToIdMap = nameToIdMap;
    }

    public TileNameIDPacket put(class_2960 name, int biomeID) {
        this.nameToIdMap.put(name, biomeID);
        return this;
    }

    @Override
    public void read(class_2540 buffer) throws IOException {
        int size = buffer.method_10816();
        for (int i = 0; i < size; ++i) {
            String name = buffer.method_10800(512);
            int biomeID = -buffer.method_10816();
            this.nameToIdMap.put(new class_2960(name), biomeID);
        }
    }

    @Override
    public void write(class_2540 buffer) throws IOException {
        buffer.method_10804(this.nameToIdMap.size());
        for (Map.Entry<class_2960, Integer> entry : this.nameToIdMap.entrySet()) {
            buffer.method_10814(entry.getKey().toString());
            buffer.method_10804(-entry.getValue().intValue());
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void process(class_1657 player, EnvType side) {
        for (Map.Entry<class_2960, Integer> entry : this.nameToIdMap.entrySet()) {
            class_2960 tileName = entry.getKey();
            int id = entry.getValue();
            int oldID = ExtTileIdMap.instance().getPseudoBiomeID(tileName);
            if (oldID != -1 && oldID != id) {
                BiomeTextureMap.instance().setTexture((class_1959)class_2378.field_11153.method_10200(oldID), null);
            }
            ExtTileIdMap.instance().setPseudoBiomeID(tileName, id);
            TextureSet texture = ExtTileTextureMap.instance().getTexture(tileName);
            BiomeTextureMap.instance().setTexture(id, texture);
        }
        ((TileIdRegisteredCallback)TileIdRegisteredCallback.EVENT.invoker()).onTileIDsReceived(this.nameToIdMap);
    }
}

