/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas;

import hunternif.mc.impl.atlas.AntiqueAtlasConfig;
import hunternif.mc.impl.atlas.AntiqueAtlasModClient;
import hunternif.mc.impl.atlas.client.KeyHandler;
import hunternif.mc.impl.atlas.core.AtlasDataHandler;
import hunternif.mc.impl.atlas.core.BiomeDetectorBase;
import hunternif.mc.impl.atlas.core.GlobalAtlasData;
import hunternif.mc.impl.atlas.ext.TileDataHandler;
import hunternif.mc.impl.atlas.forge.AntiqueAtlasConfigBuilder;
import hunternif.mc.impl.atlas.marker.GlobalMarkersDataHandler;
import hunternif.mc.impl.atlas.marker.MarkersDataHandler;
import hunternif.mc.impl.atlas.network.AntiqueAtlasNetworking;
import hunternif.mc.impl.atlas.structure.NetherFortress;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="antiqueatlas")
public class AntiqueAtlasMod {
    public static AntiqueAtlasMod instance;
    public static final String ID = "antiqueatlas";
    public static final String NAME = "Antique Atlas";
    public static final String CHANNEL = "antiqueatlas";
    public static final String VERSION = "@VERSION@";
    public static final Logger LOG;
    private static final String NETWORK_PROTOCOL_VERSION = "1";
    public static final SimpleChannel MOD_CHANNEL;
    public static final AtlasDataHandler atlasData;
    public static final MarkersDataHandler markersData;
    public static final TileDataHandler tileData;
    public static final GlobalMarkersDataHandler globalMarkersData;
    private static final GlobalAtlasData clientAtlasData;

    public AntiqueAtlasMod() {
        instance = this;
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientRegistries);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueue);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::initializeClient);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, AntiqueAtlasConfigBuilder.client_config, "antiqueatlas.client.toml");
        AntiqueAtlasConfigBuilder.loadConfig(AntiqueAtlasConfigBuilder.client_config, FMLPaths.CONFIGDIR.get().resolve("antiqueatlas.client.toml").toString());
        MinecraftForge.EVENT_BUS.register((Object)this);
        BiomeDetectorBase.scanBiomeTypes();
        AntiqueAtlasNetworking.registerC2SListeners(MOD_CHANNEL);
        AntiqueAtlasNetworking.registerS2CListeners(MOD_CHANNEL);
        NetherFortress.registerPieces();
    }

    private void setup(FMLCommonSetupEvent event) {
    }

    public void clientRegistries(FMLClientSetupEvent event) {
        if (!((Boolean)AntiqueAtlasConfig.itemNeeded.get()).booleanValue()) {
            KeyHandler.registerBindings();
        }
    }

    public void initializeClient(ParticleFactoryRegisterEvent event) {
        AntiqueAtlasModClient.onInitializeClient();
    }

    public void enqueue(InterModEnqueueEvent event) {
    }

    public static ResourceLocation id(String ... path) {
        return path[0].contains(":") ? new ResourceLocation(String.join((CharSequence)".", path)) : new ResourceLocation("antiqueatlas", String.join((CharSequence)".", path));
    }

    public static GlobalAtlasData getGlobalAtlasData(World world) {
        if (world instanceof ServerWorld) {
            return (GlobalAtlasData)((ServerWorld)world).func_217481_x().func_215752_a(() -> new GlobalAtlasData("antiqueatlas:global_atlas_data"), "antiqueatlas:global_atlas_data");
        }
        return clientAtlasData;
    }

    static {
        LOG = LogManager.getLogger((String)"antiqueatlas");
        MOD_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)AntiqueAtlasMod.id("main"), () -> NETWORK_PROTOCOL_VERSION, NETWORK_PROTOCOL_VERSION::equals, NETWORK_PROTOCOL_VERSION::equals);
        atlasData = new AtlasDataHandler();
        markersData = new MarkersDataHandler();
        tileData = new TileDataHandler();
        globalMarkersData = new GlobalMarkersDataHandler();
        clientAtlasData = new GlobalAtlasData("antiqueatlas:global_atlas_data");
    }
}

