/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas;

import hunternif.mc.impl.atlas.client.BiomeTextureMap;
import hunternif.mc.impl.atlas.client.TextureSet;
import hunternif.mc.impl.atlas.client.TextureSetConfig;
import hunternif.mc.impl.atlas.client.TextureSetMap;
import hunternif.mc.impl.atlas.client.gui.GuiAtlas;
import hunternif.mc.impl.atlas.ext.ExtTileIdMap;
import hunternif.mc.impl.atlas.marker.MarkerTextureConfig;
import hunternif.mc.impl.atlas.registry.MarkerType;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;

@OnlyIn(value=Dist.CLIENT)
public class ClientProxy
implements ISelectiveResourceReloadListener {
    private static TextureSetMap textureSetMap;
    private static TextureSetConfig textureSetConfig;
    private static BiomeTextureMap textureMap;
    public static MarkerTextureConfig markerTextureConfig;
    private static GuiAtlas guiAtlas;

    public void initClient() {
        IReloadableResourceManager resourceManager = Minecraft.func_71410_x().field_110451_am;
        textureSetMap = TextureSetMap.instance();
        textureSetConfig = new TextureSetConfig(textureSetMap);
        this.registerDefaultTextureSets(textureSetMap);
        textureSetMap.setDirty(false);
        resourceManager.func_219534_a((IFutureReloadListener)textureSetConfig);
        resourceManager.func_219534_a((IFutureReloadListener)this);
        textureMap = BiomeTextureMap.instance();
        this.registerVanillaCustomTileTextures();
        textureMap.setDirty(false);
        this.assignVanillaBiomeTextures();
        markerTextureConfig = new MarkerTextureConfig();
        resourceManager.func_219534_a((IFutureReloadListener)markerTextureConfig);
        for (MarkerType type : MarkerType.REGISTRY) {
            type.initMips();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerDefaultTextureSets(TextureSetMap map) {
        map.register(TextureSet.ICE);
        map.register(TextureSet.SHORE);
        map.register(TextureSet.ROCK_SHORE);
        map.register(TextureSet.DESERT);
        map.register(TextureSet.PLAINS);
        map.register(TextureSet.SUNFLOWERS);
        map.register(TextureSet.HILLS);
        map.register(TextureSet.DESERT_HILLS);
        map.register(TextureSet.ICE_SPIKES);
        map.register(TextureSet.SNOW_PINES);
        map.register(TextureSet.SNOW_PINES_HILLS);
        map.register(TextureSet.SNOW_HILLS);
        map.register(TextureSet.SNOW);
        map.register(TextureSet.MOUNTAINS_NAKED);
        map.register(TextureSet.MOUNTAINS);
        map.register(TextureSet.MOUNTAINS_SNOW_CAPS);
        map.register(TextureSet.MOUNTAINS_ALL);
        map.register(TextureSet.FOREST);
        map.register(TextureSet.FOREST_HILLS);
        map.register(TextureSet.FOREST_FLOWERS);
        map.register(TextureSet.DENSE_FOREST);
        map.register(TextureSet.DENSE_FOREST_HILLS);
        map.register(TextureSet.BIRCH);
        map.register(TextureSet.BIRCH_HILLS);
        map.register(TextureSet.TALL_BIRCH);
        map.register(TextureSet.TALL_BIRCH_HILLS);
        map.register(TextureSet.DENSE_BIRCH);
        map.register(TextureSet.JUNGLE);
        map.register(TextureSet.JUNGLE_HILLS);
        map.register(TextureSet.JUNGLE_CLIFFS);
        map.register(TextureSet.JUNGLE_EDGE);
        map.register(TextureSet.JUNGLE_EDGE_HILLS);
        map.register(TextureSet.PINES);
        map.register(TextureSet.PINES_HILLS);
        map.register(TextureSet.SAVANNA);
        map.register(TextureSet.SAVANNA_PLATEAU);
        map.register(TextureSet.PLATEAU_SAVANNA_M);
        map.register(TextureSet.MESA);
        map.register(TextureSet.BRYCE);
        map.register(TextureSet.PLATEAU_MESA);
        map.register(TextureSet.PLATEAU_MESA_LOW);
        map.register(TextureSet.PLATEAU_MESA_TREES);
        map.register(TextureSet.PLATEAU_MESA_TREES_LOW);
        map.register(TextureSet.PLATEAU_SAVANNA);
        map.register(TextureSet.MEGA_SPRUCE);
        map.register(TextureSet.MEGA_SPRUCE_HILLS);
        map.register(TextureSet.MEGA_TAIGA);
        map.register(TextureSet.MEGA_TAIGA_HILLS);
        map.register(TextureSet.SWAMP);
        map.register(TextureSet.SWAMP_HILLS);
        map.register(TextureSet.MUSHROOM);
        map.register(TextureSet.WATER);
        map.register(TextureSet.LAVA);
        map.register(TextureSet.LAVA_SHORE);
        map.register(TextureSet.CAVE_WALLS);
        map.register(TextureSet.RAVINE);
        map.register(TextureSet.HOUSE);
        map.register(TextureSet.FENCE);
        map.register(TextureSet.LIBRARY);
        map.register(TextureSet.L_HOUSE);
        map.register(TextureSet.SMITHY);
        map.register(TextureSet.FARMLAND_LARGE);
        map.register(TextureSet.FARMLAND_SMALL);
        map.register(TextureSet.WELL);
        map.register(TextureSet.VILLAGE_TORCH);
        map.register(TextureSet.HUT);
        map.register(TextureSet.HOUSE_SMALL);
        map.register(TextureSet.BUTCHERS_SHOP);
        map.register(TextureSet.CHURCH);
        map.register(TextureSet.SOUL_SAND_VALLEY);
        map.register(TextureSet.NETHER_BRIDGE);
        map.register(TextureSet.NETHER_BRIDGE_X);
        map.register(TextureSet.NETHER_BRIDGE_Z);
        map.register(TextureSet.NETHER_BRIDGE_END_X);
        map.register(TextureSet.NETHER_BRIDGE_END_Z);
        map.register(TextureSet.NETHER_BRIDGE_GATE);
        map.register(TextureSet.NETHER_TOWER);
        map.register(TextureSet.NETHER_WALL);
        map.register(TextureSet.NETHER_HALL);
        map.register(TextureSet.NETHER_FORT_STAIRS);
        map.register(TextureSet.NETHER_THRONE);
        map.register(TextureSet.END_ISLAND);
        map.register(TextureSet.END_ISLAND_PLANTS);
        map.register(TextureSet.END_VOID);
    }

    private void assignVanillaBiomeTextures() {
        this.setBiomeTextureIfNone((RegistryKey<Biome>)Biomes.field_185445_W, TextureSet.ICE_SPIKES);
        this.setBiomeTextureIfNone((RegistryKey<Biome>)Biomes.field_185441_Q, TextureSet.SUNFLOWERS);
        this.setBiomeTextureIfNone((RegistryKey<Biome>)Biomes.field_150577_O, TextureSet.SHORE);
        this.setBiomeTextureIfNone((RegistryKey<Biome>)Biomes.field_150576_N, TextureSet.ROCK_SHORE);
        this.setBiomeTextureIfNone((RegistryKey<Biome>)Biomes.field_76775_o, TextureSet.MOUNTAINS_SNOW_CAPS);
        this.setBiomeTextureIfNone((RegistryKey<Biome>)Biomes.field_76770_e, TextureSet.MOUNTAINS_ALL);
        this.setBiomeTextureIfNone((RegistryKey<Biome>)Biomes.field_185431_ac, TextureSet.MOUNTAINS_SNOW_CAPS);
        this.setBiomeTextureIfNone((RegistryKey<Biome>)Biomes.field_76767_f, TextureSet.FOREST);
        this.setBiomeTextureIfNone((RegistryKey<Biome>)Biomes.field_185444_T, TextureSet.FOREST_FLOWERS);
        this.setBiomeTextureIfNone((RegistryKey<Biome>)Biomes.field_150583_P, TextureSet.BIRCH);
        this.setBiomeTextureIfNone((RegistryKey<Biome>)Biomes.field_185448_Z, TextureSet.TALL_BIRCH);
        this.setBiomeTextureIfNone((RegistryKey<Biome>)Biomes.field_150582_Q, TextureSet.BIRCH_HILLS);
        this.setBiomeTextureIfNone((RegistryKey<Biome>)Biomes.field_185429_aa, TextureSet.TALL_BIRCH_HILLS);
        this.setBiomeTextureIfNone((RegistryKey<Biome>)Biomes.field_76782_w, TextureSet.JUNGLE);
        this.setBiomeTextureIfNone((RegistryKey<Biome>)Biomes.field_185447_Y, TextureSet.JUNGLE_CLIFFS);
        this.setBiomeTextureIfNone((RegistryKey<Biome>)Biomes.field_76792_x, TextureSet.JUNGLE_HILLS);
        this.setBiomeTextureIfNone((RegistryKey<Biome>)Biomes.field_150574_L, TextureSet.JUNGLE_EDGE);
        this.setBiomeTextureIfNone((RegistryKey<Biome>)Biomes.field_76768_g, TextureSet.PINES);
        this.setBiomeTextureIfNone((RegistryKey<Biome>)Biomes.field_76784_u, TextureSet.PINES_HILLS);
        this.setBiomeTextureIfNone((RegistryKey<Biome>)Biomes.field_76784_u, TextureSet.PINES_HILLS);
        this.setBiomeTextureIfNone((RegistryKey<Biome>)Biomes.field_150584_S, TextureSet.SNOW_PINES);
        this.setBiomeTextureIfNone((RegistryKey<Biome>)Biomes.field_150579_T, TextureSet.SNOW_PINES_HILLS);
        this.setBiomeTextureIfNone((RegistryKey<Biome>)Biomes.field_185431_ac, TextureSet.SNOW_PINES_HILLS);
        this.setBiomeTextureIfNone((RegistryKey<Biome>)Biomes.field_150578_U, TextureSet.MEGA_TAIGA);
        this.setBiomeTextureIfNone((RegistryKey<Biome>)Biomes.field_185432_ad, TextureSet.MEGA_SPRUCE);
        this.setBiomeTextureIfNone((RegistryKey<Biome>)Biomes.field_150581_V, TextureSet.MEGA_TAIGA_HILLS);
        this.setBiomeTextureIfNone((RegistryKey<Biome>)Biomes.field_185433_ae, TextureSet.MEGA_SPRUCE_HILLS);
        this.setBiomeTextureIfNone((RegistryKey<Biome>)Biomes.field_235254_j_, TextureSet.CAVE_WALLS);
        this.setBiomeTextureIfNone((RegistryKey<Biome>)Biomes.field_235252_ay_, TextureSet.SOUL_SAND_VALLEY);
        this.setBiomeTextureIfNone((RegistryKey<Biome>)Biomes.field_235253_az_, TextureSet.FOREST);
        this.setBiomeTextureIfNone((RegistryKey<Biome>)Biomes.field_235250_aA_, TextureSet.JUNGLE);
        this.setBiomeTextureIfNone((RegistryKey<Biome>)Biomes.field_235251_aB_, TextureSet.MOUNTAINS_ALL);
        this.setBiomeTextureIfNone((RegistryKey<Biome>)Biomes.field_76779_k, TextureSet.END_VOID);
        this.setBiomeTextureIfNone((RegistryKey<Biome>)Biomes.field_76789_p, TextureSet.MUSHROOM);
        this.setBiomeTextureIfNone((RegistryKey<Biome>)Biomes.field_76788_q, TextureSet.SHORE);
        this.setBiomeTextureIfNone((RegistryKey<Biome>)Biomes.field_150607_aa, TextureSet.PLATEAU_MESA_TREES);
        this.setBiomeTextureIfNone((RegistryKey<Biome>)Biomes.field_150608_ab, TextureSet.PLATEAU_MESA);
        this.setBiomeTextureIfNone((RegistryKey<Biome>)Biomes.field_185437_ai, TextureSet.MESA);
        this.setBiomeTextureIfNone((RegistryKey<Biome>)Biomes.field_150589_Z, TextureSet.MESA);
        this.setBiomeTextureIfNone((RegistryKey<Biome>)Biomes.field_150588_X, TextureSet.SAVANNA);
        this.setBiomeTextureIfNone((RegistryKey<Biome>)Biomes.field_150587_Y, TextureSet.SAVANNA_PLATEAU);
        this.setBiomeTextureIfNone((RegistryKey<Biome>)Biomes.field_185435_ag, TextureSet.SAVANNA);
        this.setBiomeTextureIfNone((RegistryKey<Biome>)Biomes.field_185436_ah, TextureSet.SAVANNA_PLATEAU);
        this.setBiomeTextureIfNone((RegistryKey<Biome>)Biomes.field_203620_Z, TextureSet.ICE_SPIKES);
        for (Biome biome : WorldGenRegistries.field_243657_i) {
            BiomeTextureMap.instance().checkRegistration(biome);
        }
    }

    private void setBiomeTextureIfNone(RegistryKey<Biome> biome, TextureSet textureSet) {
        if (!textureMap.isRegistered(biome.func_240901_a_())) {
            textureMap.setTexture(biome.func_240901_a_(), textureSet);
        }
    }

    private void registerVanillaCustomTileTextures() {
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_VILLAGE_LIBRARY, TextureSet.LIBRARY);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_VILLAGE_SMITHY, TextureSet.SMITHY);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_VILLAGE_L_HOUSE, TextureSet.L_HOUSE);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_VILLAGE_FARMLAND_LARGE, TextureSet.FARMLAND_LARGE);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_VILLAGE_FARMLAND_SMALL, TextureSet.FARMLAND_SMALL);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_VILLAGE_WELL, TextureSet.WELL);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_VILLAGE_TORCH, TextureSet.VILLAGE_TORCH);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_VILLAGE_HUT, TextureSet.HUT);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_VILLAGE_SMALL_HOUSE, TextureSet.HOUSE_SMALL);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_VILLAGE_BUTCHERS_SHOP, TextureSet.BUTCHERS_SHOP);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_VILLAGE_CHURCH, TextureSet.CHURCH);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_LAVA, TextureSet.LAVA);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_LAVA_SHORE, TextureSet.LAVA_SHORE);
        this.setCustomTileTextureIfNone(ExtTileIdMap.NETHER_FORTRESS_BRIDGE_CROSSING, TextureSet.NETHER_BRIDGE);
        this.setCustomTileTextureIfNone(ExtTileIdMap.NETHER_BRIDGE_X, TextureSet.NETHER_BRIDGE_X);
        this.setCustomTileTextureIfNone(ExtTileIdMap.NETHER_BRIDGE_Z, TextureSet.NETHER_BRIDGE_Z);
        this.setCustomTileTextureIfNone(ExtTileIdMap.NETHER_BRIDGE_END_X, TextureSet.NETHER_BRIDGE_END_X);
        this.setCustomTileTextureIfNone(ExtTileIdMap.NETHER_BRIDGE_END_Z, TextureSet.NETHER_BRIDGE_END_Z);
        this.setCustomTileTextureIfNone(ExtTileIdMap.NETHER_FORTRESS_BRIDGE_SMALL_CROSSING, TextureSet.NETHER_BRIDGE_GATE);
        this.setCustomTileTextureIfNone(ExtTileIdMap.NETHER_FORTRESS_BRIDGE_STAIRS, TextureSet.NETHER_TOWER);
        this.setCustomTileTextureIfNone(ExtTileIdMap.NETHER_FORTRESS_WALL, TextureSet.NETHER_WALL);
        this.setCustomTileTextureIfNone(ExtTileIdMap.NETHER_FORTRESS_EXIT, TextureSet.NETHER_HALL);
        this.setCustomTileTextureIfNone(ExtTileIdMap.NETHER_FORTRESS_CORRIDOR_NETHER_WARTS_ROOM, TextureSet.NETHER_FORT_STAIRS);
        this.setCustomTileTextureIfNone(ExtTileIdMap.NETHER_FORTRESS_BRIDGE_PLATFORM, TextureSet.NETHER_THRONE);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_END_ISLAND, TextureSet.END_ISLAND);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_END_ISLAND_PLANTS, TextureSet.END_ISLAND_PLANTS);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_END_VOID, TextureSet.END_VOID);
        this.setCustomTileTextureIfNone(ExtTileIdMap.TILE_RAVINE, TextureSet.RAVINE);
    }

    private void setCustomTileTextureIfNone(ResourceLocation tileId, TextureSet textureSet) {
        if (!textureMap.isRegistered(tileId)) {
            textureMap.setTexture(tileId, textureSet);
        }
    }

    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        this.func_195410_a(resourceManager);
    }

    public void func_195410_a(IResourceManager resourceManager) {
        for (MarkerType type : MarkerType.REGISTRY) {
            type.initMips();
        }
    }
}

