/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.api.oldimpl;

import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.api.TileAPI;
import hunternif.mc.impl.atlas.client.BiomeTextureMap;
import hunternif.mc.impl.atlas.client.TextureSet;
import hunternif.mc.impl.atlas.client.TextureSetMap;
import hunternif.mc.impl.atlas.core.AtlasData;
import hunternif.mc.impl.atlas.ext.ExtTileTextureMap;
import hunternif.mc.impl.atlas.ext.TileDataStorage;
import hunternif.mc.impl.atlas.forge.event.TileIdRegisteredEvent;
import hunternif.mc.impl.atlas.network.packet.c2s.play.PutTileC2SPacket;
import hunternif.mc.impl.atlas.network.packet.s2c.play.CustomTileInfoS2CPacket;
import hunternif.mc.impl.atlas.network.packet.s2c.play.DeleteCustomGlobalTileS2CPacket;
import hunternif.mc.impl.atlas.network.packet.s2c.play.PutTileS2CPacket;
import hunternif.mc.impl.atlas.util.Log;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class TileApiImpl
implements TileAPI {
    private final Map<ResourceLocation, TileData> pendingTiles = new HashMap<ResourceLocation, TileData>();

    @SubscribeEvent
    public void ub(TileIdRegisteredEvent event) {
        this.onTileIdRegistered(event.getTileIds());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TextureSet registerTextureSet(ResourceLocation name, ResourceLocation ... textures) {
        TextureSet textureSet = new TextureSet(name, textures);
        TextureSetMap.instance().register(textureSet);
        return textureSet;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setBiomeTexture(Biome biome, ResourceLocation textureSetName, ResourceLocation ... textures) {
        TextureSet set = new TextureSet(textureSetName, textures);
        TextureSetMap.instance().register(set);
        BiomeTextureMap.instance().setTexture(biome, set);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setBiomeTexture(Biome biome, TextureSet textureSet) {
        BiomeTextureMap.instance().setTexture(biome, textureSet);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setCustomTileTexture(ResourceLocation uniqueTileName, ResourceLocation ... textures) {
        TextureSet set = new TextureSet(uniqueTileName, textures);
        TextureSetMap.instance().register(set);
        this.setCustomTileTexture(uniqueTileName, set);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setCustomTileTexture(ResourceLocation uniqueTileName, TextureSet textureSet) {
        ExtTileTextureMap.instance().setTexture(uniqueTileName, textureSet);
    }

    private void putTile(World world, int atlasID, ResourceLocation kind, int chunkX, int chunkZ) {
        RegistryKey dimension = world.func_234923_W_();
        if (world.field_72995_K) {
            new PutTileC2SPacket(atlasID, chunkX, chunkZ, kind).send();
        } else {
            AtlasData data = AntiqueAtlasMod.atlasData.getAtlasData(atlasID, world);
            data.setTile((RegistryKey<World>)dimension, chunkX, chunkZ, kind);
            for (PlayerEntity syncedPlayer : data.getSyncedPlayers()) {
                new PutTileS2CPacket(atlasID, (RegistryKey<World>)dimension, chunkX, chunkZ, kind).send((ServerPlayerEntity)syncedPlayer);
            }
        }
    }

    @Override
    public void putBiomeTile(World world, int atlasID, ResourceLocation biomeId, int chunkX, int chunkZ) {
        this.putTile(world, atlasID, biomeId, chunkX, chunkZ);
    }

    @Override
    public void putCustomTile(World world, int atlasID, ResourceLocation tileId, int chunkX, int chunkZ) {
        if (tileId == null) {
            Log.error("Attempted to put custom tile with null name", new Object[0]);
            return;
        }
        this.putTile(world, atlasID, tileId, chunkX, chunkZ);
    }

    @Override
    public void putCustomGlobalTile(World world, ResourceLocation tileId, int chunkX, int chunkZ) {
        if (tileId == null) {
            Log.error("Attempted to put custom global tile with null name", new Object[0]);
            return;
        }
        if (world.field_72995_K) {
            Log.warn("Client attempted to put global tile", new Object[0]);
            return;
        }
        TileDataStorage data = AntiqueAtlasMod.tileData.getData(world);
        data.setTile(chunkX, chunkZ, tileId);
        new CustomTileInfoS2CPacket((RegistryKey<World>)world.func_234923_W_(), chunkX, chunkZ, tileId).send(world.func_73046_m());
    }

    public void onTileIdRegistered(Collection<ResourceLocation> ids) {
        for (ResourceLocation id : ids) {
            TileData tile = this.pendingTiles.remove(id);
            if (tile == null) continue;
            this.putBiomeTile(tile.world, tile.atlasID, id, tile.x, tile.z);
        }
    }

    @Override
    public void deleteCustomGlobalTile(World world, int chunkX, int chunkZ) {
        if (world.field_72995_K) {
            Log.warn("Client attempted to delete global tile", new Object[0]);
            return;
        }
        TileDataStorage data = AntiqueAtlasMod.tileData.getData(world);
        if (data.getTile(chunkX, chunkZ) != null) {
            data.removeTile(chunkX, chunkZ);
            new DeleteCustomGlobalTileS2CPacket((RegistryKey<World>)world.func_234923_W_(), chunkX, chunkZ).send(world.func_73046_m());
        }
    }

    private static class TileData {
        final World world;
        final int atlasID;
        final int x;
        final int z;

        TileData(World world, int atlasID, int x, int z) {
            this.world = world;
            this.atlasID = atlasID;
            this.x = x;
            this.z = z;
        }
    }
}

