/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client;

import hunternif.mc.impl.atlas.client.TextureSet;
import hunternif.mc.impl.atlas.util.Log;
import hunternif.mc.impl.atlas.util.SaveData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BiomeTextureMap
extends SaveData {
    private static final BiomeTextureMap INSTANCE = new BiomeTextureMap();
    final Map<ResourceLocation, TextureSet> textureMap = new HashMap<ResourceLocation, TextureSet>();
    public static final TextureSet defaultTexture = TextureSet.PLAINS;

    public static BiomeTextureMap instance() {
        return INSTANCE;
    }

    public void setTexture(Biome biome, TextureSet textureSet) {
        this.setTexture(WorldGenRegistries.field_243657_i.func_177774_c((Object)biome), textureSet);
    }

    public void setTexture(ResourceLocation tileId, TextureSet textureSet) {
        if (textureSet == null) {
            if (this.textureMap.remove(tileId) != null) {
                Log.warn("Removing old texture for %d", tileId);
            }
            return;
        }
        TextureSet previous = this.textureMap.put(tileId, textureSet);
        if (previous == null) {
            this.markDirty();
        } else if (!previous.equals(textureSet)) {
            Log.warn("Overwriting texture set for %d", tileId);
            this.markDirty();
        }
    }

    private void autoRegister(Biome biome) {
        if (biome == null) {
            Log.warn("Biome is null", new Object[0]);
            return;
        }
        switch (biome.func_201856_r()) {
            case SWAMP: {
                this.setTexture(biome, biome.func_185360_m() >= 0.25f ? TextureSet.SWAMP_HILLS : TextureSet.SWAMP);
                break;
            }
            case OCEAN: 
            case RIVER: {
                this.setTexture(biome, biome.func_201851_b() == Biome.RainType.SNOW ? TextureSet.ICE : TextureSet.WATER);
                break;
            }
            case BEACH: {
                this.setTexture(biome, TextureSet.SHORE);
                break;
            }
            case JUNGLE: {
                this.setTexture(biome, biome.func_185360_m() >= 0.25f ? TextureSet.JUNGLE_HILLS : TextureSet.JUNGLE);
                break;
            }
            case SAVANNA: {
                this.setTexture(biome, biome.func_185355_j() >= 1.0f ? TextureSet.PLATEAU_SAVANNA : TextureSet.SAVANNA);
                break;
            }
            case MESA: {
                this.setTexture(biome, TextureSet.PLATEAU_MESA);
                break;
            }
            case FOREST: {
                this.setTexture(biome, biome.func_201851_b() == Biome.RainType.SNOW ? (biome.func_185360_m() >= 0.25f ? TextureSet.SNOW_PINES_HILLS : TextureSet.SNOW_PINES) : (biome.func_185360_m() >= 0.25f ? TextureSet.FOREST_HILLS : TextureSet.FOREST));
                break;
            }
            case PLAINS: {
                this.setTexture(biome, biome.func_201851_b() == Biome.RainType.SNOW ? (biome.func_185360_m() >= 0.25f ? TextureSet.SNOW_HILLS : TextureSet.SNOW) : (biome.func_185360_m() >= 0.25f ? TextureSet.HILLS : TextureSet.PLAINS));
                break;
            }
            case ICY: {
                this.setTexture(biome, biome.func_185360_m() >= 0.25f ? TextureSet.MOUNTAINS_SNOW_CAPS : TextureSet.ICE_SPIKES);
                break;
            }
            case DESERT: {
                this.setTexture(biome, biome.func_185360_m() >= 0.25f ? TextureSet.DESERT_HILLS : TextureSet.DESERT);
                break;
            }
            case TAIGA: {
                this.setTexture(biome, TextureSet.SNOW);
                break;
            }
            case EXTREME_HILLS: {
                this.setTexture(biome, biome.func_185360_m() >= 0.25f ? TextureSet.MOUNTAINS : TextureSet.HILLS);
                break;
            }
            case THEEND: {
                if (biome.func_242440_e().func_242498_c().size() > 1) {
                    this.setTexture(biome, TextureSet.END_ISLAND_PLANTS);
                    break;
                }
                this.setTexture(biome, TextureSet.END_ISLAND);
                break;
            }
            case NONE: {
                this.setTexture(biome, TextureSet.END_VOID);
                break;
            }
            default: {
                this.setTexture(biome, defaultTexture);
            }
        }
        Log.info("Auto-registered standard texture set for biome %s", WorldGenRegistries.field_243657_i.func_177774_c((Object)biome).toString());
    }

    public void checkRegistration(Biome biome) {
        if (!this.isRegistered(biome)) {
            this.autoRegister(biome);
            this.markDirty();
        }
    }

    private void checkRegistration(ResourceLocation id) {
        if (!this.isRegistered(id)) {
            this.setTexture(id, defaultTexture);
        }
    }

    public boolean isRegistered(Biome biome) {
        return this.isRegistered(WorldGenRegistries.field_243657_i.func_177774_c((Object)biome));
    }

    public boolean isRegistered(ResourceLocation id) {
        return this.textureMap.containsKey(id);
    }

    public TextureSet getTextureSet(ResourceLocation tile) {
        if (tile == null) {
            return defaultTexture;
        }
        Biome biome = (Biome)WorldGenRegistries.field_243657_i.func_82594_a(tile);
        if (biome != null) {
            this.checkRegistration(biome);
        } else {
            this.checkRegistration(tile);
        }
        return this.textureMap.get(tile);
    }

    public ResourceLocation getTexture(int variationNumber, ResourceLocation tile) {
        TextureSet set = this.getTextureSet(tile);
        return set.textures[variationNumber % set.textures.length];
    }

    public List<ResourceLocation> getAllTextures() {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        for (Map.Entry<ResourceLocation, TextureSet> entry : this.textureMap.entrySet()) {
            list.addAll(Arrays.asList(entry.getValue().textures));
        }
        return list;
    }
}

