/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.core;

import hunternif.mc.impl.atlas.core.IBiomeDetector;
import hunternif.mc.impl.atlas.ext.ExtTileIdMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;

public class BiomeDetectorBase
implements IBiomeDetector {
    private boolean doScanPonds = true;
    private boolean doScanRavines = true;
    private static final ResourceLocation waterPoolBiome = Biomes.field_76781_i.func_240901_a_();
    private static final int priorityRavine = 12;
    private static final int priorityWaterPool = 4;
    private static final int prioritylavaPool = 6;
    private static final int ravineMinDepth = 7;
    private static final Set<Biome> waterBiomes = new HashSet<Biome>();
    private static final Set<Biome> beachBiomes = new HashSet<Biome>();
    private static final Set<Biome> swampBiomes = new HashSet<Biome>();

    public static void scanBiomeTypes() {
        for (Biome biome : WorldGenRegistries.field_243657_i) {
            switch (biome.func_201856_r()) {
                case BEACH: {
                    beachBiomes.add(biome);
                    break;
                }
                case RIVER: 
                case OCEAN: {
                    waterBiomes.add(biome);
                    break;
                }
                case SWAMP: {
                    swampBiomes.add(biome);
                }
            }
        }
    }

    public void setScanPonds(boolean value) {
        this.doScanPonds = value;
    }

    public void setScanRavines(boolean value) {
        this.doScanRavines = value;
    }

    int priorityForBiome(Biome biome) {
        if (waterBiomes.contains(biome)) {
            return 4;
        }
        if (beachBiomes.contains(biome)) {
            return 3;
        }
        return 1;
    }

    protected static ResourceLocation getBiomeResourceLocation(World world, Biome biome) {
        return world.func_241828_r().func_243612_b(Registry.field_239720_u_).func_177774_c((Object)biome);
    }

    protected static void updateOccurrencesMap(Map<ResourceLocation, Integer> map, ResourceLocation biome, int weight) {
        int occurrence = map.getOrDefault(biome, 0) + weight;
        map.put(biome, occurrence);
    }

    protected static void updateOccurrencesMap(Map<ResourceLocation, Integer> map, World world, Biome biome, int weight) {
        ResourceLocation id = BiomeDetectorBase.getBiomeResourceLocation(world, biome);
        int occurrence = map.getOrDefault(id, 0) + weight;
        map.put(id, occurrence);
    }

    @Override
    public ResourceLocation getBiomeID(World world, IChunk chunk) {
        BiomeContainer chunkBiomes = chunk.func_225549_i_();
        HashMap<ResourceLocation, Integer> biomeOccurrences = new HashMap<ResourceLocation, Integer>(WorldGenRegistries.field_243657_i.func_148742_b().size());
        if (chunkBiomes == null) {
            return null;
        }
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int height;
                int y;
                Biome biome = chunkBiomes.func_225526_b_(x, 0, z);
                if (this.doScanPonds && (y = chunk.func_217303_b(Heightmap.Type.MOTION_BLOCKING).func_202273_a(x, z)) > 0) {
                    Block topBlock = chunk.func_180495_p(new BlockPos(x, y - 1, z)).func_177230_c();
                    if (topBlock == Blocks.field_150355_j && !swampBiomes.contains(biome)) {
                        BiomeDetectorBase.updateOccurrencesMap(biomeOccurrences, waterPoolBiome, 4);
                    } else if (topBlock == Blocks.field_150353_l) {
                        BiomeDetectorBase.updateOccurrencesMap(biomeOccurrences, ExtTileIdMap.TILE_LAVA, 6);
                    }
                }
                if (this.doScanRavines && (height = chunk.func_217303_b(Heightmap.Type.MOTION_BLOCKING).func_202273_a(x, z)) > 0 && height < world.func_181545_F() - 7) {
                    BiomeDetectorBase.updateOccurrencesMap(biomeOccurrences, ExtTileIdMap.TILE_RAVINE, 12);
                }
                BiomeDetectorBase.updateOccurrencesMap(biomeOccurrences, world, biome, this.priorityForBiome(biome));
            }
        }
        if (biomeOccurrences.isEmpty()) {
            return null;
        }
        Map.Entry meanBiome = Collections.max(biomeOccurrences.entrySet(), Comparator.comparingInt(Map.Entry::getValue));
        return (ResourceLocation)meanBiome.getKey();
    }
}

