/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.core;

import hunternif.mc.impl.atlas.core.ITileStorage;
import hunternif.mc.impl.atlas.util.Log;
import hunternif.mc.impl.atlas.util.Rect;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;

public class TileGroup
implements ITileStorage {
    public static final String TAG_POSITION = "p";
    public static final String TAG_TILES = "t";
    public static final int CHUNK_STEP = 16;
    Rect scope = new Rect(0, 0, 16, 16);
    ResourceLocation[][] tiles = new ResourceLocation[16][16];

    public TileGroup(int x, int y) {
        this.scope.minX = x;
        this.scope.minY = y;
        this.scope.maxX = this.scope.minX + 16 - 1;
        this.scope.maxY = this.scope.minY + 16 - 1;
    }

    public TileGroup() {
    }

    public TileGroup readFromNBT(CompoundNBT compound) {
        this.scope.minX = compound.func_74759_k(TAG_POSITION)[0];
        this.scope.minY = compound.func_74759_k(TAG_POSITION)[1];
        this.scope.maxX = this.scope.minX + 16 - 1;
        this.scope.maxY = this.scope.minY + 16 - 1;
        ListNBT listTag = compound.func_150295_c(TAG_TILES, 8);
        for (int y = 0; y < 16; ++y) {
            for (int x = 0; x < 16; ++x) {
                this.tiles[x][y] = ResourceLocation.func_208304_a((String)listTag.func_150307_f(x + y * 16));
            }
        }
        return this;
    }

    public CompoundNBT writeToNBT(CompoundNBT compound) {
        int[] pos = new int[]{this.scope.minX, this.scope.minY};
        ListNBT listTag = new ListNBT();
        for (int y = 0; y < 16; ++y) {
            for (int x = 0; x < 16; ++x) {
                listTag.add(x + y * 16, (INBT)StringNBT.func_229705_a_((String)(this.tiles[x][y] == null ? "antiqueatlas:%null#" : this.tiles[x][y].toString())));
            }
        }
        compound.func_74783_a(TAG_POSITION, pos);
        compound.func_218657_a(TAG_TILES, (INBT)listTag);
        return compound;
    }

    @Override
    public void setTile(int x, int y, ResourceLocation tile) {
        if (x >= this.scope.minX && y >= this.scope.minY && x <= this.scope.maxX && y <= this.scope.maxY) {
            int rx = x - this.scope.minX;
            int ry = y - this.scope.minY;
            this.tiles[rx][ry] = tile;
        } else {
            Log.warn("TileGroup tried to set tile out of bounds:\n\tbounds:" + this.scope + "\n\ttarget: x:" + x + ", y:" + y, new Object[0]);
        }
    }

    @Override
    public ResourceLocation removeTile(int x, int y) {
        ResourceLocation tmp = this.getTile(x, y);
        this.setTile(x, y, null);
        return tmp;
    }

    @Override
    public ResourceLocation getTile(int x, int y) {
        if (x >= this.scope.minX && y >= this.scope.minY && x <= this.scope.maxX && y <= this.scope.maxY) {
            int rx = x - this.scope.minX;
            int ry = y - this.scope.minY;
            return this.tiles[rx][ry];
        }
        return null;
    }

    @Override
    public boolean hasTileAt(int x, int y) {
        return this.getTile(x, y) != null;
    }

    @Override
    public Rect getScope() {
        return this.scope;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TileGroup)) {
            return false;
        }
        TileGroup other = (TileGroup)obj;
        if (!this.scope.equals(other.scope)) {
            return false;
        }
        for (int y = 0; y < 16; ++y) {
            for (int x = 0; x < 16; ++x) {
                ResourceLocation a = this.tiles[x][y];
                ResourceLocation b = other.tiles[x][y];
                if (a == null) {
                    if (b == null) continue;
                    return false;
                }
                if (this.tiles[x][y].equals((Object)other.tiles[x][y])) continue;
                return false;
            }
        }
        return true;
    }
}

