/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.ext;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.client.TextureSetMap;
import hunternif.mc.impl.atlas.ext.ExtTileTextureMap;
import hunternif.mc.impl.atlas.forge.IResourceReloadListener;
import hunternif.mc.impl.atlas.util.Log;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ExtTileTextureConfig
implements IResourceReloadListener<Map<String, String>> {
    private static final int VERSION = 1;
    private static final JsonParser PARSER = new JsonParser();
    private final TextureSetMap textureSetMap;
    private final ExtTileTextureMap extTileTextureMap;

    public ExtTileTextureConfig(ExtTileTextureMap extTileTextureMap, TextureSetMap textureSetMap) {
        this.extTileTextureMap = extTileTextureMap;
        this.textureSetMap = textureSetMap;
    }

    @Override
    public CompletableFuture<Map<String, String>> load(IResourceManager manager, IProfiler profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap map = new HashMap();
            try {
                for (IResource resource : manager.func_199004_b(new ResourceLocation("antiqueatlas:tile_textures.json"))) {
                    try {
                        InputStream stream = resource.func_199027_b();
                        Throwable throwable = null;
                        try {
                            InputStreamReader reader = new InputStreamReader(stream);
                            Throwable throwable2 = null;
                            try {
                                JsonElement element = PARSER.parse((Reader)reader);
                                if (element.isJsonObject()) {
                                    JsonObject obj = element.getAsJsonObject();
                                    if (!obj.has("version")) {
                                        Log.warn("Invalid tile texture file found!", new Object[0]);
                                        continue;
                                    }
                                    if (obj.get("version").getAsInt() < 1) {
                                        Log.warn("Outdated tile texture file version: " + obj.get("version").getAsInt(), new Object[0]);
                                        continue;
                                    }
                                    for (Map.Entry entry : obj.get("data").getAsJsonObject().entrySet()) {
                                        map.put(entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                    }
                                    continue;
                                }
                                Log.warn("Invalid tile texture file found!", new Object[0]);
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (reader == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                reader.close();
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (stream == null) continue;
                            if (throwable != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            stream.close();
                        }
                    }
                    catch (Throwable e) {
                        Log.warn(e, "Failed to read tile texture file!", new Object[0]);
                    }
                }
            }
            catch (Throwable e) {
                Log.warn(e, "Failed to read tile textures!", new Object[0]);
            }
            return map;
        });
    }

    @Override
    public CompletableFuture<Void> apply(Map<String, String> tileTexMap, IResourceManager manager, IProfiler profiler, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            for (Map.Entry entry : tileTexMap.entrySet()) {
                String tileName = (String)entry.getKey();
                String textureName = (String)entry.getValue();
                if (this.textureSetMap.isRegistered(textureName)) {
                    this.extTileTextureMap.setTexture(AntiqueAtlasMod.id(tileName), this.textureSetMap.getByName(AntiqueAtlasMod.id(textureName)));
                    Log.info("Registered texture set %s for tile \"%s\"", textureName, tileName);
                    continue;
                }
                Log.warn("Unknown texture set %s for tile \"%s\"", textureName, tileName);
            }
        });
    }
}

