/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.ext;

import hunternif.mc.impl.atlas.client.BiomeTextureMap;
import hunternif.mc.impl.atlas.client.TextureSet;
import hunternif.mc.impl.atlas.util.Log;
import hunternif.mc.impl.atlas.util.SaveData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ExtTileTextureMap
extends SaveData {
    private static final ExtTileTextureMap INSTANCE = new ExtTileTextureMap();
    final Map<ResourceLocation, TextureSet> textureMap = new HashMap<ResourceLocation, TextureSet>();

    public static ExtTileTextureMap instance() {
        return INSTANCE;
    }

    public void setTexture(ResourceLocation tileName, TextureSet textureSet) {
        if (textureSet == null) {
            Log.error("Texture set is null!", new Object[0]);
            return;
        }
        TextureSet previous = this.textureMap.put(tileName, textureSet);
        if (previous == null) {
            this.markDirty();
        } else if (!previous.equals(textureSet)) {
            Log.warn("Overwriting texture set for tile \"%s\"", tileName);
            this.markDirty();
        }
    }

    public TextureSet getTexture(ResourceLocation tileName) {
        TextureSet textureSet = this.textureMap.get(tileName);
        return textureSet == null ? BiomeTextureMap.defaultTexture : textureSet;
    }

    public boolean isRegistered(ResourceLocation tileName) {
        return this.textureMap.containsKey(tileName);
    }
}

