/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.ext.watcher.impl;

import com.google.common.collect.Sets;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.api.AtlasAPI;
import hunternif.mc.impl.atlas.ext.ExtTileIdMap;
import hunternif.mc.impl.atlas.ext.watcher.IStructureWatcher;
import hunternif.mc.impl.atlas.ext.watcher.StructureWatcher;
import hunternif.mc.impl.atlas.ext.watcher.WatcherPos;
import hunternif.mc.impl.atlas.util.MathUtil;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.Pair;

public class StructureWatcherFortress
implements IStructureWatcher {
    private static final String ROOFED = "NeSCLT";
    private static final String ROOFED2 = "NeSCR";
    private static final String ROOFED_STAIRS = "NeCCS";
    private static final String ROOFED3 = "NeCTB";
    private static final String ROOFED4 = "NeSC";
    private static final String BRIDGE_GATE = "NeRC";
    private static final String ROOFED_CROSS = "NeSCSC";
    private static final String BRIDGE_CROSS = "NeBCr";
    private static final String START = "NeStart";
    private static final String BRIDGE = "NeBS";
    private static final String BRIDGE_END = "NeBEF";
    private static final String ENTRANCE = "NeCE";
    private static final String WART_STAIRS = "NeCSR";
    private static final String THRONE = "NeMT";
    private static final String TOWER = "NeSR";
    private final Set<WatcherPos> visited = new HashSet<WatcherPos>();

    public StructureWatcherFortress() {
        StructureWatcher.INSTANCE.addWatcher(this);
    }

    @Override
    @Nonnull
    public Set<WatcherPos> getVisited() {
        return this.visited;
    }

    @Override
    public boolean isDimensionValid(ServerWorld world) {
        return world.func_234923_W_() == World.field_234919_h_;
    }

    @Override
    @Nullable
    public CompoundNBT getStructureData(@Nonnull ServerWorld world) {
        return null;
    }

    @Override
    @Nonnull
    public Set<Pair<WatcherPos, String>> visitStructure(@Nonnull World world, @Nonnull CompoundNBT structureTag) {
        HashSet visits = Sets.newHashSet();
        Set tagSet = structureTag.func_150296_c();
        for (String coords : tagSet) {
            WatcherPos pos;
            if (!WatcherPos.POS_PATTERN.matcher(coords).matches() || this.visited.contains(pos = new WatcherPos(coords))) continue;
            CompoundNBT tag = structureTag.func_74775_l(coords);
            this.visitFortress(world, tag);
            this.visited.add(pos);
            visits.add(Pair.of((Object)pos, (Object)"Nether Fortress"));
        }
        return visits;
    }

    private void visitFortress(World world, CompoundNBT tag) {
        ListNBT children = tag.func_150295_c("Children", 10);
        for (int i = 0; i < children.size(); ++i) {
            int chunkX;
            int chunkZ;
            CompoundNBT child = children.func_150305_b(i);
            String childID = child.func_74779_i("id");
            MutableBoundingBox boundingBox = new MutableBoundingBox(child.func_74759_k("BB"));
            if (BRIDGE.equals(childID)) {
                if (boundingBox.func_78883_b() > 16) {
                    ResourceLocation tileName = ExtTileIdMap.NETHER_BRIDGE_X;
                    chunkZ = MathUtil.getCenter(boundingBox).func_177952_p() >> 4;
                    for (int x = boundingBox.field_78897_a; x < boundingBox.field_78893_d; x += 16) {
                        int chunkX2 = x >> 4;
                        if (!StructureWatcherFortress.noTileAt(world, chunkX2, chunkZ)) continue;
                        AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX2, chunkZ);
                    }
                    continue;
                }
                ResourceLocation tileName = ExtTileIdMap.NETHER_BRIDGE_Z;
                chunkX = MathUtil.getCenter(boundingBox).func_177958_n() >> 4;
                for (int z = boundingBox.field_78896_c; z < boundingBox.field_78892_f; z += 16) {
                    int chunkZ2 = z >> 4;
                    if (!StructureWatcherFortress.noTileAt(world, chunkX, chunkZ2)) continue;
                    AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX, chunkZ2);
                }
                continue;
            }
            if (BRIDGE_END.equals(childID)) {
                int chunkZ3;
                ResourceLocation tileName;
                if (boundingBox.func_78883_b() > boundingBox.func_78880_d()) {
                    tileName = ExtTileIdMap.NETHER_BRIDGE_END_X;
                    chunkX = boundingBox.field_78897_a >> 4;
                    chunkZ3 = MathUtil.getCenter(boundingBox).func_177952_p() >> 4;
                } else {
                    tileName = ExtTileIdMap.NETHER_BRIDGE_END_Z;
                    chunkX = MathUtil.getCenter(boundingBox).func_177958_n() >> 4;
                    chunkZ3 = boundingBox.field_78896_c >> 4;
                }
                if (!StructureWatcherFortress.noTileAt(world, chunkX, chunkZ3)) continue;
                AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX, chunkZ3);
                continue;
            }
            int chunkX3 = MathUtil.getCenter(boundingBox).func_177958_n() >> 4;
            chunkZ = MathUtil.getCenter(boundingBox).func_177952_p() >> 4;
            if (BRIDGE_GATE.equals(childID)) {
                ResourceLocation tileName = ExtTileIdMap.NETHER_FORTRESS_BRIDGE_SMALL_CROSSING;
                AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX3, chunkZ);
                continue;
            }
            if (BRIDGE_CROSS.equals(childID) || START.equals(childID)) {
                ResourceLocation tileName = ExtTileIdMap.NETHER_FORTRESS_BRIDGE_CROSSING;
                AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX3, chunkZ);
                continue;
            }
            if (TOWER.equals(childID)) {
                ResourceLocation tileName = ExtTileIdMap.NETHER_FORTRESS_BRIDGE_STAIRS;
                AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX3, chunkZ);
                continue;
            }
            if (ENTRANCE.equals(childID)) {
                ResourceLocation tileName = ExtTileIdMap.NETHER_FORTRESS_EXIT;
                AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX3, chunkZ);
                continue;
            }
            if (WART_STAIRS.equals(childID)) {
                ResourceLocation tileName = ExtTileIdMap.NETHER_FORTRESS_CORRIDOR_NETHER_WARTS_ROOM;
                AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX3, chunkZ);
                continue;
            }
            if (THRONE.equals(childID)) {
                ResourceLocation tileName = ExtTileIdMap.NETHER_FORTRESS_BRIDGE_PLATFORM;
                AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX3, chunkZ);
                continue;
            }
            ResourceLocation tileName = ExtTileIdMap.NETHER_FORTRESS_WALL;
            if (!StructureWatcherFortress.noTileAt(world, chunkX3, chunkZ)) continue;
            AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX3, chunkZ);
        }
    }

    private static boolean noTileAt(World world, int chunkX, int chunkZ) {
        return AntiqueAtlasMod.tileData.getData(world).getTile(chunkX, chunkZ) == null;
    }
}

