/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.ext.watcher.impl;

import com.google.common.collect.Sets;
import hunternif.mc.impl.atlas.AntiqueAtlasConfig;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.api.AtlasAPI;
import hunternif.mc.impl.atlas.ext.watcher.IStructureWatcher;
import hunternif.mc.impl.atlas.ext.watcher.StructureWatcher;
import hunternif.mc.impl.atlas.ext.watcher.WatcherPos;
import hunternif.mc.impl.atlas.marker.Marker;
import hunternif.mc.impl.atlas.registry.MarkerType;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.Pair;

public class StructureWatcherGeneric
implements IStructureWatcher {
    private final Set<WatcherPos> visited = new HashSet<WatcherPos>();
    private final String datFileName;
    private MarkerType markerType;
    private MarkerType tileMarker;
    private ITextComponent markerLabel;
    private ITextComponent tileMarkerLabel;
    private final RegistryKey<World> dimension;

    public StructureWatcherGeneric(String datFileName, RegistryKey<World> dimType, MarkerType markerType, ITextComponent label) {
        this.markerType = markerType;
        this.markerLabel = label;
        this.dimension = dimType;
        this.datFileName = datFileName;
        StructureWatcher.INSTANCE.addWatcher(this);
    }

    @Override
    @Nonnull
    public Set<WatcherPos> getVisited() {
        return this.visited;
    }

    @Override
    public boolean isDimensionValid(ServerWorld world) {
        return this.dimension == world.func_234923_W_();
    }

    @Override
    @Nullable
    public CompoundNBT getStructureData(@Nonnull ServerWorld world) {
        return null;
    }

    @Override
    @Nonnull
    public Set<Pair<WatcherPos, String>> visitStructure(@Nonnull World world, @Nonnull CompoundNBT structureTag) {
        HashSet visits = Sets.newHashSet();
        Set tagSet = structureTag.func_150296_c();
        for (String coords : tagSet) {
            WatcherPos pos;
            if (!WatcherPos.POS_PATTERN.matcher(coords).matches() || this.visited.contains(pos = new WatcherPos(coords))) continue;
            CompoundNBT tag = structureTag.func_74775_l(coords);
            this.visit(world, tag);
            this.visited.add(pos);
            visits.add(Pair.of((Object)pos, (Object)this.datFileName));
        }
        return visits;
    }

    public StructureWatcherGeneric setTileMarker(MarkerType type, ITextComponent label) {
        this.tileMarker = type;
        this.tileMarkerLabel = label;
        return this;
    }

    private void visit(World world, CompoundNBT tag) {
        int chunkX = tag.func_74762_e("ChunkX");
        int chunkZ = tag.func_74762_e("ChunkZ");
        boolean foundMarker = false;
        boolean foundTileMarker = false;
        List<Marker> markers = AntiqueAtlasMod.globalMarkersData.getData().getMarkersAtChunk((RegistryKey<World>)world.func_234923_W_(), chunkX / 8, chunkZ / 8);
        if (markers != null) {
            for (Marker marker : markers) {
                if (!foundMarker && marker.getChunkX() == chunkX && marker.getChunkZ() == chunkZ && marker.getType().equals((Object)this.markerType)) {
                    foundMarker = true;
                }
                if (foundTileMarker || this.tileMarker == null || marker.getChunkX() != chunkX || marker.getChunkZ() != chunkZ || !marker.getType().equals((Object)this.tileMarker)) continue;
                foundTileMarker = true;
            }
        }
        if (((Boolean)AntiqueAtlasConfig.autoVillageMarkers.get()).booleanValue()) {
            if (!foundMarker) {
                AtlasAPI.markers.putGlobalMarker(world, false, this.markerType, this.markerLabel, (chunkX << 4) + 8, (chunkZ << 4) + 8);
            }
            if (this.tileMarker != null && !foundTileMarker) {
                AtlasAPI.markers.putGlobalMarker(world, false, this.markerType, this.tileMarkerLabel, (chunkX << 4) + 8, (chunkZ << 4) + 8);
            }
        }
    }
}

