/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.ext.watcher.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import hunternif.mc.impl.atlas.AntiqueAtlasConfig;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.api.AtlasAPI;
import hunternif.mc.impl.atlas.ext.ExtTileIdMap;
import hunternif.mc.impl.atlas.ext.watcher.IStructureWatcher;
import hunternif.mc.impl.atlas.ext.watcher.StructureWatcher;
import hunternif.mc.impl.atlas.ext.watcher.WatcherPos;
import hunternif.mc.impl.atlas.marker.Marker;
import hunternif.mc.impl.atlas.registry.MarkerType;
import hunternif.mc.impl.atlas.util.Log;
import hunternif.mc.impl.atlas.util.MathUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.Pair;

public class StructureWatcherVillage
implements IStructureWatcher {
    public static final String MARKER = "village";
    private static final String LIBRARY = "ViBH";
    private static final String SMITHY = "ViS";
    private static final String L_HOUSE = "ViTRH";
    private static final String FARMLAND_LARGE = "ViDF";
    private static final String FARMLAND_SMALL = "ViF";
    private static final String PATH = "ViSR";
    private static final String TORCH = "ViL";
    private static final String WELL = "ViW";
    private static final String START = "ViStart";
    private static final String BUTCHERS = "ViPH";
    private static final String HUT = "ViSmH";
    private static final String HOUSE_SMALL = "ViSH";
    private static final String CHURCH = "ViST";
    private static final Map<String, ResourceLocation> partToTileMap;
    private static final Map<ResourceLocation, Integer> tilePriority;
    private final Set<WatcherPos> visited = new HashSet<WatcherPos>();

    public StructureWatcherVillage() {
        StructureWatcher.INSTANCE.addWatcher(this);
    }

    @Override
    @Nonnull
    public Set<WatcherPos> getVisited() {
        return this.visited;
    }

    @Override
    public boolean isDimensionValid(ServerWorld world) {
        return world.func_234923_W_() == World.field_234918_g_;
    }

    @Override
    @Nullable
    public CompoundNBT getStructureData(@Nonnull ServerWorld world) {
        return null;
    }

    @Override
    @Nonnull
    public Set<Pair<WatcherPos, String>> visitStructure(@Nonnull World world, @Nonnull CompoundNBT structureTag) {
        Set tagSet = structureTag.func_150296_c();
        HashSet visits = Sets.newHashSet();
        for (String coords : tagSet) {
            WatcherPos pos;
            if (!WatcherPos.POS_PATTERN.matcher(coords).matches() || this.visited.contains(pos = new WatcherPos(coords))) continue;
            CompoundNBT tag = structureTag.func_74775_l(coords);
            this.visitVillage(world, tag);
            this.visited.add(pos);
            visits.add(Pair.of((Object)pos, (Object)"Village"));
        }
        return visits;
    }

    private void visitVillage(World world, CompoundNBT tag) {
        if (!tag.func_74767_n("Valid")) {
            StructureWatcherVillage.removeVillage(world, tag);
            return;
        }
        MarkerType villageType = (MarkerType)MarkerType.REGISTRY.func_82594_a(AntiqueAtlasMod.id(MARKER));
        if (villageType == null) {
            return;
        }
        ListNBT children = tag.func_150295_c("Children", 10);
        for (int i = 0; i < children.size(); ++i) {
            ResourceLocation tileName;
            CompoundNBT child = children.func_150305_b(i);
            String childID = child.func_74779_i("id");
            MutableBoundingBox boundingBox = new MutableBoundingBox(child.func_74759_k("BB"));
            int x = MathUtil.getCenter(boundingBox).func_177958_n();
            int z = MathUtil.getCenter(boundingBox).func_177952_p();
            int chunkX = x >> 4;
            int chunkZ = z >> 4;
            if (START.equals(childID)) {
                boolean foundMarker = false;
                for (int j = -1; j <= 1; ++j) {
                    block2: for (int k = -1; k <= 1; ++k) {
                        List<Marker> markers = AntiqueAtlasMod.globalMarkersData.getData().getMarkersAtChunk((RegistryKey<World>)world.func_234923_W_(), j + chunkX / 8, k + chunkZ / 8);
                        if (markers == null) continue;
                        for (Marker marker : markers) {
                            if (!marker.getType().equals((Object)villageType)) continue;
                            foundMarker = true;
                            continue block2;
                        }
                    }
                }
                if (!foundMarker && ((Boolean)AntiqueAtlasConfig.autoVillageMarkers.get()).booleanValue()) {
                    AtlasAPI.markers.putGlobalMarker(world, false, villageType, (ITextComponent)new TranslationTextComponent("gui.antiqueatlas.marker.village"), x, z);
                }
            }
            if ((tileName = partToTileMap.get(childID)) == null) continue;
            Integer curTilePriority = tilePriority.get(tileName);
            Integer prevTilePriority = tilePriority.get(StructureWatcherVillage.tileAt(world, chunkX, chunkZ));
            if (curTilePriority != null && prevTilePriority != null) {
                if (curTilePriority < prevTilePriority) continue;
                AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX, chunkZ);
                continue;
            }
            AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX, chunkZ);
        }
    }

    private static ResourceLocation tileAt(World world, int chunkX, int chunkZ) {
        return AntiqueAtlasMod.tileData.getData(world).getTile(chunkX, chunkZ);
    }

    private static void removeVillage(World world, CompoundNBT tag) {
        ListNBT children = tag.func_150295_c("Children", 10);
        for (int i = 0; i < children.size(); ++i) {
            List<Marker> markers;
            CompoundNBT child = children.func_150305_b(i);
            String childID = child.func_74779_i("id");
            MutableBoundingBox boundingBox = new MutableBoundingBox(child.func_74759_k("BB"));
            int x = MathUtil.getCenter(boundingBox).func_177958_n();
            int z = MathUtil.getCenter(boundingBox).func_177952_p();
            int chunkX = x >> 4;
            int chunkZ = z >> 4;
            if (START.equals(childID) && (markers = AntiqueAtlasMod.globalMarkersData.getData().getMarkersAtChunk((RegistryKey<World>)world.func_234923_W_(), chunkX / 8, chunkZ / 8)) != null) {
                for (Marker marker : markers) {
                    if (!marker.getType().equals((Object)"antiqueatlas:village")) continue;
                    AtlasAPI.markers.deleteGlobalMarker(world, marker.getId());
                    Log.info("Removed faux village marker", new Object[0]);
                    break;
                }
            }
            AtlasAPI.tiles.deleteCustomGlobalTile(world, chunkX, chunkZ);
            Log.info("Removed faux village tile", new Object[0]);
        }
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)LIBRARY, (Object)ExtTileIdMap.TILE_VILLAGE_LIBRARY);
        builder.put((Object)SMITHY, (Object)ExtTileIdMap.TILE_VILLAGE_SMITHY);
        builder.put((Object)L_HOUSE, (Object)ExtTileIdMap.TILE_VILLAGE_L_HOUSE);
        builder.put((Object)FARMLAND_LARGE, (Object)ExtTileIdMap.TILE_VILLAGE_FARMLAND_LARGE);
        builder.put((Object)FARMLAND_SMALL, (Object)ExtTileIdMap.TILE_VILLAGE_FARMLAND_SMALL);
        builder.put((Object)TORCH, (Object)ExtTileIdMap.TILE_VILLAGE_TORCH);
        builder.put((Object)WELL, (Object)ExtTileIdMap.TILE_VILLAGE_WELL);
        builder.put((Object)START, (Object)ExtTileIdMap.TILE_VILLAGE_WELL);
        builder.put((Object)BUTCHERS, (Object)ExtTileIdMap.TILE_VILLAGE_BUTCHERS_SHOP);
        builder.put((Object)HOUSE_SMALL, (Object)ExtTileIdMap.TILE_VILLAGE_SMALL_HOUSE);
        builder.put((Object)HUT, (Object)ExtTileIdMap.TILE_VILLAGE_HUT);
        builder.put((Object)CHURCH, (Object)ExtTileIdMap.TILE_VILLAGE_CHURCH);
        partToTileMap = builder.build();
        builder = new ImmutableMap.Builder();
        builder.put((Object)ExtTileIdMap.TILE_VILLAGE_LIBRARY, (Object)5);
        builder.put((Object)ExtTileIdMap.TILE_VILLAGE_SMITHY, (Object)6);
        builder.put((Object)ExtTileIdMap.TILE_VILLAGE_L_HOUSE, (Object)5);
        builder.put((Object)ExtTileIdMap.TILE_VILLAGE_FARMLAND_LARGE, (Object)3);
        builder.put((Object)ExtTileIdMap.TILE_VILLAGE_FARMLAND_SMALL, (Object)3);
        builder.put((Object)ExtTileIdMap.TILE_VILLAGE_TORCH, (Object)1);
        builder.put((Object)ExtTileIdMap.TILE_VILLAGE_WELL, (Object)7);
        builder.put((Object)ExtTileIdMap.TILE_VILLAGE_BUTCHERS_SHOP, (Object)4);
        builder.put((Object)ExtTileIdMap.TILE_VILLAGE_SMALL_HOUSE, (Object)4);
        builder.put((Object)ExtTileIdMap.TILE_VILLAGE_HUT, (Object)3);
        builder.put((Object)ExtTileIdMap.TILE_VILLAGE_CHURCH, (Object)6);
        tilePriority = builder.build();
    }
}

