/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.network.packet.s2c.play;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.marker.GlobalMarkersData;
import hunternif.mc.impl.atlas.marker.Marker;
import hunternif.mc.impl.atlas.marker.MarkersData;
import hunternif.mc.impl.atlas.network.packet.s2c.S2CPacket;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MarkersS2CPacket
extends S2CPacket {
    public static final ResourceLocation ID = AntiqueAtlasMod.id("packet", "s2c", "marker", "info");
    private static final int GLOBAL = -1;
    int atlasID;
    RegistryKey<World> world;
    ListMultimap<ResourceLocation, Marker.Precursor> markersByType;

    public MarkersS2CPacket(int atlasID, RegistryKey<World> world, ListMultimap<ResourceLocation, Marker.Precursor> markersByType) {
        this.atlasID = atlasID;
        this.world = world;
        this.markersByType = markersByType;
    }

    public MarkersS2CPacket(int atlasID, RegistryKey<World> world, Collection<Marker> markers) {
        this.atlasID = atlasID;
        this.world = world;
        ArrayListMultimap markersByType = ArrayListMultimap.create();
        for (Marker marker : markers) {
            markersByType.put((Object)marker.getType(), (Object)new Marker.Precursor(marker));
        }
        this.markersByType = markersByType;
    }

    public static void encode(MarkersS2CPacket msg, PacketBuffer packetBuffer) {
        packetBuffer.func_150787_b(msg.atlasID);
        packetBuffer.func_192572_a(msg.world.func_240901_a_());
        packetBuffer.func_150787_b(msg.markersByType.keySet().size());
        for (ResourceLocation type : msg.markersByType.keySet()) {
            packetBuffer.func_192572_a(type);
            List markerList = msg.markersByType.get((Object)type);
            packetBuffer.func_150787_b(markerList.size());
            for (Marker.Precursor marker : markerList) {
                new Marker(type, msg.world, marker).write(packetBuffer);
            }
        }
    }

    public static MarkersS2CPacket decode(PacketBuffer packetBuffer) {
        int atlasID = packetBuffer.func_150792_a();
        RegistryKey world = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)packetBuffer.func_192575_l());
        int typesLength = packetBuffer.func_150792_a();
        ArrayListMultimap markersByType = ArrayListMultimap.create();
        for (int i = 0; i < typesLength; ++i) {
            ResourceLocation type = packetBuffer.func_192575_l();
            int markersLength = packetBuffer.func_150792_a();
            for (int j = 0; j < markersLength; ++j) {
                markersByType.put((Object)type, (Object)new Marker.Precursor(packetBuffer));
            }
        }
        return new MarkersS2CPacket(atlasID, (RegistryKey<World>)world, (ListMultimap<ResourceLocation, Marker.Precursor>)markersByType);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean handle(ClientPlayerEntity player) {
        GlobalMarkersData markersData = this.atlasID == -1 ? AntiqueAtlasMod.globalMarkersData.getData() : AntiqueAtlasMod.markersData.getMarkersData(this.atlasID, player.func_130014_f_());
        for (ResourceLocation type : this.markersByType.keys()) {
            for (Marker.Precursor precursor : this.markersByType.get((Object)type)) {
                ((MarkersData)markersData).loadMarker(new Marker(type, this.world, precursor));
            }
        }
        return true;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }
}

