/*
 * Decompiled with CFR 0.152.
 */
package kenkron.antiqueatlasoverlay.event;

import com.mojang.blaze3d.matrix.MatrixStack;
import hunternif.mc.impl.atlas.AntiqueAtlasConfig;
import hunternif.mc.impl.atlas.RegistrarAntiqueAtlas;
import kenkron.antiqueatlasoverlay.OverlayRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.FirstPersonRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public abstract class FirstPersonRendererEvent {
    @OnlyIn(value=Dist.CLIENT)
    private static OverlayRenderer atlasOverlayRenderer = new OverlayRenderer();

    @OnlyIn(value=Dist.CLIENT)
    private static FirstPersonRenderer getFPR() {
        return Minecraft.func_71410_x().func_175597_ag();
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void renderItemInFirstPerson(RenderHandEvent event) {
        if (event.getItemStack().func_77973_b() == RegistrarAntiqueAtlas.ATLAS && !((Boolean)AntiqueAtlasConfig.enabled.get()).booleanValue()) {
            boolean flag = event.getHand() == Hand.MAIN_HAND;
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            HandSide handside = flag ? player.func_184591_cq() : player.func_184591_cq().func_188468_a();
            event.setCanceled(true);
            event.getMatrixStack().func_227860_a_();
            if (flag && FirstPersonRendererEvent.getFPR().field_187468_e.func_190926_b()) {
                FirstPersonRendererEvent.renderAtlasInBothHands(event.getMatrixStack(), event.getBuffers(), event.getLight(), event.getInterpolatedPitch(), event.getEquipProgress(), event.getSwingProgress());
            } else {
                FirstPersonRendererEvent.renderAtlasInOneHand(event.getMatrixStack(), event.getBuffers(), event.getLight(), event.getEquipProgress(), handside, event.getSwingProgress(), event.getItemStack());
            }
            event.getMatrixStack().func_227865_b_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderAtlasInBothHands(MatrixStack matrices, IRenderTypeBuffer vertexConsumers, int light, float pitch, float equipProgress, float swingProgress) {
        float f = MathHelper.func_76129_c((float)swingProgress);
        float g = -0.2f * MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI));
        float h = -0.4f * MathHelper.func_76126_a((float)(f * (float)Math.PI));
        matrices.func_227861_a_(0.0, (double)(-g / 2.0f), (double)h);
        float i = FirstPersonRendererEvent.getFPR().func_178100_c(pitch);
        matrices.func_227861_a_(0.0, (double)(0.04f + equipProgress * -1.2f + i * -0.5f), (double)-0.72f);
        matrices.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(i * -85.0f));
        if (!Minecraft.func_71410_x().field_71439_g.func_82150_aj()) {
            matrices.func_227860_a_();
            matrices.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
            FirstPersonRendererEvent.getFPR().func_228403_a_(matrices, vertexConsumers, light, HandSide.RIGHT);
            FirstPersonRendererEvent.getFPR().func_228403_a_(matrices, vertexConsumers, light, HandSide.LEFT);
            matrices.func_227865_b_();
        }
        float j = MathHelper.func_76126_a((float)(f * (float)Math.PI));
        matrices.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(j * 20.0f));
        matrices.func_227862_a_(0.5f, 0.5f, 1.0f);
        FirstPersonRendererEvent.renderFirstPersonAtlas(matrices, vertexConsumers, light, FirstPersonRendererEvent.getFPR().field_187467_d);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderAtlasInOneHand(MatrixStack matrices, IRenderTypeBuffer vertexConsumers, int light, float equipProgress, HandSide arm, float swingProgress, ItemStack item) {
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderFirstPersonAtlas(MatrixStack matrices, IRenderTypeBuffer vertexConsumers, int light, ItemStack mainHand) {
        matrices.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        matrices.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        matrices.func_227862_a_(0.38f, 0.38f, 0.38f);
        matrices.func_227861_a_(-1.85, -0.5, 0.0);
        matrices.func_227862_a_(0.0078125f, 0.0078125f, 0.0078125f);
        atlasOverlayRenderer.drawOverlay(matrices);
    }
}

