/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.gui;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import jds.bibliocraft.BiblioCraft;
import jds.bibliocraft.CommonProxy;
import jds.bibliocraft.gui.GuiBiblioTextField;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiRecipeBook
extends GuiScreen {
    private int guiImageWidth = 256;
    private int guiImageHeight = 158;
    private ItemStack recipeBook;
    private ItemStack[] bookGrid = new ItemStack[9];
    private ItemStack resultStack = null;
    private int heightOffset = 0;
    private int widthOffset = 0;
    private int[] ingredientCounts = new int[9];
    private String[] ingredientNames = new String[9];
    private int ingredientsTest;
    private GuiButton buttonSave;
    private GuiButton buttonSign;
    private GuiButton buttonSigned;
    private GuiButton buttonCancel;
    private GuiButton buttonCreate;
    private GuiBiblioTextField[] text = new GuiBiblioTextField[10];
    private boolean edited = false;
    private boolean signed = false;
    private boolean signing = false;
    private boolean onDesk = false;
    private int xcoord = 0;
    private int ycoord = 0;
    private int zcoord = 0;
    private int inventorySlot = 0;
    private boolean canCraft = false;

    public GuiRecipeBook(ItemStack book, boolean isOnDesk, int x, int y, int z, int slot, boolean canCraft) {
        this.recipeBook = book;
        this.onDesk = isOnDesk;
        this.xcoord = x;
        this.ycoord = y;
        this.zcoord = z;
        this.inventorySlot = slot;
        this.canCraft = canCraft;
        this.loadBookGrid();
        this.compareingredients();
    }

    private void loadBookGrid() {
        NBTTagCompound nbt = this.recipeBook.func_77978_p();
        if (nbt != null) {
            NBTTagList tagList = nbt.func_150295_c("grid", 10);
            this.bookGrid = new ItemStack[9];
            for (int i = 0; i < 9; ++i) {
                ItemStack nbtStack;
                NBTTagCompound tag = tagList.func_150305_b(i);
                byte slot = tag.func_74771_c("Slot");
                if (slot < 0 || slot >= 9 || (nbtStack = ItemStack.func_77949_a((NBTTagCompound)tag)) == null) continue;
                this.bookGrid[slot] = nbtStack;
            }
            NBTTagCompound resultTag = nbt.func_74775_l("result");
            if (resultTag != null) {
                this.resultStack = ItemStack.func_77949_a((NBTTagCompound)resultTag);
            }
            this.signed = nbt.func_74767_n("signed");
        }
    }

    private void saveText() {
        NBTTagCompound nbt = this.recipeBook.func_77978_p();
        if (nbt != null) {
            NBTTagList lines = new NBTTagList();
            for (int n = 0; n < 10; ++n) {
                lines.func_74742_a((NBTBase)new NBTTagString(this.text[n].getText()));
            }
            nbt.func_74782_a("text", (NBTBase)lines);
            nbt.func_74757_a("edited", true);
            this.recipeBook.func_77982_d(nbt);
        }
    }

    private void loadText() {
        NBTTagCompound nbt = this.recipeBook.func_77978_p();
        if (nbt != null) {
            NBTTagList lines = nbt.func_150295_c("text", 8);
            if (lines != null) {
                for (int n = 0; n < 10; ++n) {
                    this.text[n].setText(lines.func_150307_f(n));
                }
            }
            this.edited = nbt.func_74767_n("edited");
        }
    }

    public void compareingredients() {
        this.ingredientCounts = new int[9];
        this.ingredientNames = new String[9];
        NBTTagCompound nbt = this.recipeBook.func_77978_p();
        if (nbt != null) {
            NBTTagList tagList = nbt.func_150295_c("grid", 10);
            for (int i = 0; i < 9; ++i) {
                ItemStack nbtStack;
                NBTTagCompound tag = tagList.func_150305_b(i);
                byte slot = tag.func_74771_c("Slot");
                if (slot < 0 || slot >= 9 || (nbtStack = ItemStack.func_77949_a((NBTTagCompound)tag)) == null) continue;
                int n = 0;
                boolean complete = false;
                boolean havematch = false;
                for (int m = 0; m < this.ingredientNames.length; ++m) {
                    if (this.ingredientNames[m] == null || !this.ingredientNames[m].matches(nbtStack.func_82833_r())) continue;
                    n = m;
                    havematch = true;
                }
                if (havematch) {
                    int n2 = n;
                    this.ingredientCounts[n2] = this.ingredientCounts[n2] + 1;
                    continue;
                }
                while (!complete) {
                    if (this.ingredientCounts[n] == 0) {
                        int n3 = n;
                        this.ingredientCounts[n3] = this.ingredientCounts[n3] + 1;
                        this.ingredientNames[n] = nbtStack.func_82833_r();
                        complete = true;
                        continue;
                    }
                    if (n >= 8) continue;
                    ++n;
                }
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        int widthRender = (this.field_146294_l - this.guiImageWidth) / 2;
        int heightRender = (this.field_146295_m - this.guiImageHeight) / 2;
        if (this.signing) {
            this.buttonCancel = new GuiButton(2, widthRender + 70, heightRender + 130, 40, 20, StatCollector.func_74838_a((String)"gui.atlas.transfer.cancel"));
            this.field_146292_n.add(this.buttonCancel);
            this.buttonSigned = new GuiButton(3, widthRender + 20, heightRender + 130, 40, 20, StatCollector.func_74838_a((String)"gui.atlas.yes"));
            this.field_146292_n.add(this.buttonSigned);
        } else {
            if (!this.signed) {
                this.buttonSave = new GuiButton(0, widthRender + 70, heightRender + 130, 40, 20, StatCollector.func_74838_a((String)"book.save"));
                this.field_146292_n.add(this.buttonSave);
                this.buttonSign = new GuiButton(1, widthRender + 20, heightRender + 130, 40, 20, StatCollector.func_74838_a((String)"book.sign"));
                this.field_146292_n.add(this.buttonSign);
            }
            for (int n = 0; n < 10; ++n) {
                this.text[n] = new GuiBiblioTextField(this.field_146289_q, (int)((float)(widthRender + 12) * 1.25f), (int)((float)(heightRender + 22 + 10 * n) * 1.25f), 136, 10);
                this.text[n].setEnableBackgroundDrawing(false);
                this.text[n].setMaxStringLength(24);
                this.text[n].setTextColor(0);
            }
            this.loadText();
        }
        if (this.canCraft && this.resultStack != null && this.inventorySlot != -1) {
            this.buttonCreate = new GuiButton(4, widthRender + 212, heightRender + 58, 40, 20, "\u00a76" + StatCollector.func_74838_a((String)"gui.craft"));
            this.field_146292_n.add(this.buttonCreate);
        }
    }

    public void func_73863_a(int x, int y, float f) {
        int n;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(CommonProxy.RECIPEBOOKGUI);
        int widthRender = (this.field_146294_l - this.guiImageWidth) / 2;
        int heightRender = (this.field_146295_m - this.guiImageHeight) / 2;
        this.func_73729_b(widthRender, heightRender, 0, 0, this.guiImageWidth, this.guiImageHeight);
        super.func_73863_a(x, y, f);
        if (this.signing) {
            this.field_146289_q.func_85187_a(StatCollector.func_74838_a((String)"gui.recipe.areyousure"), widthRender + 20, heightRender + 48, 0x111111, false);
            this.field_146289_q.func_78279_b(StatCollector.func_74838_a((String)"gui.recipe.finalize"), widthRender + 20, heightRender + 68, 90, 0x5A5A5A);
        }
        GL11.glPushMatrix();
        GL11.glScaled((double)0.8, (double)0.8, (double)0.8);
        for (int i = 0; i < this.ingredientCounts.length; ++i) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.ingredientsTest = this.ingredientCounts[i];
            if (this.ingredientCounts[i] == 0) continue;
            this.field_146289_q.func_85187_a(this.ingredientCounts[i] + "x " + this.ingredientNames[i], (int)((float)(widthRender + 142) * 1.25f), (int)((float)(heightRender + 78 + 7 * i) * 1.25f), 0x111111, false);
        }
        if (this.resultStack != null) {
            this.field_146289_q.func_85187_a(this.resultStack.func_82833_r(), (int)((float)(widthRender + 14) * 1.25f), (int)((float)(heightRender + 10) * 1.25f), 0, false);
            this.field_146289_q.func_85187_a(this.resultStack.func_82833_r(), (int)((float)(widthRender + 142) * 1.25f), (int)((float)(heightRender + 10) * 1.25f), 0, false);
        }
        if (!this.signing) {
            for (n = 0; n < 10; ++n) {
                this.text[n].drawTextBox();
            }
        }
        GL11.glPopMatrix();
        if (this.resultStack != null) {
            GL11.glPushMatrix();
            GL11.glDisable((int)2896);
            field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.func_110434_K(), this.resultStack, widthRender + 224, heightRender + 37);
            GL11.glEnable((int)2896);
            GL11.glPopMatrix();
        }
        for (n = 0; n < 9; ++n) {
            if (this.bookGrid[n] == null) continue;
            switch (n) {
                case 0: {
                    this.widthOffset = 0;
                    this.heightOffset = 0;
                    break;
                }
                case 1: {
                    this.widthOffset = 18;
                    this.heightOffset = 0;
                    break;
                }
                case 2: {
                    this.widthOffset = 36;
                    this.heightOffset = 0;
                    break;
                }
                case 3: {
                    this.widthOffset = 0;
                    this.heightOffset = 18;
                    break;
                }
                case 4: {
                    this.widthOffset = 18;
                    this.heightOffset = 18;
                    break;
                }
                case 5: {
                    this.widthOffset = 36;
                    this.heightOffset = 18;
                    break;
                }
                case 6: {
                    this.widthOffset = 0;
                    this.heightOffset = 36;
                    break;
                }
                case 7: {
                    this.widthOffset = 18;
                    this.heightOffset = 36;
                    break;
                }
                case 8: {
                    this.widthOffset = 36;
                    this.heightOffset = 36;
                }
            }
            GL11.glPushMatrix();
            GL11.glDisable((int)2896);
            field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.func_110434_K(), this.bookGrid[n], widthRender + 142 + this.widthOffset, heightRender + 20 + this.heightOffset);
            GL11.glEnable((int)2896);
            GL11.glPopMatrix();
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (!this.edited && !this.text[0].isFocused()) {
            this.text[0].setText(StatCollector.func_74838_a((String)"gui.recipe.description"));
        }
    }

    protected void func_146284_a(GuiButton click) {
        if (click.field_146127_k == 0) {
            this.saveText();
            this.sendPacket();
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        if (click.field_146127_k == 1) {
            this.saveText();
            this.signing = true;
            this.func_73866_w_();
        }
        if (click.field_146127_k == 2) {
            this.signing = false;
            this.func_73866_w_();
        }
        if (click.field_146127_k == 3) {
            this.signed = true;
            this.signBook();
            this.sendPacket();
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        if (click.field_146127_k == 4) {
            this.sendRecipeCraftRecipe();
        }
    }

    private void sendRecipeCraftRecipe() {
        ByteBuf buffer = Unpooled.buffer();
        ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)this.recipeBook);
        buffer.writeInt(this.inventorySlot);
        if (!this.onDesk) {
            BiblioCraft.ch_BiblioClipboard.sendToServer(new FMLProxyPacket(buffer, "BiblioRecipeCraft"));
        }
    }

    private void signBook() {
        NBTTagCompound nbt = this.recipeBook.func_77978_p();
        if (nbt != null) {
            nbt.func_74757_a("signed", this.signed);
            this.recipeBook.func_77982_d(nbt);
        }
    }

    private void sendPacket() {
        ByteBuf buffer = Unpooled.buffer();
        ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)this.recipeBook);
        if (!this.onDesk) {
            BiblioCraft.ch_BiblioClipboard.sendToServer(new FMLProxyPacket(buffer, "BiblioUpdateInv"));
        } else {
            buffer.writeInt(this.xcoord);
            buffer.writeInt(this.ycoord);
            buffer.writeInt(this.zcoord);
            BiblioCraft.ch_BiblioMCBEdit.sendToServer(new FMLProxyPacket(buffer, "BiblioMCBEdit"));
        }
    }

    protected void func_73864_a(int x, int y, int click) {
        super.func_73864_a(x, y, click);
        if (!this.signed) {
            for (int n = 0; n < 10; ++n) {
                if (!this.text[n].mouseClicked((int)((float)x * 1.25f), (int)((float)y * 1.25f), click)) continue;
            }
            if (this.text[0].isFocused() && !this.edited) {
                this.text[0].setCursorPosition(0);
                this.text[0].setText("");
            }
        }
    }

    protected void func_73869_a(char par1, int key) {
        block7: {
            super.func_73869_a(par1, key);
            if (this.signed) break block7;
            if (key == 28 || key == 208) {
                for (int n = 0; n < 9; ++n) {
                    if (!this.text[n].isFocused()) continue;
                    this.text[n].setFocused(false);
                    this.text[n + 1].setFocused(true);
                    this.text[n + 1].setCursorPosition(this.text[n].getCursorPosition());
                    break;
                }
            } else if (key == 200) {
                for (int n = 1; n < 10; ++n) {
                    if (!this.text[n].isFocused()) continue;
                    this.text[n].setFocused(false);
                    this.text[n - 1].setFocused(true);
                    this.text[n - 1].setCursorPosition(this.text[n].getCursorPosition());
                    break;
                }
            } else {
                for (int n = 0; n < 10; ++n) {
                    if (!this.text[n].isFocused() || !this.text[n].textboxKeyTyped(par1, key) || n != 0) continue;
                    this.edited = true;
                }
            }
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }
}

