/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.blocks;

import java.util.List;
import jds.bibliocraft.BlockLoader;
import jds.bibliocraft.Config;
import jds.bibliocraft.blocks.BiblioBlock;
import jds.bibliocraft.states.TextureProperty;
import jds.bibliocraft.states.TextureState;
import jds.bibliocraft.tileentities.BiblioTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BiblioWoodBlock
extends BiblioBlock {
    public static PropertyEnum WOOD_TYPE;
    private boolean isHalfBlock = false;

    public BiblioWoodBlock(String name, boolean isHalfBlock) {
        super(Material.field_151575_d, Block.field_149766_f, BlockLoader.biblioTab, name);
        this.isHalfBlock = isHalfBlock;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List subItems) {
        for (int x = 0; x <= 6; ++x) {
            subItems.add(new ItemStack(item, 1, x));
        }
    }

    @Override
    public ItemStack getPickBlockExtras(ItemStack stack, World world, BlockPos pos) {
        String customTexture;
        BiblioTileEntity tile;
        TileEntity wtile = world.func_175625_s(pos);
        if (!(wtile == null || !(wtile instanceof BiblioTileEntity) || (tile = (BiblioTileEntity)wtile).func_145832_p() != 6 || (customTexture = tile.getCustomTextureString()).equals("none") && customTexture.equals(""))) {
            NBTTagCompound tags = new NBTTagCompound();
            tags.func_74778_a("renderTexture", customTexture);
            stack.func_77982_d(tags);
        }
        return stack;
    }

    @Override
    protected BlockState func_180661_e() {
        WOOD_TYPE = PropertyEnum.func_177709_a((String)"woodtype", EnumWoodType.class);
        return new ExtendedBlockState((Block)this, new IProperty[]{WOOD_TYPE}, new IUnlistedProperty[]{OBJModel.OBJProperty.instance, TextureProperty.instance});
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        EnumWoodType wood = EnumWoodType.getEnum(meta);
        return this.func_176223_P().func_177226_a((IProperty)WOOD_TYPE, (Comparable)((Object)wood));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        EnumWoodType wood = (EnumWoodType)((Object)state.func_177229_b((IProperty)WOOD_TYPE));
        return wood.getID();
    }

    @Override
    public ExtendedBlockState getExtendedBlockStateAlternate(ExtendedBlockState state) {
        return new ExtendedBlockState((Block)this, new IProperty[]{WOOD_TYPE}, new IUnlistedProperty[]{OBJModel.OBJProperty.instance, TextureProperty.instance});
    }

    @Override
    public IExtendedBlockState getIExtendedBlockStateAlternate(BiblioTileEntity biblioTile, IExtendedBlockState state) {
        TextureState textureString = new TextureState(biblioTile.getCustomTextureString());
        textureString = this.addAdditionTextureStateInformation(biblioTile, textureString);
        state = state.withProperty((IUnlistedProperty)TextureProperty.instance, (Object)textureString);
        return state;
    }

    public TextureState addAdditionTextureStateInformation(BiblioTileEntity tile, TextureState state) {
        return state;
    }

    @Override
    public IBlockState getFinalBlockstate(IBlockState state, IBlockState newState) {
        EnumWoodType wood = (EnumWoodType)((Object)state.func_177229_b((IProperty)WOOD_TYPE));
        return newState.func_177226_a((IProperty)WOOD_TYPE, (Comparable)((Object)wood));
    }

    @Override
    public abstract boolean onBlockActivatedCustomCommands(World var1, BlockPos var2, IBlockState var3, EntityPlayer var4, EnumFacing var5, float var6, float var7, float var8);

    @Override
    public abstract TileEntity func_149915_a(World var1, int var2);

    @Override
    public abstract List<String> getModelParts(BiblioTileEntity var1);

    @Override
    public abstract void additionalPlacementCommands(BiblioTileEntity var1, EntityLivingBase var2);

    public void func_180654_a(IBlockAccess blockAccess, BlockPos pos) {
        TileEntity tile = blockAccess.func_175625_s(pos);
        if (this.isHalfBlock && tile != null && tile instanceof BiblioTileEntity) {
            BiblioTileEntity biblioTile = (BiblioTileEntity)tile;
            float shift = 0.0f;
            switch (biblioTile.getShiftPosition()) {
                case NO_SHIFT: {
                    shift = 0.0f;
                    break;
                }
                case HALF_SHIFT: {
                    shift = 0.25f;
                    break;
                }
                case FULL_SHIFT: {
                    shift = 0.5f;
                }
            }
            switch (biblioTile.getAngle()) {
                case SOUTH: {
                    this.func_149676_a(0.5f - shift, 0.0f, 0.0f, 1.0f - shift, 1.0f, 1.0f);
                    break;
                }
                case WEST: {
                    this.func_149676_a(0.0f, 0.0f, 0.5f - shift, 1.0f, 1.0f, 1.0f - shift);
                    break;
                }
                case NORTH: {
                    this.func_149676_a(0.0f + shift, 0.0f, 0.0f, 0.5f + shift, 1.0f, 1.0f);
                    break;
                }
                case EAST: {
                    this.func_149676_a(0.0f, 0.0f, 0.0f + shift, 1.0f, 1.0f, 0.5f + shift);
                    break;
                }
                default: {
                    this.func_149676_a(0.0f + shift, 0.0f, 0.0f, 0.5f + shift, 1.0f, 1.0f);
                    break;
                }
            }
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public int getLightValue(IBlockAccess world, BlockPos pos) {
        int output = 0;
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof BiblioTileEntity && Config.emitLight) {
            BiblioTileEntity tile = (BiblioTileEntity)te;
            for (int i = 0; i < tile.inventory.length; ++i) {
                int light;
                Block block;
                ItemStack stack = tile.func_70301_a(i);
                if (stack == null || (block = Block.func_149634_a((Item)stack.func_77973_b())) == null || (light = block.func_149750_m()) <= output) continue;
                output = light;
            }
        }
        return output;
    }

    public static enum EnumWoodType implements IStringSerializable
    {
        OAK(0, "Oak", "minecraft:blocks/planks_oak"),
        SPRUCE(1, "Spruce", "minecraft:blocks/planks_spruce"),
        BIRCH(2, "Birch", "minecraft:blocks/planks_birch"),
        JUNGLE(3, "Jungle", "minecraft:blocks/planks_jungle"),
        ACACIA(4, "Acacia", "minecraft:blocks/planks_acacia"),
        DARKOAK(5, "DarkOak", "minecraft:blocks/planks_big_oak"),
        FRAME(6, "Framed", "bibliocraft:blocks/frame");

        private int ID;
        private String name;
        private String textureString;
        private static final EnumWoodType[] META_LOOKUP;

        private EnumWoodType(int ID, String name, String texture) {
            this.ID = ID;
            this.name = name;
            this.textureString = texture;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getID() {
            return this.ID;
        }

        public String getTextureString() {
            return this.textureString;
        }

        public String toString() {
            return this.func_176610_l();
        }

        public static EnumWoodType getEnum(int meta) {
            EnumWoodType thing = OAK;
            switch (meta) {
                case 0: {
                    thing = OAK;
                    break;
                }
                case 1: {
                    thing = SPRUCE;
                    break;
                }
                case 2: {
                    thing = BIRCH;
                    break;
                }
                case 3: {
                    thing = JUNGLE;
                    break;
                }
                case 4: {
                    thing = ACACIA;
                    break;
                }
                case 5: {
                    thing = DARKOAK;
                    break;
                }
                case 6: {
                    thing = FRAME;
                }
            }
            return thing;
        }

        static {
            META_LOOKUP = new EnumWoodType[EnumWoodType.values().length];
            EnumWoodType[] enumWoodTypeArray = EnumWoodType.values();
            int n = enumWoodTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumWoodType wood;
                EnumWoodType.META_LOOKUP[wood.getID()] = wood = enumWoodTypeArray[i];
            }
        }
    }
}

