/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.blocks;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import jds.bibliocraft.BiblioCraft;
import jds.bibliocraft.blocks.BiblioWoodBlock;
import jds.bibliocraft.helpers.EnumShiftPosition;
import jds.bibliocraft.helpers.EnumVertPosition;
import jds.bibliocraft.tileentities.BiblioTileEntity;
import jds.bibliocraft.tileentities.TileEntityFancySign;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.TRSRTransformation;

public class BlockFancySign
extends BiblioWoodBlock {
    public static final String name = "FancySign";
    public static final BlockFancySign instance = new BlockFancySign();

    public BlockFancySign() {
        super(name, false);
    }

    @Override
    public boolean onBlockActivatedCustomCommands(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && player.func_70093_af()) {
            player.openGui((Object)BiblioCraft.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityFancySign();
    }

    @Override
    public List<String> getModelParts(BiblioTileEntity tile) {
        ArrayList<String> modelParts = new ArrayList<String>();
        modelParts.add("sign");
        modelParts.add("front");
        if (tile.getVertPosition() == EnumVertPosition.FLOOR) {
            modelParts.add("feetBottom");
        }
        if (tile.getVertPosition() == EnumVertPosition.CEILING) {
            modelParts.add("feetTop");
        }
        return modelParts;
    }

    @Override
    public void additionalPlacementCommands(BiblioTileEntity biblioTile, EntityLivingBase player) {
        int pitch = MathHelper.func_76128_c((double)((double)(player.field_70125_A * 3.0f / 180.0f) + 0.5)) & 3;
        ++pitch;
        if ((pitch %= 4) == 0) {
            biblioTile.setVertPosition(EnumVertPosition.CEILING);
        } else if (pitch == 1) {
            biblioTile.setVertPosition(EnumVertPosition.WALL);
        } else {
            biblioTile.setVertPosition(EnumVertPosition.FLOOR);
        }
    }

    @Override
    public TRSRTransformation getAdditionalTransforms(TRSRTransformation transform, BiblioTileEntity tile) {
        transform = transform.compose(new TRSRTransformation(new Vector3f(-0.0f, 0.0f, -0.0f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f)));
        if (tile.getShiftPosition() == EnumShiftPosition.HALF_SHIFT) {
            transform = transform.compose(new TRSRTransformation(new Vector3f(-0.178f, 0.0f, 0.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f)));
        } else if (tile.getShiftPosition() == EnumShiftPosition.FULL_SHIFT) {
            transform = transform.compose(new TRSRTransformation(new Vector3f(-0.427f, 0.0f, 0.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f)));
        }
        return transform;
    }

    @Override
    public void func_180654_a(IBlockAccess blockAccess, BlockPos pos) {
        TileEntity tile = blockAccess.func_175625_s(pos);
        if (tile != null && tile instanceof TileEntityFancySign) {
            TileEntityFancySign sign = (TileEntityFancySign)tile;
            EnumShiftPosition shift = sign.getShiftPosition();
            switch (sign.getAngle()) {
                case SOUTH: {
                    if (shift == EnumShiftPosition.NO_SHIFT) {
                        this.func_149676_a(0.94f, 0.2f, 0.0f, 1.0f, 0.8f, 1.0f);
                        break;
                    }
                    if (shift == EnumShiftPosition.HALF_SHIFT) {
                        this.func_149676_a(0.51f, 0.2f, 0.0f, 0.57f, 0.8f, 1.0f);
                        break;
                    }
                    if (shift != EnumShiftPosition.FULL_SHIFT) break;
                    this.func_149676_a(0.07f, 0.2f, 0.0f, 0.01f, 0.8f, 1.0f);
                    break;
                }
                case WEST: {
                    if (shift == EnumShiftPosition.NO_SHIFT) {
                        this.func_149676_a(0.0f, 0.2f, 0.94f, 1.0f, 0.8f, 1.0f);
                        break;
                    }
                    if (shift == EnumShiftPosition.HALF_SHIFT) {
                        this.func_149676_a(0.0f, 0.2f, 0.51f, 1.0f, 0.8f, 0.57f);
                        break;
                    }
                    if (shift != EnumShiftPosition.FULL_SHIFT) break;
                    this.func_149676_a(0.0f, 0.2f, 0.07f, 1.0f, 0.8f, 0.01f);
                    break;
                }
                case NORTH: {
                    if (shift == EnumShiftPosition.NO_SHIFT) {
                        this.func_149676_a(0.0f, 0.2f, 0.0f, 0.06f, 0.8f, 1.0f);
                        break;
                    }
                    if (shift == EnumShiftPosition.HALF_SHIFT) {
                        this.func_149676_a(0.43f, 0.2f, 0.0f, 0.49f, 0.8f, 1.0f);
                        break;
                    }
                    if (shift != EnumShiftPosition.FULL_SHIFT) break;
                    this.func_149676_a(0.93f, 0.2f, 0.0f, 0.99f, 0.8f, 1.0f);
                    break;
                }
                case EAST: {
                    if (shift == EnumShiftPosition.NO_SHIFT) {
                        this.func_149676_a(0.0f, 0.2f, 0.0f, 1.0f, 0.8f, 0.06f);
                        break;
                    }
                    if (shift == EnumShiftPosition.HALF_SHIFT) {
                        this.func_149676_a(0.0f, 0.2f, 0.43f, 1.0f, 0.8f, 0.49f);
                        break;
                    }
                    if (shift != EnumShiftPosition.FULL_SHIFT) break;
                    this.func_149676_a(0.0f, 0.2f, 0.93f, 1.0f, 0.8f, 0.99f);
                    break;
                }
            }
        } else {
            this.func_149676_a(0.0f, 0.2f, 0.0f, 0.1f, 0.8f, 1.0f);
        }
    }
}

