/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.blocks;

import java.util.ArrayList;
import java.util.List;
import jds.bibliocraft.blocks.BiblioSimpleBlock;
import jds.bibliocraft.helpers.EnumColor;
import jds.bibliocraft.items.ItemAtlas;
import jds.bibliocraft.items.ItemAtlasPlate;
import jds.bibliocraft.items.ItemEnchantedPlate;
import jds.bibliocraft.items.ItemPlate;
import jds.bibliocraft.tileentities.BiblioTileEntity;
import jds.bibliocraft.tileentities.TileEntityPrintPress;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBook;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BlockPrintingPress
extends BiblioSimpleBlock {
    public static final String name = "PrintingPress";
    public static final BlockPrintingPress instance = new BlockPrintingPress();
    public static final PropertyEnum COLOR = PropertyEnum.func_177709_a((String)"color", EnumColor.class);

    public BlockPrintingPress() {
        super(Material.field_151573_f, Block.field_149788_p, name);
    }

    @Override
    public boolean onBlockActivatedCustomCommands(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity t = world.func_175625_s(pos);
        if (!world.field_72995_K && t != null && t instanceof TileEntityPrintPress) {
            TileEntityPrintPress tile = (TileEntityPrintPress)t;
            int slot = BlockPrintingPress.getSlot(tile, side, hitX, hitZ);
            ItemStack playerhand = player.func_70694_bm();
            switch (slot) {
                case 0: {
                    if (playerhand != null && tile.isInk(playerhand)) {
                        tile.addStackToInventoryFromWorld(playerhand, slot, player);
                        break;
                    }
                    tile.removeStackFromInventoryFromWorld(slot, player, this);
                    break;
                }
                case 1: {
                    if (playerhand != null && (playerhand.func_77973_b() instanceof ItemPlate || playerhand.func_77973_b() instanceof ItemEnchantedPlate || playerhand.func_77973_b() instanceof ItemAtlasPlate)) {
                        tile.addStackToInventoryFromWorld(playerhand, slot, player);
                        break;
                    }
                    tile.removeStackFromInventoryFromWorld(slot, player, this);
                    break;
                }
                case 2: {
                    if (playerhand != null && (playerhand.func_77973_b() instanceof ItemBook || playerhand.func_77973_b() instanceof ItemAtlas)) {
                        tile.addStackToInventoryFromWorld(playerhand, slot, player);
                        break;
                    }
                    tile.removeStackFromInventoryFromWorld(slot, player, this);
                    break;
                }
                case 3: {
                    tile.removeStackFromInventoryFromWorld(slot, player, this);
                }
            }
        }
        return true;
    }

    public static int getSlot(TileEntityPrintPress tile, EnumFacing face, float hitX, float hitZ) {
        int output = -1;
        if (face != EnumFacing.UP) {
            return output;
        }
        float adjustedX = hitX;
        float adjustedZ = hitZ;
        switch (tile.getAngle()) {
            case WEST: {
                adjustedX = hitZ;
                adjustedZ = 1.0f - hitX;
                break;
            }
            case NORTH: {
                adjustedX = 1.0f - hitX;
                adjustedZ = 1.0f - hitZ;
                break;
            }
            case EAST: {
                adjustedX = 1.0f - hitZ;
                adjustedZ = hitX;
                break;
            }
        }
        output = (double)adjustedX <= 0.33 ? ((double)adjustedZ > 0.5 ? 3 : 2) : ((double)adjustedX > 0.7 ? 0 : 1);
        return output;
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityPrintPress();
    }

    @Override
    public List<String> getModelParts(BiblioTileEntity tile) {
        ArrayList<String> modelParts = new ArrayList<String>();
        modelParts.add("press");
        ItemStack plate = tile.func_70301_a(1);
        ItemStack input = tile.func_70301_a(2);
        ItemStack output = tile.func_70301_a(3);
        if (plate != null) {
            modelParts.add("plate");
        }
        if (input != null) {
            int stacksize = input.field_77994_a;
            if (stacksize > 0) {
                modelParts.add("book1");
            }
            if (stacksize > 16) {
                modelParts.add("book2");
            }
            if (stacksize > 32) {
                modelParts.add("book3");
            }
            if (stacksize > 48) {
                modelParts.add("book4");
            }
        }
        if (output != null) {
            if (output.func_77973_b() instanceof ItemEnchantedBook) {
                modelParts.add("bookEnchant");
            } else {
                modelParts.add("bookBlue");
            }
        }
        return modelParts;
    }

    @Override
    public ExtendedBlockState getExtendedBlockStateAlternate(ExtendedBlockState state) {
        ExtendedBlockState exstate = new ExtendedBlockState((Block)this, new IProperty[]{COLOR}, new IUnlistedProperty[]{OBJModel.OBJProperty.instance});
        return exstate;
    }

    @Override
    public IExtendedBlockState getIExtendedBlockStateAlternate(BiblioTileEntity biblioTile, IExtendedBlockState state) {
        EnumColor color = EnumColor.getColorEnumFromID(this.getInkquantity(biblioTile));
        state = (IExtendedBlockState)state.func_177226_a((IProperty)COLOR, (Comparable)((Object)color));
        return state;
    }

    private int getInkquantity(BiblioTileEntity biblioTile) {
        int output = 0;
        ItemStack ink = biblioTile.func_70301_a(0);
        if (ink != null) {
            int size = ink.field_77994_a;
            if (size > 0 && size < 8) {
                output = 1;
            }
            if (size > 7 && size < 16) {
                output = 2;
            }
            if (size > 15 && size < 24) {
                output = 3;
            }
            if (size > 23 && size < 32) {
                output = 4;
            }
            if (size > 31 && size < 40) {
                output = 5;
            }
            if (size > 39 && size < 48) {
                output = 6;
            }
            if (size > 47 && size < 56) {
                output = 7;
            }
            if (size > 55) {
                return 8;
            }
        }
        return output;
    }
}

