/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.blocks;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import jds.bibliocraft.BiblioCraft;
import jds.bibliocraft.blocks.BiblioWoodBlock;
import jds.bibliocraft.tileentities.BiblioTileEntity;
import jds.bibliocraft.tileentities.TileEntityShelf;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.TRSRTransformation;

public class BlockShelf
extends BiblioWoodBlock {
    public static final String name = "Shelf";
    public static final BlockShelf instance = new BlockShelf();

    public BlockShelf() {
        super(name, true);
    }

    @Override
    public boolean onBlockActivatedCustomCommands(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            ItemStack playerhand = player.func_70694_bm();
            BiblioTileEntity biblioTile = (BiblioTileEntity)world.func_175625_s(pos);
            if (biblioTile instanceof TileEntityShelf) {
                TileEntityShelf tile = (TileEntityShelf)biblioTile;
                if (player.func_70093_af()) {
                    player.openGui((Object)BiblioCraft.instance, 3, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    return true;
                }
                int slot = BlockShelf.getSlotNumberFromClickon2x2block(tile.getAngle(), hitX, hitY, hitZ);
                boolean testValue = false;
                if (slot >= 0 && !player.func_70093_af()) {
                    if (playerhand != null) {
                        testValue = tile.addStackToInventoryFromWorld(playerhand, slot, player);
                    }
                    if (!testValue) {
                        testValue = tile.removeStackFromInventoryFromWorld(slot, player, this);
                    }
                }
                if (!testValue) {
                    player.openGui((Object)BiblioCraft.instance, 3, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                return true;
            }
        }
        return true;
    }

    @Override
    public void additionalPlacementCommands(BiblioTileEntity biblioTile, EntityLivingBase player) {
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityShelf();
    }

    @Override
    public List<String> getModelParts(BiblioTileEntity tile) {
        TileEntityShelf shelf;
        boolean hasTop;
        ArrayList<String> modelParts = Lists.newArrayList((Object[])new String[]{"OBJModel.Group.All.Key"});
        if (tile instanceof TileEntityShelf && !(hasTop = (shelf = (TileEntityShelf)tile).getTop())) {
            modelParts = new ArrayList<String>();
            modelParts.add("shelf_bottom");
        }
        return modelParts;
    }

    private boolean checkIfIsBackOfBlock(int angle, int face) {
        boolean angle4;
        boolean angle1 = angle == 0 && face == 5;
        boolean angle2 = angle == 3 && face == 2;
        boolean angle3 = angle == 2 && face == 4;
        boolean bl = angle4 = angle == 1 && face == 3;
        return angle1 || angle2 || angle3 || angle4;
    }

    public void func_176204_a(World world, BlockPos pos, IBlockState state, Block block) {
        super.func_176204_a(world, pos, state, block);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityShelf) {
            TileEntityShelf shelf = (TileEntityShelf)tile;
            BlockPos upperBlockPos = new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p());
            Block testBlock = world.func_180495_p(upperBlockPos).func_177230_c();
            if (shelf != null) {
                boolean isBlock = !testBlock.isAir((IBlockAccess)world, upperBlockPos);
                shelf.setTop(isBlock);
            }
        }
    }

    @Override
    public TRSRTransformation getAdditionalTransforms(TRSRTransformation transform, BiblioTileEntity tile) {
        return transform;
    }
}

