/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.containers;

import jds.bibliocraft.items.ItemSlottedBook;
import jds.bibliocraft.slots.SlotLocked;
import jds.bibliocraft.slots.SlotSlottedBook;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ContainerSlottedBook
extends Container {
    private InventoryBasic inventory = new InventoryBasic("BookInventory", false, 1);
    public ItemStack bookStack;
    private SlotSlottedBook bookslot;

    public ContainerSlottedBook(InventoryPlayer inventoryPlayer) {
        NBTTagCompound tags;
        this.bookStack = inventoryPlayer.func_70448_g();
        if (this.bookStack != null && this.bookStack.func_77973_b() instanceof ItemSlottedBook && (tags = this.bookStack.func_77978_p()) != null) {
            NBTTagList tagList = tags.func_150295_c("Inventory", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tag = tagList.func_150305_b(i);
                byte slot = tag.func_74771_c("Slot");
                if (slot < 0 || slot >= this.inventory.func_70302_i_()) continue;
                ItemStack invStack = ItemStack.func_77949_a((NBTTagCompound)tag);
                this.inventory.func_70299_a((int)slot, invStack);
            }
        }
        this.bookslot = new SlotSlottedBook(this, (IInventory)this.inventory, 0, 80, -3);
        this.func_75146_a(this.bookslot);
        this.bindPlayerInventory(inventoryPlayer);
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        return true;
    }

    public void func_75134_a(EntityPlayer player) {
        this.updateNBT(player);
    }

    private void updateNBT(EntityPlayer player) {
        ItemStack newStack = player.func_70694_bm();
        if (newStack != null && newStack.func_77973_b() instanceof ItemSlottedBook) {
            NBTTagCompound tags = newStack.func_77978_p();
            if (tags == null) {
                tags = new NBTTagCompound();
            }
            NBTTagList itemList = new NBTTagList();
            for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                ItemStack stack = this.inventory.func_70301_a(i);
                if (stack == null) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74774_a("Slot", (byte)i);
                stack.func_77955_b(tag);
                itemList.func_74742_a((NBTBase)tag);
            }
            tags.func_74782_a("Inventory", (NBTBase)itemList);
            newStack.func_77982_d(tags);
        }
        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, newStack);
    }

    public ItemStack func_75144_a(int slot, int mouse, int modifier, EntityPlayer player) {
        if (slot == -999) {
            return null;
        }
        return super.func_75144_a(slot, mouse, modifier, player);
    }

    protected void bindPlayerInventory(InventoryPlayer inventoryPlayer) {
        int i;
        int heldSlot = inventoryPlayer.field_70461_c;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 96 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            if (i == heldSlot) {
                this.func_75146_a(new SlotLocked((IInventory)inventoryPlayer, i, 8 + i * 18, 154));
                continue;
            }
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, i, 8 + i * 18, 154));
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int slot) {
        ItemStack stack = null;
        Slot slotObject = (Slot)this.field_75151_b.get(slot);
        if (slotObject != null && slotObject.func_75216_d()) {
            ItemStack stackInSlot = slotObject.func_75211_c();
            stack = stackInSlot.func_77946_l();
            Item toolTest = stack.func_77973_b();
            if (slot < 1) {
                if (!this.func_75135_a(stackInSlot, 1, 37, true)) {
                    return null;
                }
            } else if (SlotSlottedBook.slottedBookCheck(stackInSlot) && !this.func_75135_a(stackInSlot, 0, 1, false)) {
                return null;
            }
            if (stackInSlot.field_77994_a == 0) {
                slotObject.func_75215_d(null);
            } else {
                slotObject.func_75218_e();
            }
            if (stackInSlot.field_77994_a == stack.field_77994_a) {
                return null;
            }
            slotObject.func_82870_a(player, stackInSlot);
        }
        return stack;
    }
}

