/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.models;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import jds.bibliocraft.helpers.BiblioEnums;
import jds.bibliocraft.helpers.PaintingUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelCustomData;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ISmartItemModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.TRSRTransformation;
import net.minecraftforge.client.model.obj.OBJModel;
import org.apache.commons.lang3.tuple.Pair;

public class ModelCanvas
implements ISmartItemModel,
IPerspectiveAwareModel {
    public static final ModelResourceLocation modelResourceLocation = new ModelResourceLocation("bibliocraft:PaintingCanvas");
    private IBakedModel baseModel;
    List<String> modelParts;
    IModel model = null;
    private String paintingTitle = "blank";
    private int paintingType = 0;
    private BiblioEnums.EnumBiblioPaintings[] biblioArtList = BiblioEnums.EnumBiblioPaintings.values();
    private EntityPainting.EnumArt[] vanillaArtList = EntityPainting.EnumArt.values();
    private WorldRenderer worldRenderer;
    public Tessellator tessellator;
    protected Function<ResourceLocation, TextureAtlasSprite> textureGetter = new Function<ResourceLocation, TextureAtlasSprite>(){

        public TextureAtlasSprite apply(ResourceLocation location) {
            String output = location.toString();
            if (!ModelCanvas.this.paintingTitle.contains("blank") && output.contains("bibliocraft:paintings/canvas")) {
                switch (ModelCanvas.this.paintingType) {
                    case 0: {
                        for (int i = 0; i < ModelCanvas.this.biblioArtList.length; ++i) {
                            if (!ModelCanvas.this.paintingTitle.contentEquals(((ModelCanvas)ModelCanvas.this).biblioArtList[i].title)) continue;
                            output = ((ModelCanvas)ModelCanvas.this).biblioArtList[i].paintingTexturesStrings[0][0];
                        }
                        break;
                    }
                    case 1: {
                        output = "bibliocraft:paintings/vanilla";
                        break;
                    }
                    case 2: {
                        if (PaintingUtil.customArtNames == null || PaintingUtil.customArtNames.length <= 0 || PaintingUtil.customArtResources == null) break;
                        for (int i = 0; i < PaintingUtil.customArtNames.length; ++i) {
                            if (!ModelCanvas.this.paintingTitle.contentEquals(PaintingUtil.customArtNames[i])) continue;
                            output = PaintingUtil.customArtHeights[i] == PaintingUtil.customArtWidths[i] ? PaintingUtil.customArtResourceStrings[i] : "bibliocraft:paintings/custom";
                        }
                        break;
                    }
                }
            }
            return Minecraft.func_71410_x().func_147117_R().func_110572_b(output);
        }
    };

    public ModelCanvas(IBakedModel model) {
        this.baseModel = model;
        this.modelParts = new ArrayList<String>();
        this.modelParts.add("canvas");
        this.modelParts.add("painting");
    }

    public IBakedModel handleItemState(ItemStack stack) {
        NBTTagCompound tags;
        if (this.tessellator == null || this.worldRenderer == null) {
            this.tessellator = Tessellator.func_178181_a();
            this.worldRenderer = this.tessellator.func_178180_c();
        }
        if ((tags = stack.func_77978_p()) != null && tags.func_74764_b("paintingTitle") && tags.func_74764_b("paintingType")) {
            this.paintingTitle = tags.func_74779_i("paintingTitle");
            this.paintingType = tags.func_74762_e("paintingType");
        } else {
            this.paintingTitle = "blank";
        }
        try {
            this.model = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("bibliocraft:item/canvas.obj"));
        }
        catch (IOException e) {
            this.model = ModelLoaderRegistry.getMissingModel();
        }
        this.model = ((IModelCustomData)this.model).process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
        TRSRTransformation transform = new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
        OBJModel.OBJState partList = new OBJModel.OBJState(this.modelParts, true, (IModelState)transform);
        this.baseModel = this.model.bake((IModelState)partList, DefaultVertexFormats.field_176599_b, this.textureGetter);
        return this;
    }

    private void renderVanillaPainting(float i, float j, float k) {
        for (int x = 0; x < this.vanillaArtList.length; ++x) {
            if (!this.paintingTitle.contentEquals(this.vanillaArtList[x].field_75702_A)) continue;
            float x1 = (float)this.vanillaArtList[x].field_75699_D / 256.0f;
            float x2 = (float)(this.vanillaArtList[x].field_75699_D + this.vanillaArtList[x].field_75703_B) / 256.0f;
            float y1 = (float)this.vanillaArtList[x].field_75700_E / 256.0f;
            float y2 = (float)(this.vanillaArtList[x].field_75700_E + this.vanillaArtList[x].field_75704_C) / 256.0f;
            this.worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            this.worldRenderer.func_181662_b(0.035, -0.4, -0.4).func_181673_a((double)x2, (double)y2);
            this.worldRenderer.func_181662_b(0.035, 0.4, -0.4).func_181673_a((double)x2, (double)y1);
            this.worldRenderer.func_181662_b(0.035, 0.4, 0.4).func_181673_a((double)x1, (double)y1);
            this.worldRenderer.func_181662_b(0.035, -0.4, 0.4).func_181673_a((double)x1, (double)y2);
            this.tessellator.func_78381_a();
        }
    }

    public Pair<? extends IFlexibleBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        TRSRTransformation transform = new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
        switch (cameraTransformType) {
            case FIRST_PERSON: {
                transform = new TRSRTransformation(new Vector3f(0.0f, 0.0f, -0.1f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f));
                break;
            }
            case THIRD_PERSON: {
                transform = new TRSRTransformation(new Vector3f(0.1f, 0.1f, -0.1f), new Quat4f(1.0f, -0.5f, 0.0f, 1.0f), new Vector3f(0.5f, 0.5f, 0.5f), new Quat4f(1.0f, 0.0f, 0.0f, 1.0f));
                break;
            }
            case GUI: {
                transform = new TRSRTransformation(new Vector3f(-0.3f, -0.18f, 0.0f), new Quat4f(0.0f, 0.9f, 0.2f, 1.0f), new Vector3f(1.4f, 1.4f, 1.4f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                break;
            }
            case GROUND: {
                transform = new TRSRTransformation(new Vector3f(0.15f, 0.0f, 0.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                break;
            }
            case FIXED: {
                transform = new TRSRTransformation(new Vector3f(0.0f, -0.05f, -0.24f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                break;
            }
            case NONE: {
                transform = new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
            }
        }
        return Pair.of((Object)this, (Object)transform.getMatrix());
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_177553_d() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.baseModel.func_177554_e();
    }

    public List<BakedQuad> func_177551_a(EnumFacing facing) {
        return this.baseModel.func_177551_a(facing);
    }

    public List<BakedQuad> func_177550_a() {
        return this.baseModel.func_177550_a();
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public boolean func_177555_b() {
        return false;
    }

    public VertexFormat getFormat() {
        return Attributes.DEFAULT_BAKED_FORMAT;
    }
}

