/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.models;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import jds.bibliocraft.models.BiblioModelWood;
import jds.bibliocraft.states.TextureState;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraftforge.client.model.TRSRTransformation;

public class ModelTable
extends BiblioModelWood {
    public static final ModelResourceLocation modelResourceLocation = new ModelResourceLocation("bibliocraft:Table");
    private String clothTexture = "minecraft:blocks/wool_colored_white";
    private String carpetTexture = "minecraft:blocks/wool_colored_white";

    public ModelTable() {
        super("bibliocraft:block/table.obj");
    }

    @Override
    public String getTextureLocation(String resourceLocation, String textureLocation) {
        String returnValue = resourceLocation;
        if (resourceLocation.contentEquals("minecraft:blocks/planks_oak")) {
            returnValue = textureLocation;
        } else if (resourceLocation.contentEquals("minecraft:blocks/wool_colored_red")) {
            returnValue = this.clothTexture;
        } else if (resourceLocation.contentEquals("minecraft:blocks/wool_colored_white")) {
            returnValue = this.carpetTexture;
        }
        return returnValue;
    }

    @Override
    public void loadAdditionalTextureStateStuff(TextureState state) {
        if (state != null) {
            this.clothTexture = state.getColorOne().getWoolTextureString();
            this.carpetTexture = state.getColorTwo().getWoolTextureString();
        }
    }

    @Override
    public TRSRTransformation getTweakedMasterTransfer(TRSRTransformation transform) {
        transform = transform.compose(new TRSRTransformation(new Vector3f(-0.66f, 0.0f, -0.5f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f)));
        return transform;
    }

    @Override
    public List<String> getDefaultVisiableModelParts() {
        ArrayList<String> modelParts = new ArrayList<String>();
        modelParts.add("monoleg");
        modelParts.add("tableBevel01");
        modelParts.add("tableBevel02");
        modelParts.add("tableBevel03");
        modelParts.add("tableBevel04");
        return modelParts;
    }

    @Override
    public TRSRTransformation getTweakedGUITransform(TRSRTransformation transform) {
        transform = transform.compose(new TRSRTransformation(new Vector3f(0.0f, -0.05f, 0.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f)));
        return transform;
    }
}

