/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.tileentities;

import java.util.Random;
import jds.bibliocraft.Config;
import jds.bibliocraft.blocks.BlockBookcase;
import jds.bibliocraft.items.ItemRedstoneBook;
import jds.bibliocraft.storygen.BookGenUtil;
import jds.bibliocraft.storygen.BookGenWordLists;
import jds.bibliocraft.tileentities.BiblioTileEntity;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class TileEntityBookcase
extends BiblioTileEntity {
    private int slotsFilled;
    private boolean hasredstonebook;
    private int redstonebookslot;
    private int[] bookCheck = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public TileEntityBookcase() {
        super(16, true);
    }

    @Override
    public void setInventorySlotContentsAdditionalCommands(int slot, ItemStack stack) {
        boolean redtest = this.hasredstonebook;
        this.hasredstonebook = this.hasredstone();
        if (redtest != this.hasredstonebook) {
            this.field_145850_b.func_175685_c(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()), (Block)BlockBookcase.instance);
            this.field_145850_b.func_175685_c(new BlockPos(this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()), (Block)BlockBookcase.instance);
            this.field_145850_b.func_175685_c(new BlockPos(this.field_174879_c.func_177958_n() - 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()), (Block)BlockBookcase.instance);
            this.field_145850_b.func_175685_c(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 1), (Block)BlockBookcase.instance);
            this.field_145850_b.func_175685_c(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 1), (Block)BlockBookcase.instance);
            this.field_145850_b.func_175685_c(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p()), (Block)BlockBookcase.instance);
            this.field_145850_b.func_175685_c(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p()), (Block)BlockBookcase.instance);
        }
        this.checkFilledSlots();
        this.checkBooks();
    }

    @Override
    public void loadCustomNBTData(NBTTagCompound nbt) {
        this.slotsFilled = nbt.func_74762_e("filledSlots");
        this.hasredstonebook = nbt.func_74767_n("hasredstonebook");
        this.redstonebookslot = nbt.func_74762_e("redstonebookslot");
        this.bookCheck = nbt.func_74759_k("bookCheck");
    }

    @Override
    public NBTTagCompound writeCustomNBTData(NBTTagCompound nbt) {
        nbt.func_74768_a("filledSlots", this.slotsFilled);
        nbt.func_74757_a("hasredstonebook", this.hasredstonebook);
        nbt.func_74768_a("redstonebookslot", this.redstonebookslot);
        nbt.func_74783_a("bookCheck", this.bookCheck);
        return nbt;
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    public boolean hasredstone() {
        for (int x = 0; x < 16; ++x) {
            Item item;
            ItemStack stack = this.inventory[x];
            if (stack == null || !((item = stack.func_77973_b()) instanceof ItemRedstoneBook)) continue;
            this.redstonebookslot = x;
            return true;
        }
        return false;
    }

    public void checkBooks() {
        if (this.bookCheck.length == 0) {
            this.bookCheck = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        }
        for (int x = 0; x < this.bookCheck.length; ++x) {
            ItemStack stack = this.inventory[x];
            this.bookCheck[x] = stack != null ? 1 : 0;
        }
    }

    public int[] getCheckedBooks() {
        return this.bookCheck;
    }

    public boolean getredstone() {
        return this.hasredstonebook;
    }

    public int getRedstoneBookSlot() {
        return this.redstonebookslot;
    }

    public boolean setBook(int bookNumber, ItemStack bookStack) {
        if (bookStack != null && this.func_70301_a(bookNumber) == null) {
            this.func_70299_a(bookNumber, bookStack);
            return true;
        }
        if (bookStack == null && this.func_70301_a(bookNumber) != null) {
            this.func_70299_a(bookNumber, null);
        }
        return false;
    }

    public void checkFilledSlots() {
        this.slotsFilled = 0;
        for (int s = 0; s < 16; ++s) {
            ItemStack stackTest = this.func_70301_a(s);
            if (stackTest == null) continue;
            ++this.slotsFilled;
        }
    }

    public boolean checkSlot(int slot) {
        return this.func_70301_a(slot) != null;
    }

    public void addRandomBooksToShelf() {
        Random rando = new Random();
        for (int n = 0; n < 16; ++n) {
            if (rando.nextInt(10) >= 8) continue;
            this.func_70299_a(n, this.writeCustomBook());
        }
    }

    public ItemStack writeCustomBook() {
        BookGenWordLists bookgenwordlist = new BookGenWordLists();
        String authorName = bookgenwordlist.getRandomName();
        BookGenUtil bookgen = new BookGenUtil(1, authorName);
        ItemStack newBook = new ItemStack(Items.field_151164_bB, 1, 0);
        NBTTagCompound bookTag = new NBTTagCompound();
        NBTTagList bookTagList = new NBTTagList();
        NBTTagString nbtPage = new NBTTagString(bookgen.getStasis(1, authorName));
        bookTagList.func_74742_a((NBTBase)nbtPage);
        nbtPage = new NBTTagString(bookgen.getTrigger(1, authorName));
        bookTagList.func_74742_a((NBTBase)nbtPage);
        nbtPage = new NBTTagString(bookgen.getQuest(1, authorName));
        bookTagList.func_74742_a((NBTBase)nbtPage);
        nbtPage = new NBTTagString(bookgen.getSurprise(1, authorName));
        bookTagList.func_74742_a((NBTBase)nbtPage);
        nbtPage = new NBTTagString(bookgen.getChoice(1, authorName));
        bookTagList.func_74742_a((NBTBase)nbtPage);
        nbtPage = new NBTTagString(bookgen.getClimax(1, authorName));
        bookTagList.func_74742_a((NBTBase)nbtPage);
        nbtPage = new NBTTagString(bookgen.getReversal(1, authorName));
        bookTagList.func_74742_a((NBTBase)nbtPage);
        nbtPage = new NBTTagString(bookgen.getResolution(1, authorName));
        bookTagList.func_74742_a((NBTBase)nbtPage);
        bookTag.func_74782_a("title", (NBTBase)new NBTTagString(bookgen.getBookTitle()));
        bookTag.func_74782_a("author", (NBTBase)new NBTTagString(authorName));
        bookTag.func_74782_a("pages", (NBTBase)bookTagList);
        newBook.func_77982_d(bookTag);
        return newBook;
    }

    public int getFilledSlots() {
        return this.slotsFilled;
    }

    public int getTopEmptySlot() {
        for (int x = 0; x < 8; ++x) {
            if (this.inventory[x] != null) continue;
            return x;
        }
        return -1;
    }

    public int getBottomEmptySlot() {
        for (int x = 8; x < 16; ++x) {
            if (this.inventory[x] != null) continue;
            return x;
        }
        return -1;
    }

    public int getTopFullSlot() {
        for (int x = 7; x >= 0; --x) {
            if (this.inventory[x] == null) continue;
            return x;
        }
        return -1;
    }

    public int getBottomFullSlot() {
        for (int x = 15; x >= 8; --x) {
            if (this.inventory[x] == null) continue;
            return x;
        }
        return -1;
    }

    public ItemStack getTopBook() {
        int slot = this.getTopFullSlot();
        if (slot != -1) {
            ItemStack topBook = this.inventory[slot];
            return topBook;
        }
        return null;
    }

    public ItemStack getBottomBook() {
        int slot = this.getBottomFullSlot();
        if (slot != -1) {
            ItemStack bottomBook = this.inventory[slot];
            return bottomBook;
        }
        return null;
    }

    public boolean removeTopBook() {
        int slot = this.getTopFullSlot();
        if (slot != -1) {
            this.func_70299_a(slot, null);
            return true;
        }
        return false;
    }

    public boolean removeBottomBook() {
        int slot = this.getBottomFullSlot();
        if (slot != -1) {
            this.func_70299_a(slot, null);
            return true;
        }
        return false;
    }

    public boolean addTopBook(ItemStack stack) {
        if (this.getTopEmptySlot() != -1) {
            this.func_70299_a(this.getTopEmptySlot(), stack);
            return true;
        }
        return false;
    }

    public boolean addBottomBook(ItemStack stack) {
        if (this.getBottomEmptySlot() != -1) {
            this.func_70299_a(this.getBottomEmptySlot(), stack);
            return true;
        }
        return false;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack itemstack) {
        Item stackitem = itemstack.func_77973_b();
        return stackitem != null && !Config.isBlock(itemstack) && Config.testBookValidity(itemstack);
    }

    public String func_70005_c_() {
        return "Bookcase";
    }

    public IChatComponent func_145748_c_() {
        ChatComponentText chat = new ChatComponentText(this.func_70005_c_());
        return chat;
    }
}

