/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.blocks;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import jds.bibliocraft.blocks.BiblioColorBlock;
import jds.bibliocraft.tileentities.BiblioTileEntity;
import jds.bibliocraft.tileentities.TileEntityTypewriter;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.model.TRSRTransformation;

public class BlockTypeWriter
extends BiblioColorBlock {
    public static final String name = "Typewriter";
    public static final BlockTypeWriter instance = new BlockTypeWriter();

    public BlockTypeWriter() {
        super(Material.field_151573_f, SoundType.field_185852_e, name);
    }

    @Override
    public boolean onBlockActivatedCustomCommands(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        if (!world.field_72995_K && tile != null && tile instanceof TileEntityTypewriter) {
            TileEntityTypewriter typewriter = (TileEntityTypewriter)tile;
            ItemStack playerhand = player.func_184586_b(EnumHand.MAIN_HAND);
            EnumFacing typeAngle = typewriter.getAngle();
            if (player.func_70093_af()) {
                if (typewriter.func_70301_a(0) != ItemStack.field_190927_a) {
                    typewriter.removeStackFromInventoryFromWorld(0, player, this);
                }
            } else {
                if (playerhand != ItemStack.field_190927_a) {
                    if (playerhand.func_77973_b() == Items.field_151121_aF) {
                        int returnsize = typewriter.addPaper(playerhand);
                        if (returnsize > 0) {
                            playerhand.func_190920_e(returnsize);
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, playerhand);
                        } else if (returnsize == 0) {
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                        }
                    }
                    return true;
                }
                if (this.isFrontFace(typeAngle, side) && typewriter.func_70301_a(1) == ItemStack.field_190927_a) {
                    if (typewriter.getHasEnoughPaper()) {
                        if (typewriter.getBookWriteCount() < 15) {
                            typewriter.entityName = player.func_70005_c_();
                            typewriter.entityType = 0;
                            typewriter.setBookWriteCount(typewriter.getBookWriteCount() + 1, true);
                        } else if (typewriter.removePaperForBook()) {
                            typewriter.foundValidEntity = true;
                            typewriter.entityName = player.func_70005_c_();
                            typewriter.entityType = 0;
                            typewriter.writeCustomBook();
                        }
                    }
                    return true;
                }
                if (typewriter.func_70301_a(1) != ItemStack.field_190927_a) {
                    typewriter.foundValidEntity = false;
                    typewriter.entityName = "";
                    typewriter.entityType = 0;
                    typewriter.setBookWriteCount(0, true);
                    typewriter.removeStackFromInventoryFromWorld(1, player, this);
                }
            }
        }
        return true;
    }

    public boolean isFrontFace(EnumFacing typeAngle, EnumFacing face) {
        switch (typeAngle) {
            case SOUTH: {
                if (face != EnumFacing.WEST) break;
                return true;
            }
            case WEST: {
                if (face != EnumFacing.NORTH) break;
                return true;
            }
            case NORTH: {
                if (face != EnumFacing.EAST) break;
                return true;
            }
            case EAST: {
                if (face != EnumFacing.SOUTH) break;
                return true;
            }
        }
        return false;
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityTypewriter();
    }

    @Override
    public List<String> getModelParts(BiblioTileEntity tile) {
        ArrayList<String> modelParts = new ArrayList<String>();
        modelParts.add("base");
        return modelParts;
    }

    @Override
    public TRSRTransformation getAdditionalTransforms(TRSRTransformation transform, BiblioTileEntity tile) {
        transform = transform.compose(new TRSRTransformation(new Vector3f(0.09f, 0.0f, 0.0f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f)));
        return transform;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        AxisAlignedBB output = this.getBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        TileEntity tile = blockAccess.func_175625_s(pos);
        if (tile != null && tile instanceof BiblioTileEntity) {
            BiblioTileEntity biblioTile = (BiblioTileEntity)tile;
            switch (biblioTile.getAngle()) {
                case SOUTH: {
                    output = this.getBlockBounds(0.05f, 0.0f, 0.25f, 0.55f, 0.3f, 0.75f);
                    break;
                }
                case WEST: {
                    output = this.getBlockBounds(0.25f, 0.0f, 0.05f, 0.75f, 0.3f, 0.55f);
                    break;
                }
                case NORTH: {
                    output = this.getBlockBounds(0.45f, 0.0f, 0.25f, 0.95f, 0.3f, 0.75f);
                    break;
                }
                case EAST: {
                    output = this.getBlockBounds(0.25f, 0.0f, 0.45f, 0.75f, 0.3f, 0.95f);
                    break;
                }
            }
        }
        return output;
    }
}

