/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.models;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import jds.bibliocraft.helpers.ModelCache;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import org.apache.commons.lang3.tuple.Pair;

public abstract class BiblioModelSimple
implements IBakedModel {
    private IModel model = null;
    private IBakedModel baseModel;
    private String modelLocation = " ";
    private CustomItemOverrideList overrides = new CustomItemOverrideList();
    public IBakedModel wrapper;
    private ModelCache cache;
    private boolean gotOBJ = false;
    protected Function<ResourceLocation, TextureAtlasSprite> textureGetter = new Function<ResourceLocation, TextureAtlasSprite>(){

        public TextureAtlasSprite apply(ResourceLocation location) {
            return Minecraft.func_71410_x().func_147117_R().func_110572_b(BiblioModelSimple.this.getTextureLocation(location.toString()));
        }
    };

    public BiblioModelSimple(String modelLoc) {
        this.modelLocation = modelLoc;
        this.wrapper = this;
        this.cache = new ModelCache();
    }

    private void getModel(IBlockState state, int attempt) {
        block11: {
            if (this.model == null || this.model != null && !this.model.toString().contains("obj.OBJModel")) {
                try {
                    this.model = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation(this.modelLocation));
                    this.model = this.model.process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
                    this.gotOBJ = true;
                }
                catch (Exception e) {
                    this.model = ModelLoaderRegistry.getMissingModel();
                    this.gotOBJ = false;
                    if (attempt >= 6) break block11;
                    this.getModel(state, attempt + 1);
                    return;
                }
            }
        }
        OBJModel.OBJState modelState = new OBJModel.OBJState(this.getDefaultVisiableModelParts(), true);
        if (state != null && state instanceof IExtendedBlockState) {
            IExtendedBlockState exState = (IExtendedBlockState)state;
            if (exState.getUnlistedNames().contains(OBJModel.OBJProperty.INSTANCE)) {
                modelState = (OBJModel.OBJState)exState.getValue((IUnlistedProperty)OBJModel.OBJProperty.INSTANCE);
            }
            if (modelState == null) {
                return;
            }
            this.getAdditionalModelStateStuff(exState);
        }
        Function<ResourceLocation, TextureAtlasSprite> texture = this.textureGetter;
        if (state != null && state instanceof IExtendedBlockState) {
            IBakedModel bakedModel;
            this.baseModel = bakedModel = this.model.bake((IModelState)modelState, DefaultVertexFormats.field_176599_b, texture);
        } else if (this.cache.hasModel(texture.toString())) {
            this.baseModel = this.cache.getCurrentMatch();
        } else {
            IBakedModel bakedModel = this.model.bake((IModelState)modelState, DefaultVertexFormats.field_176599_b, texture);
            if (this.gotOBJ) {
                this.cache.addToCache(bakedModel, texture.toString());
            }
            this.baseModel = bakedModel;
        }
    }

    public void getAdditionalModelStateStuff(IExtendedBlockState state) {
    }

    public List<String> getDefaultVisiableModelParts() {
        ArrayList modelParts = Lists.newArrayList((Object[])new String[]{"OBJModel.Group.All.Key"});
        return modelParts;
    }

    public String getTextureLocation(String resourceLocation) {
        return resourceLocation;
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        if (this.baseModel.func_177554_e() == null) {
            return Minecraft.func_71410_x().func_147117_R().func_110572_b("minecraft:blocks/planks_oak");
        }
        return this.baseModel.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        TRSRTransformation transform = new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
        switch (cameraTransformType) {
            case FIRST_PERSON_RIGHT_HAND: {
                transform = new TRSRTransformation(new Vector3f(1.4f, 0.2f, -1.5f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                transform = this.getTweakedRIGHTHANDTransform(transform);
                break;
            }
            case FIRST_PERSON_LEFT_HAND: {
                transform = new TRSRTransformation(new Vector3f(1.4f, 0.2f, 0.5f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                transform = this.getTweakedLEFTHANDTransform(transform);
                break;
            }
            case THIRD_PERSON_RIGHT_HAND: {
                transform = new TRSRTransformation(new Vector3f(0.6f, 0.8f, 0.25f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(0.65f, 0.65f, 0.65f), new Quat4f(1.0f, 0.0f, 0.0f, 1.0f));
                transform = transform.compose(new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f)));
                transform = this.getTweakedRIGHTHANDTransform(transform);
                break;
            }
            case THIRD_PERSON_LEFT_HAND: {
                transform = new TRSRTransformation(new Vector3f(0.65f, -0.5f, 0.25f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(0.65f, 0.65f, 0.65f), new Quat4f(1.0f, 0.0f, 0.0f, 1.0f));
                transform = transform.compose(new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f)));
                transform = this.getTweakedLEFTHANDTransform(transform);
                break;
            }
            case GUI: {
                transform = new TRSRTransformation(new Vector3f(0.0f, 0.26f, 0.0f), new Quat4f(0.25f, 1.0f, 0.25f, 1.0f), new Vector3f(0.75f, 0.75f, 0.75f), new Quat4f(0.0f, 0.4f, 0.0f, 1.0f));
                transform = this.getTweakedGUITransform(transform);
                break;
            }
            case GROUND: {
                transform = new TRSRTransformation(new Vector3f(0.5f, 0.05f, 0.5f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(0.5f, 0.5f, 0.5f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                break;
            }
            case FIXED: {
                transform = new TRSRTransformation(new Vector3f(-0.75f, 0.12f, 0.75f), new Quat4f(0.0f, -1.0f, 0.0f, 1.0f), new Vector3f(0.75f, 0.75f, 0.75f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                break;
            }
            case NONE: {
                transform = new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
            }
        }
        transform = this.getTweakedMasterTransfer(transform);
        return Pair.of((Object)this, (Object)transform.getMatrix());
    }

    public TRSRTransformation getTweakedMasterTransfer(TRSRTransformation transform) {
        return transform;
    }

    public TRSRTransformation getTweakedGUITransform(TRSRTransformation transform) {
        return transform;
    }

    public TRSRTransformation getTweakedLEFTHANDTransform(TRSRTransformation transform) {
        return transform;
    }

    public TRSRTransformation getTweakedRIGHTHANDTransform(TRSRTransformation transform) {
        return transform;
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        this.getModel(state, 0);
        try {
            List q = this.baseModel.func_188616_a(state, side, rand);
            return q;
        }
        catch (NullPointerException e) {
            return new ArrayList<BakedQuad>();
        }
    }

    public ItemOverrideList func_188617_f() {
        return this.overrides;
    }

    private class CustomItemOverrideList
    extends ItemOverrideList {
        private CustomItemOverrideList() {
            super((List)ImmutableList.of());
        }

        @Nonnull
        public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, ItemStack stack, @Nonnull World world, @Nonnull EntityLivingBase entity) {
            BiblioModelSimple.this.getModel(null, 0);
            return BiblioModelSimple.this.wrapper;
        }
    }
}

