/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.client;

import java.util.Set;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import thetadev.constructionwand.basics.WandUtil;
import thetadev.constructionwand.client.ClientEvents;
import thetadev.constructionwand.items.wand.ItemWand;
import thetadev.constructionwand.wand.WandJob;

public class RenderBlockPreview {
    public WandJob wandJob;
    public Set<BlockPos> undoBlocks;

    @SubscribeEvent
    public void renderBlockHighlight(DrawBlockHighlightEvent event) {
        if (event.getTarget().func_216346_c() != RayTraceResult.Type.BLOCK) {
            return;
        }
        BlockRayTraceResult rtr = (BlockRayTraceResult)event.getTarget();
        Entity entity = event.getInfo().func_216773_g();
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        Set<BlockPos> blocks = null;
        float colorR = 0.0f;
        float colorG = 0.0f;
        float colorB = 0.0f;
        ItemStack wand = WandUtil.holdingWand(player);
        if (wand == null) {
            return;
        }
        if (!player.func_70093_af() || !ClientEvents.isOptKeyDown()) {
            if (this.wandJob == null || !RenderBlockPreview.compareRTR(this.wandJob.rayTraceResult, rtr) || !this.wandJob.wand.equals(wand)) {
                this.wandJob = ItemWand.getWandJob(player, player.func_130014_f_(), rtr, wand);
            }
            blocks = this.wandJob.getBlockPositions();
        } else {
            blocks = this.undoBlocks;
            colorG = 1.0f;
        }
        if (blocks == null || blocks.isEmpty()) {
            return;
        }
        for (BlockPos block : blocks) {
            double partialTicks = event.getPartialTicks();
            double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * partialTicks;
            double d1 = player.field_70137_T + (double)player.func_70047_e() + (player.field_70163_u - player.field_70137_T) * partialTicks;
            double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * partialTicks;
            AxisAlignedBB aabb = new AxisAlignedBB(block).func_72317_d(-d0, -d1, -d2);
            RenderBlockPreview.drawBoundingBox(aabb, colorR, colorG, colorB, 0.4f);
        }
        event.setCanceled(true);
    }

    private static boolean compareRTR(BlockRayTraceResult rtr1, BlockRayTraceResult rtr2) {
        return rtr1.func_216350_a().equals((Object)rtr2.func_216350_a()) && rtr1.func_216354_b().equals((Object)rtr2.func_216354_b());
    }

    private static void drawBoundingBox(AxisAlignedBB box, float red, float green, float blue, float alpha) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72334_f).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72339_c).func_181666_a(red, green, blue, alpha).func_181675_d();
        tessellator.func_78381_a();
    }
}

