/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.client;

import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import thetadev.constructionwand.ConstructionWand;
import thetadev.constructionwand.basics.option.IOption;
import thetadev.constructionwand.basics.option.WandOptions;
import thetadev.constructionwand.network.PacketWandOption;

public class ScreenWand
extends Screen {
    private final ItemStack wand;
    private final WandOptions wandOptions;
    private final HashMap<IOption<?>, Button> optionButtons;
    private static final int BUTTON_WIDTH = 160;
    private static final int BUTTON_HEIGHT = 20;
    private static final int SPACING_WIDTH = 50;
    private static final int SPACING_HEIGHT = 30;
    private static final int N_COLS = 2;
    private static final int N_ROWS = 3;
    private static final int FIELD_WIDTH = 370;
    private static final int FIELD_HEIGHT = 120;

    public ScreenWand(ItemStack wand) {
        super((ITextComponent)new StringTextComponent("ScreenWand"));
        this.wand = wand;
        this.wandOptions = new WandOptions(wand);
        this.optionButtons = new HashMap();
    }

    public void init(Minecraft minecraft, int width, int height) {
        super.init(minecraft, width, height);
        this.optionButtons.clear();
        this.createButton(0, 0, this.wandOptions.cores);
        this.createButton(0, 1, this.wandOptions.lock);
        this.createButton(0, 2, this.wandOptions.direction);
        this.createButton(1, 0, this.wandOptions.replace);
        this.createButton(1, 1, this.wandOptions.match);
        this.createButton(1, 2, this.wandOptions.random);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.drawCenteredString(this.font, this.wand.func_200301_q().func_150254_d(), this.width / 2, this.height / 2 - 60 - 30, 0xFFFFFF);
        this.optionButtons.forEach((opt, but) -> this.drawTooltip(mouseX, mouseY, (IOption<?>)opt, (Button)but));
    }

    public boolean charTyped(char character, int code) {
        if (character == 'e') {
            this.onClose();
        }
        return super.charTyped(character, code);
    }

    private void createButton(int cx, int cy, IOption<?> option) {
        Button button = new Button(this.getX(cx), this.getY(cy), 160, 20, this.getButtonLabel(option).func_150254_d(), bt -> this.clickButton(bt, option));
        button.active = option.isEnabled();
        this.addButton((Widget)button);
        this.optionButtons.put(option, button);
    }

    private void clickButton(Button button, IOption<?> option) {
        option.next();
        ConstructionWand.instance.HANDLER.sendToServer((Object)new PacketWandOption(option, false));
        button.setMessage(this.getButtonLabel(option).func_150254_d());
    }

    private void drawTooltip(int mouseX, int mouseY, IOption<?> option, Button button) {
        if (button.isHovered()) {
            this.renderTooltip(new TranslationTextComponent(option.getDescTranslation(), new Object[0]).func_150254_d(), mouseX, mouseY);
        }
    }

    private int getX(int n) {
        return this.width / 2 - 185 + n * 210;
    }

    private int getY(int n) {
        return this.height / 2 - 60 + n * 50;
    }

    private ITextComponent getButtonLabel(IOption<?> option) {
        return new TranslationTextComponent(option.getKeyTranslation(), new Object[0]).func_150257_a((ITextComponent)new TranslationTextComponent(option.getValueTranslation(), new Object[0]));
    }
}

