/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.wand.supplier;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import thetadev.constructionwand.ConstructionWand;
import thetadev.constructionwand.api.IWandSupplier;
import thetadev.constructionwand.basics.ReplacementRegistry;
import thetadev.constructionwand.basics.WandUtil;
import thetadev.constructionwand.basics.option.WandOptions;
import thetadev.constructionwand.basics.pool.IPool;
import thetadev.constructionwand.basics.pool.OrderedPool;
import thetadev.constructionwand.containers.ContainerManager;
import thetadev.constructionwand.wand.undo.PlaceSnapshot;

public class SupplierInventory
implements IWandSupplier {
    protected final PlayerEntity player;
    protected final WandOptions options;
    protected HashMap<BlockItem, Integer> itemCounts;
    protected IPool<BlockItem> itemPool;

    public SupplierInventory(PlayerEntity player, WandOptions options) {
        this.player = player;
        this.options = options;
    }

    @Override
    public void getSupply(@Nullable BlockItem target) {
        this.itemCounts = new LinkedHashMap<BlockItem, Integer>();
        ItemStack offhandStack = this.player.func_184586_b(Hand.OFF_HAND);
        this.itemPool = new OrderedPool<BlockItem>();
        if (!offhandStack.func_190926_b() && offhandStack.func_77973_b() instanceof BlockItem) {
            this.addBlockItem((BlockItem)offhandStack.func_77973_b());
        } else {
            this.addBlockItem(target);
            if (this.options.match.get() != WandOptions.MATCH.EXACT) {
                for (Item it : ReplacementRegistry.getMatchingSet((Item)target)) {
                    if (!(it instanceof BlockItem)) continue;
                    this.addBlockItem((BlockItem)it);
                }
            }
        }
    }

    protected void addBlockItem(BlockItem item) {
        int count = WandUtil.countItem(this.player, (Item)item);
        if (count > 0) {
            this.itemCounts.put(item, count);
            this.itemPool.add(item);
        }
    }

    @Override
    @Nullable
    public PlaceSnapshot getPlaceSnapshot(World world, BlockPos pos, BlockRayTraceResult rayTraceResult, @Nullable BlockState supportingBlock) {
        PlaceSnapshot placeSnapshot;
        BlockItem item;
        int count;
        if (!WandUtil.isPositionPlaceable(world, this.player, pos, this.options.replace.get())) {
            return null;
        }
        this.itemPool.reset();
        do {
            if ((item = this.itemPool.draw()) != null) continue;
            return null;
        } while ((count = this.itemCounts.get(item).intValue()) == 0 || (placeSnapshot = PlaceSnapshot.get(world, this.player, rayTraceResult, pos, item, supportingBlock, this.options)) == null);
        int ncount = count - 1;
        this.itemCounts.put(item, ncount);
        if (ncount == 0) {
            this.itemPool.remove(item);
        }
        return placeSnapshot;
    }

    @Override
    public int takeItemStack(ItemStack stack) {
        int count = stack.func_190916_E();
        Item item = stack.func_77973_b();
        if (this.player.field_71071_by == null || this.player.field_71071_by.field_70462_a == null) {
            return count;
        }
        if (this.player.func_184812_l_()) {
            return 0;
        }
        List<ItemStack> hotbar = WandUtil.getHotbarWithOffhand(this.player);
        List<ItemStack> mainInv = WandUtil.getMainInv(this.player);
        count = this.takeItemsInvList(count, item, mainInv, false);
        count = this.takeItemsInvList(count, item, mainInv, true);
        count = this.takeItemsInvList(count, item, hotbar, true);
        count = this.takeItemsInvList(count, item, hotbar, false);
        return count;
    }

    private int takeItemsInvList(int count, Item item, List<ItemStack> inv, boolean container) {
        ContainerManager containerManager = ConstructionWand.instance.containerManager;
        for (ItemStack stack : inv) {
            if (count == 0) break;
            if (container) {
                count = containerManager.useItems(this.player, new ItemStack((IItemProvider)item), stack, count);
            }
            if (container || !WandUtil.stackEquals(stack, item)) continue;
            int toTake = Math.min(count, stack.func_190916_E());
            stack.func_190918_g(toTake);
            count -= toTake;
            this.player.field_71071_by.func_70296_d();
        }
        return count;
    }
}

