/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.wand.undo;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import thetadev.constructionwand.basics.WandUtil;
import thetadev.constructionwand.basics.option.WandOptions;
import thetadev.constructionwand.wand.WandItemUseContext;
import thetadev.constructionwand.wand.undo.ISnapshot;

public class PlaceSnapshot
implements ISnapshot {
    private BlockState block;
    private final BlockPos pos;
    private final BlockItem item;
    private final BlockState supportingBlock;
    private final boolean targetMode;

    public PlaceSnapshot(BlockState block, BlockPos pos, BlockItem item, BlockState supportingBlock, boolean targetMode) {
        this.block = block;
        this.pos = pos;
        this.item = item;
        this.supportingBlock = supportingBlock;
        this.targetMode = targetMode;
    }

    public static PlaceSnapshot get(World world, PlayerEntity player, BlockRayTraceResult rayTraceResult, BlockPos pos, BlockItem item, @Nullable BlockState supportingBlock, @Nullable WandOptions options) {
        boolean targetMode = options != null && supportingBlock != null && options.direction.get() == WandOptions.DIRECTION.TARGET;
        BlockState blockState = PlaceSnapshot.getPlaceBlockstate(world, player, rayTraceResult, pos, item, supportingBlock, targetMode);
        if (blockState == null) {
            return null;
        }
        return new PlaceSnapshot(blockState, pos, item, supportingBlock, targetMode);
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public BlockState getBlockState() {
        return this.block;
    }

    @Override
    public ItemStack getRequiredItems() {
        return new ItemStack((IItemProvider)this.item);
    }

    @Override
    public boolean execute(World world, PlayerEntity player, BlockRayTraceResult rayTraceResult) {
        this.block = PlaceSnapshot.getPlaceBlockstate(world, player, rayTraceResult, this.pos, this.item, this.supportingBlock, this.targetMode);
        if (this.block == null) {
            return false;
        }
        return WandUtil.placeBlock(world, player, this.block, this.pos, this.item);
    }

    @Override
    public boolean canRestore(World world, PlayerEntity player) {
        return true;
    }

    @Override
    public boolean restore(World world, PlayerEntity player) {
        return WandUtil.removeBlock(world, player, this.block, this.pos);
    }

    @Override
    public void forceRestore(World world) {
        world.func_217377_a(this.pos, false);
    }

    @Nullable
    private static BlockState getPlaceBlockstate(World world, PlayerEntity player, BlockRayTraceResult rayTraceResult, BlockPos pos, BlockItem item, @Nullable BlockState supportingBlock, boolean targetMode) {
        WandItemUseContext ctx = new WandItemUseContext(world, player, rayTraceResult, pos, item);
        if (!ctx.func_196011_b()) {
            return null;
        }
        BlockState blockState = item.func_179223_d().func_196258_a((BlockItemUseContext)ctx);
        if (blockState == null) {
            return null;
        }
        if (!WandUtil.isTEAllowed(blockState)) {
            return null;
        }
        if (WandUtil.entitiesCollidingWithBlock(world, blockState, pos)) {
            return null;
        }
        if ((blockState = Block.func_199770_b((BlockState)blockState, (IWorld)world, (BlockPos)pos)).func_177230_c() == Blocks.field_150350_a || !blockState.func_196955_c((IWorldReader)world, pos)) {
            return null;
        }
        if (targetMode && supportingBlock != null) {
            SlabType slabType;
            for (Property property : new Property[]{BlockStateProperties.field_208157_J, BlockStateProperties.field_208155_H, BlockStateProperties.field_208156_I, BlockStateProperties.field_208138_am, BlockStateProperties.field_208148_A, BlockStateProperties.field_208164_Q, BlockStateProperties.field_208146_au}) {
                if (!supportingBlock.func_196959_b((IProperty)property) || !blockState.func_196959_b((IProperty)property)) continue;
                blockState = (BlockState)blockState.func_206870_a((IProperty)property, supportingBlock.func_177229_b((IProperty)property));
            }
            if (supportingBlock.func_196959_b((IProperty)BlockStateProperties.field_208145_at) && blockState.func_196959_b((IProperty)BlockStateProperties.field_208145_at) && (slabType = (SlabType)supportingBlock.func_177229_b((IProperty)BlockStateProperties.field_208145_at)) != SlabType.DOUBLE) {
                blockState = (BlockState)blockState.func_206870_a((IProperty)BlockStateProperties.field_208145_at, (Comparable)slabType);
            }
        }
        return blockState;
    }
}

