/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.basics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import thetadev.constructionwand.ConstructionWand;
import thetadev.constructionwand.basics.ConfigServer;
import thetadev.constructionwand.basics.ReplacementRegistry;
import thetadev.constructionwand.basics.option.WandOptions;
import thetadev.constructionwand.containers.ContainerManager;
import thetadev.constructionwand.items.wand.ItemWand;

public class WandUtil {
    public static boolean stackEquals(ItemStack stackA, ItemStack stackB) {
        return ItemStack.func_179545_c((ItemStack)stackA, (ItemStack)stackB) && ItemStack.func_77970_a((ItemStack)stackA, (ItemStack)stackB);
    }

    public static boolean stackEquals(ItemStack stackA, Item item) {
        ItemStack stackB = new ItemStack((IItemProvider)item);
        return WandUtil.stackEquals(stackA, stackB);
    }

    public static ItemStack holdingWand(PlayerEntity player) {
        if (player.func_184586_b(Hand.MAIN_HAND) != ItemStack.field_190927_a && player.func_184586_b(Hand.MAIN_HAND).func_77973_b() instanceof ItemWand) {
            return player.func_184586_b(Hand.MAIN_HAND);
        }
        if (player.func_184586_b(Hand.OFF_HAND) != ItemStack.field_190927_a && player.func_184586_b(Hand.OFF_HAND).func_77973_b() instanceof ItemWand) {
            return player.func_184586_b(Hand.OFF_HAND);
        }
        return null;
    }

    public static BlockPos playerPos(PlayerEntity player) {
        return new BlockPos(player.func_213303_ch());
    }

    public static Vector3d entityPositionVec(Entity entity) {
        return new Vector3d(entity.func_226277_ct_(), entity.func_226278_cu_() - entity.func_70033_W() + (double)(entity.func_213302_cg() / 2.0f), entity.func_226281_cx_());
    }

    public static Vector3d blockPosVec(BlockPos pos) {
        return new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
    }

    public static List<ItemStack> getHotbar(PlayerEntity player) {
        return player.field_71071_by.field_70462_a.subList(0, 9);
    }

    public static List<ItemStack> getHotbarWithOffhand(PlayerEntity player) {
        ArrayList<ItemStack> inventory = new ArrayList<ItemStack>(player.field_71071_by.field_70462_a.subList(0, 9));
        inventory.addAll((Collection<ItemStack>)player.field_71071_by.field_184439_c);
        return inventory;
    }

    public static List<ItemStack> getMainInv(PlayerEntity player) {
        return player.field_71071_by.field_70462_a.subList(9, player.field_71071_by.field_70462_a.size());
    }

    public static List<ItemStack> getFullInv(PlayerEntity player) {
        ArrayList<ItemStack> inventory = new ArrayList<ItemStack>((Collection<ItemStack>)player.field_71071_by.field_184439_c);
        inventory.addAll((Collection<ItemStack>)player.field_71071_by.field_70462_a);
        return inventory;
    }

    public static int blockDistance(BlockPos p1, BlockPos p2) {
        return Math.max(Math.abs(p1.func_177958_n() - p2.func_177958_n()), Math.abs(p1.func_177952_p() - p2.func_177952_p()));
    }

    public static boolean isTEAllowed(BlockState state) {
        if (!state.hasTileEntity()) {
            return true;
        }
        ResourceLocation name = state.func_177230_c().getRegistryName();
        if (name == null) {
            return false;
        }
        String fullId = name.toString();
        String modId = name.func_110624_b();
        boolean inList = ((List)ConfigServer.TE_LIST.get()).contains(fullId) || ((List)ConfigServer.TE_LIST.get()).contains(modId);
        boolean isWhitelist = (Boolean)ConfigServer.TE_WHITELIST.get();
        return isWhitelist == inList;
    }

    public static boolean placeBlock(World world, PlayerEntity player, BlockState block, BlockPos pos, @Nullable BlockItem item) {
        ItemStack stack;
        if (!world.func_175656_a(pos, block)) {
            ConstructionWand.LOGGER.info("Block could not be placed");
            return false;
        }
        BlockSnapshot snapshot = BlockSnapshot.create((RegistryKey)world.func_234923_W_(), (IWorld)world, (BlockPos)pos);
        BlockEvent.EntityPlaceEvent placeEvent = new BlockEvent.EntityPlaceEvent(snapshot, block, (Entity)player);
        MinecraftForge.EVENT_BUS.post((Event)placeEvent);
        if (placeEvent.isCanceled()) {
            world.func_217377_a(pos, false);
            return false;
        }
        if (item == null) {
            stack = new ItemStack((IItemProvider)block.func_177230_c().func_199767_j());
        } else {
            stack = new ItemStack((IItemProvider)item);
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)item));
        }
        block.func_177230_c().func_180633_a(world, pos, block, (LivingEntity)player, stack);
        return true;
    }

    public static boolean removeBlock(World world, PlayerEntity player, @Nullable BlockState block, BlockPos pos) {
        BlockState currentBlock = world.func_180495_p(pos);
        if (!world.func_175660_a(player, pos)) {
            return false;
        }
        if (!player.func_184812_l_()) {
            if (currentBlock.func_185887_b((IBlockReader)world, pos) <= -1.0f || world.func_175625_s(pos) != null) {
                return false;
            }
            if (block != null && !ReplacementRegistry.matchBlocks(currentBlock.func_177230_c(), block.func_177230_c())) {
                return false;
            }
        }
        BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent(world, pos, currentBlock, player);
        MinecraftForge.EVENT_BUS.post((Event)breakEvent);
        if (breakEvent.isCanceled()) {
            return false;
        }
        world.func_217377_a(pos, false);
        return true;
    }

    public static int countItem(PlayerEntity player, Item item) {
        if (player.field_71071_by == null || player.field_71071_by.field_70462_a == null) {
            return 0;
        }
        if (player.func_184812_l_()) {
            return Integer.MAX_VALUE;
        }
        int total = 0;
        ContainerManager containerManager = ConstructionWand.instance.containerManager;
        List<ItemStack> inventory = WandUtil.getFullInv(player);
        for (ItemStack stack : inventory) {
            if (stack == null) continue;
            if (WandUtil.stackEquals(stack, item)) {
                total += stack.func_190916_E();
                continue;
            }
            int amount = containerManager.countItems(player, new ItemStack((IItemProvider)item), stack);
            if (amount == Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            total += amount;
        }
        return total;
    }

    public static boolean matchBlocks(WandOptions options, Block b1, Block b2) {
        switch ((WandOptions.MATCH)((Object)options.match.get())) {
            case EXACT: {
                return b1 == b2;
            }
            case SIMILAR: {
                return ReplacementRegistry.matchBlocks(b1, b2);
            }
            case ANY: {
                return b1 != Blocks.field_150350_a && b2 != Blocks.field_150350_a;
            }
        }
        return false;
    }

    private static boolean isPositionModifiable(World world, PlayerEntity player, BlockPos pos) {
        if (!world.func_195588_v(pos)) {
            return false;
        }
        if (!world.func_175660_a(player, pos)) {
            return false;
        }
        return (Integer)ConfigServer.MAX_RANGE.get() <= 0 || WandUtil.blockDistance(player.func_233580_cy_(), pos) <= (Integer)ConfigServer.MAX_RANGE.get();
    }

    public static boolean isPositionPlaceable(World world, PlayerEntity player, BlockPos pos, boolean replace) {
        if (!WandUtil.isPositionModifiable(world, player, pos)) {
            return false;
        }
        return replace || world.func_175623_d(pos);
    }

    public static boolean isBlockRemovable(World world, PlayerEntity player, BlockPos pos) {
        if (!WandUtil.isPositionModifiable(world, player, pos)) {
            return false;
        }
        if (!player.func_184812_l_()) {
            return !(world.func_180495_p(pos).func_185887_b((IBlockReader)world, pos) <= -1.0f) && world.func_175625_s(pos) == null;
        }
        return true;
    }

    public static boolean entitiesCollidingWithBlock(World world, BlockState blockState, BlockPos pos) {
        VoxelShape shape = blockState.func_196952_d((IBlockReader)world, pos);
        if (!shape.func_197766_b()) {
            AxisAlignedBB blockBB = shape.func_197752_a().func_186670_a(pos);
            return !world.func_175647_a(LivingEntity.class, blockBB, EntityPredicates.field_180132_d).isEmpty();
        }
        return false;
    }

    public static Direction fromVector(Vector3d vector) {
        return Direction.func_210769_a((double)vector.field_72450_a, (double)vector.field_72448_b, (double)vector.field_72449_c);
    }
}

