/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.wand.action;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import thetadev.constructionwand.api.IWandAction;
import thetadev.constructionwand.api.IWandSupplier;
import thetadev.constructionwand.basics.ConfigServer;
import thetadev.constructionwand.basics.WandUtil;
import thetadev.constructionwand.basics.option.WandOptions;
import thetadev.constructionwand.wand.undo.DestroySnapshot;
import thetadev.constructionwand.wand.undo.ISnapshot;

public class ActionDestruction
implements IWandAction {
    @Override
    public int getLimit(ItemStack wand) {
        return ConfigServer.getWandProperties(wand.func_77973_b()).getDestruction();
    }

    @Override
    @Nonnull
    public List<ISnapshot> getSnapshots(World world, PlayerEntity player, BlockRayTraceResult rayTraceResult, ItemStack wand, WandOptions options, IWandSupplier supplier, int limit) {
        LinkedList<ISnapshot> destroySnapshots = new LinkedList<ISnapshot>();
        LinkedList<BlockPos> candidates = new LinkedList<BlockPos>();
        HashSet<BlockPos> allCandidates = new HashSet<BlockPos>();
        Direction breakDirection = rayTraceResult.func_216354_b();
        BlockPos startingPoint = rayTraceResult.func_216350_a();
        BlockState targetBlock = world.func_180495_p(rayTraceResult.func_216350_a());
        if (breakDirection == Direction.UP || breakDirection == Direction.DOWN) {
            if (options.testLock(WandOptions.LOCK.NORTHSOUTH) || options.testLock(WandOptions.LOCK.EASTWEST)) {
                candidates.add(startingPoint);
            }
        } else if (options.testLock(WandOptions.LOCK.HORIZONTAL) || options.testLock(WandOptions.LOCK.VERTICAL)) {
            candidates.add(startingPoint);
        }
        while (!candidates.isEmpty() && destroySnapshots.size() < limit) {
            BlockPos currentCandidate = (BlockPos)candidates.removeFirst();
            try {
                DestroySnapshot snapshot;
                BlockState candidateBlock = world.func_180495_p(currentCandidate);
                if (!WandUtil.matchBlocks(options, targetBlock.func_177230_c(), candidateBlock.func_177230_c()) || !allCandidates.add(currentCandidate) || (snapshot = DestroySnapshot.get(world, player, currentCandidate)) == null) continue;
                destroySnapshots.add(snapshot);
                switch (breakDirection) {
                    case DOWN: 
                    case UP: {
                        if (options.testLock(WandOptions.LOCK.NORTHSOUTH)) {
                            candidates.add(currentCandidate.func_177972_a(Direction.NORTH));
                            candidates.add(currentCandidate.func_177972_a(Direction.SOUTH));
                        }
                        if (options.testLock(WandOptions.LOCK.EASTWEST)) {
                            candidates.add(currentCandidate.func_177972_a(Direction.EAST));
                            candidates.add(currentCandidate.func_177972_a(Direction.WEST));
                        }
                        if (!options.testLock(WandOptions.LOCK.NORTHSOUTH) || !options.testLock(WandOptions.LOCK.EASTWEST)) break;
                        candidates.add(currentCandidate.func_177972_a(Direction.NORTH).func_177972_a(Direction.EAST));
                        candidates.add(currentCandidate.func_177972_a(Direction.NORTH).func_177972_a(Direction.WEST));
                        candidates.add(currentCandidate.func_177972_a(Direction.SOUTH).func_177972_a(Direction.EAST));
                        candidates.add(currentCandidate.func_177972_a(Direction.SOUTH).func_177972_a(Direction.WEST));
                        break;
                    }
                    case NORTH: 
                    case SOUTH: {
                        if (options.testLock(WandOptions.LOCK.HORIZONTAL)) {
                            candidates.add(currentCandidate.func_177972_a(Direction.EAST));
                            candidates.add(currentCandidate.func_177972_a(Direction.WEST));
                        }
                        if (options.testLock(WandOptions.LOCK.VERTICAL)) {
                            candidates.add(currentCandidate.func_177972_a(Direction.UP));
                            candidates.add(currentCandidate.func_177972_a(Direction.DOWN));
                        }
                        if (!options.testLock(WandOptions.LOCK.HORIZONTAL) || !options.testLock(WandOptions.LOCK.VERTICAL)) break;
                        candidates.add(currentCandidate.func_177972_a(Direction.UP).func_177972_a(Direction.EAST));
                        candidates.add(currentCandidate.func_177972_a(Direction.UP).func_177972_a(Direction.WEST));
                        candidates.add(currentCandidate.func_177972_a(Direction.DOWN).func_177972_a(Direction.EAST));
                        candidates.add(currentCandidate.func_177972_a(Direction.DOWN).func_177972_a(Direction.WEST));
                        break;
                    }
                    case EAST: 
                    case WEST: {
                        if (options.testLock(WandOptions.LOCK.HORIZONTAL)) {
                            candidates.add(currentCandidate.func_177972_a(Direction.NORTH));
                            candidates.add(currentCandidate.func_177972_a(Direction.SOUTH));
                        }
                        if (options.testLock(WandOptions.LOCK.VERTICAL)) {
                            candidates.add(currentCandidate.func_177972_a(Direction.UP));
                            candidates.add(currentCandidate.func_177972_a(Direction.DOWN));
                        }
                        if (!options.testLock(WandOptions.LOCK.HORIZONTAL) || !options.testLock(WandOptions.LOCK.VERTICAL)) break;
                        candidates.add(currentCandidate.func_177972_a(Direction.UP).func_177972_a(Direction.NORTH));
                        candidates.add(currentCandidate.func_177972_a(Direction.UP).func_177972_a(Direction.SOUTH));
                        candidates.add(currentCandidate.func_177972_a(Direction.DOWN).func_177972_a(Direction.NORTH));
                        candidates.add(currentCandidate.func_177972_a(Direction.DOWN).func_177972_a(Direction.SOUTH));
                    }
                }
            }
            catch (Exception exception) {}
        }
        return destroySnapshots;
    }

    @Override
    @Nonnull
    public List<ISnapshot> getSnapshotsFromAir(World world, PlayerEntity player, BlockRayTraceResult rayTraceResult, ItemStack wand, WandOptions options, IWandSupplier supplier, int limit) {
        return new ArrayList<ISnapshot>();
    }
}

