/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import thetadev.constructionwand.basics.WandUtil;
import thetadev.constructionwand.basics.option.IOption;
import thetadev.constructionwand.basics.option.WandOptions;
import thetadev.constructionwand.items.wand.ItemWand;

public class PacketWandOption {
    public final String key;
    public final String value;
    public final boolean notify;

    public PacketWandOption(IOption<?> option, boolean notify) {
        this(option.getKey(), option.getValueString(), notify);
    }

    private PacketWandOption(String key, String value, boolean notify) {
        this.key = key;
        this.value = value;
        this.notify = notify;
    }

    public static void encode(PacketWandOption msg, FriendlyByteBuf buffer) {
        buffer.m_130070_(msg.key);
        buffer.m_130070_(msg.value);
        buffer.writeBoolean(msg.notify);
    }

    public static PacketWandOption decode(FriendlyByteBuf buffer) {
        return new PacketWandOption(buffer.m_130136_(100), buffer.m_130136_(100), buffer.readBoolean());
    }

    public static class Handler {
        public static void handle(PacketWandOption msg, Supplier<NetworkEvent.Context> ctx) {
            if (!ctx.get().getDirection().getReceptionSide().isServer()) {
                return;
            }
            ServerPlayer player = ctx.get().getSender();
            if (player == null) {
                return;
            }
            ItemStack wand = WandUtil.holdingWand((Player)player);
            if (wand == null) {
                return;
            }
            WandOptions options = new WandOptions(wand);
            IOption<?> option = options.get(msg.key);
            if (option == null) {
                return;
            }
            option.setValueString(msg.value);
            if (msg.notify) {
                ItemWand.optionMessage((Player)player, option);
            }
            player.m_150109_().m_6596_();
        }
    }
}

