/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.wand;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import thetadev.constructionwand.ConstructionWand;
import thetadev.constructionwand.api.IWandAction;
import thetadev.constructionwand.api.IWandCore;
import thetadev.constructionwand.api.IWandSupplier;
import thetadev.constructionwand.basics.ConfigServer;
import thetadev.constructionwand.basics.ModStats;
import thetadev.constructionwand.basics.WandUtil;
import thetadev.constructionwand.basics.option.WandOptions;
import thetadev.constructionwand.items.ModItems;
import thetadev.constructionwand.items.wand.ItemWand;
import thetadev.constructionwand.wand.supplier.SupplierInventory;
import thetadev.constructionwand.wand.supplier.SupplierRandom;
import thetadev.constructionwand.wand.undo.ISnapshot;

public class WandJob {
    public final Player player;
    public final Level world;
    public final BlockHitResult rayTraceResult;
    public final WandOptions options;
    public final ItemStack wand;
    public final ItemWand wandItem;
    private final IWandAction wandAction;
    private final IWandSupplier wandSupplier;
    private List<ISnapshot> placeSnapshots;

    public WandJob(Player player, Level world, BlockHitResult rayTraceResult, ItemStack wand) {
        this.player = player;
        this.world = world;
        this.rayTraceResult = rayTraceResult;
        this.placeSnapshots = new ArrayList<ISnapshot>();
        this.wand = wand;
        this.wandItem = (ItemWand)wand.m_41720_();
        this.options = new WandOptions(wand);
        this.wandSupplier = this.options.random.get() != false ? new SupplierRandom(player, this.options) : new SupplierInventory(player, this.options);
        this.wandAction = ((IWandCore)this.options.cores.get()).getWandAction();
        this.wandSupplier.getSupply(WandJob.getTargetItem(world, rayTraceResult));
    }

    @Nullable
    private static BlockItem getTargetItem(Level world, BlockHitResult rayTraceResult) {
        Item tgitem = world.m_8055_(rayTraceResult.m_82425_()).m_60734_().m_5456_();
        if (!(tgitem instanceof BlockItem)) {
            return null;
        }
        return (BlockItem)tgitem;
    }

    public void getSnapshots() {
        int limit = this.player.m_7500_() && this.wandItem == ModItems.WAND_INFINITY ? (Integer)ConfigServer.LIMIT_CREATIVE.get() : Math.min(this.wandItem.remainingDurability(this.wand), this.wandAction.getLimit(this.wand));
        this.placeSnapshots = this.rayTraceResult.m_6662_() == HitResult.Type.BLOCK ? this.wandAction.getSnapshots(this.world, this.player, this.rayTraceResult, this.wand, this.options, this.wandSupplier, limit) : this.wandAction.getSnapshotsFromAir(this.world, this.player, this.rayTraceResult, this.wand, this.options, this.wandSupplier, limit);
    }

    public Set<BlockPos> getBlockPositions() {
        return this.placeSnapshots.stream().map(ISnapshot::getPos).collect(Collectors.toSet());
    }

    public boolean doIt() {
        ArrayList<ISnapshot> executed = new ArrayList<ISnapshot>();
        for (ISnapshot snapshot : this.placeSnapshots) {
            if (this.wand.m_41619_() || this.wandItem.remainingDurability(this.wand) == 0) break;
            if (!snapshot.execute(this.world, this.player, this.rayTraceResult)) continue;
            if (this.wandSupplier.takeItemStack(snapshot.getRequiredItems()) == 0) {
                executed.add(snapshot);
            } else {
                ConstructionWand.LOGGER.info("Item could not be taken. Remove block: " + snapshot.getBlockState().m_60734_().toString());
                snapshot.forceRestore(this.world);
            }
            this.wand.m_41629_(1, this.player.m_21187_(), (ServerPlayer)this.player);
            this.player.m_36220_(ModStats.USE_WAND);
        }
        this.placeSnapshots = executed;
        if (!this.placeSnapshots.isEmpty()) {
            SoundType sound = this.placeSnapshots.get(0).getBlockState().m_60827_();
            this.world.m_5594_(null, WandUtil.playerPos(this.player), sound.m_56777_(), SoundSource.BLOCKS, sound.f_56731_, sound.f_56732_);
            ConstructionWand.instance.undoHistory.add(this.player, this.world, this.placeSnapshots);
        }
        return !this.placeSnapshots.isEmpty();
    }
}

