/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.wand.undo;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fmllegacy.network.PacketDistributor;
import thetadev.constructionwand.ConstructionWand;
import thetadev.constructionwand.basics.ConfigServer;
import thetadev.constructionwand.basics.WandUtil;
import thetadev.constructionwand.network.PacketUndoBlocks;
import thetadev.constructionwand.wand.undo.ISnapshot;

public class UndoHistory {
    private final HashMap<UUID, PlayerEntry> history = new HashMap();

    private PlayerEntry getEntryFromPlayer(Player player) {
        return this.history.computeIfAbsent(player.m_142081_(), k -> new PlayerEntry());
    }

    public void add(Player player, Level world, List<ISnapshot> placeSnapshots) {
        LinkedList<HistoryEntry> list = this.getEntryFromPlayer((Player)player).entries;
        list.add(new HistoryEntry(placeSnapshots, world));
        while (list.size() > (Integer)ConfigServer.UNDO_HISTORY.get()) {
            list.removeFirst();
        }
    }

    public void removePlayer(Player player) {
        this.history.remove(player.m_142081_());
    }

    public void updateClient(Player player, boolean ctrlDown) {
        HistoryEntry entry;
        Level world = player.f_19853_;
        if (world.f_46443_) {
            return;
        }
        PlayerEntry playerEntry = this.getEntryFromPlayer(player);
        playerEntry.undoActive = ctrlDown;
        LinkedList<HistoryEntry> historyEntries = playerEntry.entries;
        Set<Object> positions = historyEntries.isEmpty() ? Collections.emptySet() : ((entry = historyEntries.getLast()) == null || !entry.world.equals(world) ? Collections.emptySet() : entry.getBlockPositions());
        PacketUndoBlocks packet = new PacketUndoBlocks(positions);
        ConstructionWand.instance.HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)packet);
    }

    public boolean isUndoActive(Player player) {
        return this.getEntryFromPlayer((Player)player).undoActive;
    }

    public boolean undo(Player player, Level world, BlockPos pos) {
        PlayerEntry playerEntry = this.getEntryFromPlayer(player);
        if (!playerEntry.undoActive) {
            return false;
        }
        LinkedList<HistoryEntry> historyEntries = playerEntry.entries;
        if (historyEntries.isEmpty()) {
            return false;
        }
        HistoryEntry entry = historyEntries.getLast();
        if (!entry.world.equals(world) || !entry.withinRange(pos)) {
            return false;
        }
        if (entry.undo(player)) {
            historyEntries.remove(entry);
            this.updateClient(player, true);
            return true;
        }
        return false;
    }

    private static class PlayerEntry {
        public final LinkedList<HistoryEntry> entries = new LinkedList();
        public boolean undoActive = false;
    }

    private static class HistoryEntry {
        public final List<ISnapshot> placeSnapshots;
        public final Level world;

        public HistoryEntry(List<ISnapshot> placeSnapshots, Level world) {
            this.placeSnapshots = placeSnapshots;
            this.world = world;
        }

        public Set<BlockPos> getBlockPositions() {
            return this.placeSnapshots.stream().map(ISnapshot::getPos).collect(Collectors.toSet());
        }

        public boolean withinRange(BlockPos pos) {
            Set<BlockPos> positions = this.getBlockPositions();
            if (positions.contains(pos)) {
                return true;
            }
            for (BlockPos p : positions) {
                if (!pos.m_123314_((Vec3i)p, 3.0)) continue;
                return true;
            }
            return false;
        }

        public boolean undo(Player player) {
            for (ISnapshot snapshot : this.placeSnapshots) {
                if (snapshot.canRestore(this.world, player)) continue;
                return false;
            }
            for (ISnapshot snapshot : this.placeSnapshots) {
                if (!snapshot.restore(this.world, player) || player.m_7500_()) continue;
                ItemStack stack = snapshot.getRequiredItems();
                if (player.m_150109_().m_36054_(stack)) continue;
                player.m_36176_(stack, false);
            }
            player.m_150109_().m_6596_();
            SoundEvent sound = SoundEvents.f_11757_;
            this.world.m_5594_(null, WandUtil.playerPos(player), sound, SoundSource.PLAYERS, 1.0f, 1.0f);
            return true;
        }
    }
}

