/*
 * Decompiled with CFR 0.152.
 */
package net.nerds.fishtraps;

import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.nerds.fishtraps.blocks.DiamondTrap.DiamondFishTrap;
import net.nerds.fishtraps.blocks.DiamondTrap.DiamondFishTrapContainer;
import net.nerds.fishtraps.blocks.DiamondTrap.DiamondFishTrapTileEntity;
import net.nerds.fishtraps.blocks.IronTrap.IronFishTrap;
import net.nerds.fishtraps.blocks.IronTrap.IronFishTrapContainer;
import net.nerds.fishtraps.blocks.IronTrap.IronFishTrapTileEntity;
import net.nerds.fishtraps.blocks.WoodenTrap.WoodenFishTrap;
import net.nerds.fishtraps.blocks.WoodenTrap.WoodenFishTrapContainer;
import net.nerds.fishtraps.blocks.WoodenTrap.WoodenFishTrapTileEntity;
import net.nerds.fishtraps.items.FishBait;
import net.nerds.fishtraps.util.FishTrapsConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class FishTrapsManager {
    private static final Logger LOGGER = LogManager.getLogger();
    public static WoodenFishTrap woodenFishTrap = new WoodenFishTrap();
    public static IronFishTrap ironFishTrap = new IronFishTrap();
    public static DiamondFishTrap diamondFishTrap = new DiamondFishTrap();
    public static ItemGroup fishTrapItemGroup = new ItemGroup("fishtraps.fishtraps"){

        @OnlyIn(value=Dist.CLIENT)
        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)Items.field_151112_aM);
        }
    };

    @SubscribeEvent
    public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
        blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)woodenFishTrap);
        blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)ironFishTrap);
        blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)diamondFishTrap);
    }

    @SubscribeEvent
    public static void onItemRegistry(RegistryEvent.Register<Item> itemRegistryEvent) {
        itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)new FishBait());
        itemRegistryEvent.getRegistry().register(new BlockItem((Block)woodenFishTrap, new Item.Properties().func_200916_a(fishTrapItemGroup)).setRegistryName(Objects.requireNonNull(woodenFishTrap.getRegistryName())));
        itemRegistryEvent.getRegistry().register(new BlockItem((Block)ironFishTrap, new Item.Properties().func_200916_a(fishTrapItemGroup)).setRegistryName(Objects.requireNonNull(ironFishTrap.getRegistryName())));
        itemRegistryEvent.getRegistry().register(new BlockItem((Block)diamondFishTrap, new Item.Properties().func_200916_a(fishTrapItemGroup)).setRegistryName(Objects.requireNonNull(diamondFishTrap.getRegistryName())));
    }

    @SubscribeEvent
    public static void registerTileEntityTypes(RegistryEvent.Register<TileEntityType<?>> event) {
        event.getRegistry().register(TileEntityType.Builder.func_223042_a(() -> new WoodenFishTrapTileEntity((Integer)FishTrapsConfig.FISH_TRAPS_CONFIG.woodenTrapBaseTime.get(), (Integer)FishTrapsConfig.FISH_TRAPS_CONFIG.woodenTrapLureLevel.get(), (Integer)FishTrapsConfig.FISH_TRAPS_CONFIG.woodenTrapLuckLevel.get()), (Block[])new Block[]{woodenFishTrap}).func_206865_a(null).setRegistryName(Objects.requireNonNull(woodenFishTrap.getRegistryName())));
        event.getRegistry().register(TileEntityType.Builder.func_223042_a(() -> new IronFishTrapTileEntity((Integer)FishTrapsConfig.FISH_TRAPS_CONFIG.ironTrapBaseTime.get(), (Integer)FishTrapsConfig.FISH_TRAPS_CONFIG.ironTrapLureLevel.get(), (Integer)FishTrapsConfig.FISH_TRAPS_CONFIG.ironTrapLuckLevel.get()), (Block[])new Block[]{ironFishTrap}).func_206865_a(null).setRegistryName(Objects.requireNonNull(ironFishTrap.getRegistryName())));
        event.getRegistry().register(TileEntityType.Builder.func_223042_a(() -> new DiamondFishTrapTileEntity((Integer)FishTrapsConfig.FISH_TRAPS_CONFIG.diamondTrapBaseTime.get(), (Integer)FishTrapsConfig.FISH_TRAPS_CONFIG.diamondTrapLureLevel.get(), (Integer)FishTrapsConfig.FISH_TRAPS_CONFIG.diamondTrapLuckLevel.get()), (Block[])new Block[]{diamondFishTrap}).func_206865_a(null).setRegistryName(Objects.requireNonNull(diamondFishTrap.getRegistryName())));
    }

    @SubscribeEvent
    public static void registerContainerTypes(RegistryEvent.Register<ContainerType<?>> event) {
        event.getRegistry().register(new ContainerType((windowId, playerInv) -> new WoodenFishTrapContainer(windowId, playerInv, new WoodenFishTrapTileEntity((Integer)FishTrapsConfig.FISH_TRAPS_CONFIG.woodenTrapBaseTime.get(), (Integer)FishTrapsConfig.FISH_TRAPS_CONFIG.woodenTrapLureLevel.get(), (Integer)FishTrapsConfig.FISH_TRAPS_CONFIG.woodenTrapLuckLevel.get()).getInventory())).setRegistryName("fishtraps:wooden_fish_trap"));
        event.getRegistry().register(new ContainerType((windowId, playerInv) -> new IronFishTrapContainer(windowId, playerInv, new IronFishTrapTileEntity((Integer)FishTrapsConfig.FISH_TRAPS_CONFIG.ironTrapBaseTime.get(), (Integer)FishTrapsConfig.FISH_TRAPS_CONFIG.ironTrapLureLevel.get(), (Integer)FishTrapsConfig.FISH_TRAPS_CONFIG.ironTrapLuckLevel.get()).getInventory())).setRegistryName("fishtraps:iron_fish_trap"));
        event.getRegistry().register(new ContainerType((windowId, playerInv) -> new DiamondFishTrapContainer(windowId, playerInv, new DiamondFishTrapTileEntity((Integer)FishTrapsConfig.FISH_TRAPS_CONFIG.diamondTrapBaseTime.get(), (Integer)FishTrapsConfig.FISH_TRAPS_CONFIG.diamondTrapLureLevel.get(), (Integer)FishTrapsConfig.FISH_TRAPS_CONFIG.diamondTrapLuckLevel.get()).getInventory())).setRegistryName("fishtraps:diamond_fish_trap"));
    }
}

