/*
 * Decompiled with CFR 0.152.
 */
package net.nerds.fishtraps.blocks.BaseTrap;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RangedWrapper;
import net.nerds.fishtraps.blocks.BaseTrap.BaseFishTrapBlock;
import net.nerds.fishtraps.items.FishBait;
import net.nerds.fishtraps.util.FishTrapItemHandler;
import net.nerds.fishtraps.util.FishTrapsConfig;

public abstract class BaseFishTrapTileEntity
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    private FishTrapItemHandler fishTrapItemHandler = new FishTrapItemHandler();
    private RangedWrapper itemHandlerBait = new RangedWrapper((IItemHandlerModifiable)this.fishTrapItemHandler, 0, 1);
    private RangedWrapper itemHandlerOutput = new RangedWrapper((IItemHandlerModifiable)this.fishTrapItemHandler, 1, 46);
    private LazyOptional capBait = LazyOptional.of(() -> this.itemHandlerBait);
    private LazyOptional capOutput = LazyOptional.of(() -> this.itemHandlerOutput);
    private long tickCounter = 0L;
    private long tickCheck;
    private int luckOfTheSeaLevel;
    private int lureLevel;
    private boolean shouldPenalize;
    private int penaltyMultiplier;
    private int penaltyTickCheck;
    private boolean showFishBait = false;
    private ResourceLocation lootLocation;

    public BaseFishTrapTileEntity(TileEntityType tileEntityType, long delay, int lure, int luck) {
        super(tileEntityType);
        this.lootLocation = new ResourceLocation("fishtraps", "traps/" + tileEntityType.getRegistryName().func_110623_a());
        this.luckOfTheSeaLevel = luck;
        this.lureLevel = lure;
        this.shouldPenalize = (Boolean)FishTrapsConfig.FISH_TRAPS_CONFIG.shouldTrapHavePenalty.get();
        this.penaltyMultiplier = (Integer)FishTrapsConfig.FISH_TRAPS_CONFIG.trapPenaltyMultiplier.get();
        this.penaltyTickCheck = (int)delay * this.penaltyMultiplier;
        this.tickCheck = delay;
    }

    public void func_73660_a() {
        if (this.tickCounter >= this.getValidationNumber()) {
            this.tickCounter = 0L;
            this.validateWaterAndFish();
        } else {
            ++this.tickCounter;
        }
    }

    private long getValidationNumber() {
        boolean bl = this.showFishBait = this.itemHandlerBait.getStackInSlot(0).func_190916_E() > 0;
        if (!this.showFishBait && this.shouldPenalize) {
            return this.penaltyTickCheck;
        }
        return this.tickCheck;
    }

    private void validateWaterAndFish() {
        if (!this.field_145850_b.field_72995_K) {
            boolean isSurroundedByWater = true;
            Iterable waterCheckInterator = BlockPos.func_218278_a((BlockPos)new BlockPos(this.field_174879_c.func_177958_n() - 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 1), (BlockPos)new BlockPos(this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + 1));
            for (BlockPos blockPos : waterCheckInterator) {
                Block block = this.field_145850_b.func_180495_p(blockPos).func_177230_c();
                if (this.field_145850_b.func_175625_s(this.field_174879_c) == null || block == Blocks.field_150355_j || block instanceof BaseFishTrapBlock) continue;
                isSurroundedByWater = false;
                break;
            }
            if (isSurroundedByWater) {
                this.fish();
            }
        }
    }

    private void fish() {
        ItemStack itemStack = new ItemStack((IItemProvider)Items.field_151112_aM);
        itemStack.func_77966_a(Enchantments.field_151369_A, this.lureLevel);
        itemStack.func_77966_a(Enchantments.field_151370_z, this.luckOfTheSeaLevel);
        LootContext.Builder lootContextBuilder = new LootContext.Builder((ServerWorld)this.field_145850_b).func_216015_a(LootParameters.field_216286_f, (Object)new BlockPos((Vector3i)this.field_174879_c)).func_216015_a(LootParameters.field_216289_i, (Object)itemStack).func_216023_a(this.field_145850_b.field_73012_v).func_186469_a((float)this.lureLevel);
        LootTable lootTable = Objects.requireNonNull(this.field_145850_b.func_73046_m()).func_200249_aQ().func_186521_a(this.lootLocation);
        List list = lootTable.func_216113_a(lootContextBuilder.func_216022_a(LootParameterSets.field_216262_c));
        this.fishTrapItemHandler.addListToInventory(list);
        ItemStack fishBait = this.itemHandlerBait.getStackInSlot(0);
        if (fishBait.func_77973_b() instanceof FishBait && fishBait.func_96631_a(1, this.field_145850_b.field_73012_v, null)) {
            this.fishTrapItemHandler.setStackInSlot(0, ItemStack.field_190927_a);
            this.func_70296_d();
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        ItemStackHelper.func_191282_a((CompoundNBT)compound, (NonNullList)this.fishTrapItemHandler.getList());
        return compound;
    }

    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        ItemStackHelper.func_191283_b((CompoundNBT)compound, (NonNullList)this.fishTrapItemHandler.getList());
        this.fishTrapItemHandler.deserializeNBT(compound);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (side == Direction.UP) {
            return cap.orEmpty(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.capBait);
        }
        if (side == Direction.DOWN) {
            return cap.orEmpty(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.capOutput);
        }
        return LazyOptional.empty();
    }

    public FishTrapItemHandler getInventory() {
        return this.fishTrapItemHandler;
    }
}

