/*
 * Decompiled with CFR 0.152.
 */
package net.nerds.fishtraps.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FishTrapsConfig {
    private static Logger logger = LogManager.getLogger();
    private String fishTrapJsonLocation = FabricLoader.getInstance().getConfigDirectory().getPath() + "/fishTrap.json";
    private File configFile = new File(this.fishTrapJsonLocation);
    private JsonObject config;
    private Gson gson;

    public void loadConfig() {
        try {
            FileReader fileReader = new FileReader(this.fishTrapJsonLocation);
            this.setConfigs(fileReader);
        }
        catch (FileNotFoundException e) {
            this.buildFile();
        }
    }

    public void buildFile() {
        JsonObject jsonObject = this.getDefaults();
        try {
            FileWriter writer = new FileWriter(this.fishTrapJsonLocation);
            writer.write(jsonObject.toString());
            writer.flush();
        }
        catch (IOException e) {
            logger.fatal("Config IO Error", (Throwable)e);
        }
        this.config = jsonObject;
    }

    private void setConfigs(FileReader fileReader) {
        JsonParser parser = new JsonParser();
        this.config = parser.parse((Reader)fileReader).getAsJsonObject();
    }

    private JsonObject getDefaults() {
        JsonObject fishTrapJson = new JsonObject();
        fishTrapJson.add("woodenTrapBaseTime", (JsonElement)new JsonPrimitive((Number)900));
        fishTrapJson.add("woodenTrapLureLevel", (JsonElement)new JsonPrimitive((Number)1));
        fishTrapJson.add("woodenTrapLuckOfTheSeaLevel", (JsonElement)new JsonPrimitive((Number)1));
        fishTrapJson.add("ironTrapBaseTime", (JsonElement)new JsonPrimitive((Number)600));
        fishTrapJson.add("ironTrapLureLevel", (JsonElement)new JsonPrimitive((Number)2));
        fishTrapJson.add("ironTrapLuckOfTheSeaLevel", (JsonElement)new JsonPrimitive((Number)2));
        fishTrapJson.add("diamondTrapBaseTime", (JsonElement)new JsonPrimitive((Number)400));
        fishTrapJson.add("diamondTrapLureLevel", (JsonElement)new JsonPrimitive((Number)3));
        fishTrapJson.add("diamondTrapLuckOfTheSeaLevel", (JsonElement)new JsonPrimitive((Number)3));
        fishTrapJson.add("trapPenaltyMultiplier", (JsonElement)new JsonPrimitive((Number)40));
        fishTrapJson.add("shouldTrapHavePenalty", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
        fishTrapJson.add("fishBaitDurability", (JsonElement)new JsonPrimitive((Number)400));
        return fishTrapJson;
    }

    public int getProperty(String key) {
        try {
            return this.config.get(key).getAsInt();
        }
        catch (NumberFormatException nex) {
            logger.error("Can not Format the value you entered for {} into a number.  reverting to default", (Object)key);
            return this.getDefaults().get(key).getAsInt();
        }
        catch (Exception ex) {
            logger.error("Can not Format the value you entered for {} into a number..  reverting to default", (Object)key);
            return this.getDefaults().get(key).getAsInt();
        }
    }

    public boolean getBooleanProperty(String key) {
        try {
            return this.config.get(key).getAsBoolean();
        }
        catch (UnsupportedOperationException ex) {
            logger.error("Can not Format the value you entered for {} into a boolean..  reverting to default", (Object)key);
            return this.getDefaults().get(key).getAsBoolean();
        }
        catch (Exception ex) {
            logger.error("Can not Format the value you entered for {} into a boolean..  reverting to default", (Object)key);
            return this.getDefaults().get(key).getAsBoolean();
        }
    }
}

