/*
 * Decompiled with CFR 0.152.
 */
package net.nerds.fishtraps.util;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class FishTrapsConfig {
    public static final ForgeConfigSpec FORGE_CONFIG_SPEC;
    public static final FishTrapsConfig FISH_TRAPS_CONFIG;
    public final ForgeConfigSpec.IntValue woodenTrapLureLevel;
    public final ForgeConfigSpec.IntValue woodenTrapLuckLevel;
    public final ForgeConfigSpec.IntValue woodenTrapBaseTime;
    public final ForgeConfigSpec.IntValue ironTrapLureLevel;
    public final ForgeConfigSpec.IntValue ironTrapLuckLevel;
    public final ForgeConfigSpec.IntValue ironTrapBaseTime;
    public final ForgeConfigSpec.IntValue diamondTrapLureLevel;
    public final ForgeConfigSpec.IntValue diamondTrapLuckLevel;
    public final ForgeConfigSpec.IntValue diamondTrapBaseTime;
    public final ForgeConfigSpec.IntValue trapPenaltyMultiplier;
    public final ForgeConfigSpec.IntValue fishBaitDurability;
    public final ForgeConfigSpec.BooleanValue shouldTrapHavePenalty;

    FishTrapsConfig(ForgeConfigSpec.Builder builder) {
        this.woodenTrapLureLevel = builder.comment("The Lure Level of the wooden trap").defineInRange("woodenTrapLureLevel", 1, 0, 10);
        this.woodenTrapLuckLevel = builder.comment("The Lure Level of the wooden trap").defineInRange("woodenTrapLuckLevel", 1, 0, 10);
        this.woodenTrapBaseTime = builder.comment("The Lure Level of the wooden trap").defineInRange("woodenTrapBaseTime", 900, 20, 2000000000);
        this.ironTrapLureLevel = builder.comment("The Lure Level of the Iron trap").defineInRange("ironTrapLureLevel", 2, 0, 10);
        this.ironTrapLuckLevel = builder.comment("The Lure Level of the Iron trap").defineInRange("ironTrapLuckLevel", 2, 0, 10);
        this.ironTrapBaseTime = builder.comment("The Lure Level of the Iron trap").defineInRange("ironTrapBaseTime", 600, 20, 2000000000);
        this.diamondTrapLureLevel = builder.comment("The Lure Level of the diamond trap").defineInRange("diamondTrapLureLevel", 3, 0, 10);
        this.diamondTrapLuckLevel = builder.comment("The Lure Level of the diamond trap").defineInRange("diamondTrapLuckLevel", 3, 0, 10);
        this.diamondTrapBaseTime = builder.comment("The Lure Level of the diamond trap").defineInRange("diamondTrapBaseTime", 400, 20, 2000000000);
        this.trapPenaltyMultiplier = builder.comment("The Multiplier penalty of traps without fishbait").defineInRange("trapPenaltyMultiplier", 40, 1, 1000);
        this.fishBaitDurability = builder.comment("The durability of fish bait (NOT implemented yet").defineInRange("fishBaitDurability", 400, 1, 2000000000);
        this.shouldTrapHavePenalty = builder.comment("Should fish traps be penalized if they dont have bait in them").define("shouldTrapHavePenalty", true);
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(FishTrapsConfig::new);
        FORGE_CONFIG_SPEC = (ForgeConfigSpec)specPair.getRight();
        FISH_TRAPS_CONFIG = (FishTrapsConfig)specPair.getLeft();
    }
}

