/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.flying_things;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import ovh.corail.flying_things.packet.PacketHandler;
import ovh.corail.flying_things.packet.UpdateClientMessage;

@Mod.EventBusSubscriber(modid="flying_things")
@Config(modid="flying_things", name="flying_things", category="")
public class ConfigFlyingThings {
    @Config.Name(value="general")
    @Config.LangKey(value="flying_things.config.cat.general")
    @Config.Comment(value={"Theses options can only be modified on the server in multiplayer"})
    public static General general = new General();
    @Config.Name(value="client")
    @Config.LangKey(value="flying_things.config.cat.client")
    @Config.Comment(value={"Theses options are custom parameters for the player"})
    public static Client client = new Client();
    @Config.Name(value="denied_dimension_to_fly")
    @Config.LangKey(value="flying_things.config.cat.denied_dimension_to_fly")
    @Config.Comment(value={"Denied dimension ids to ride a flying thing"})
    public static DeniedDimensionToFly deniedDimensionToFly = new DeniedDimensionToFly();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("flying_things")) {
            ConfigManager.sync((String)"flying_things", (Config.Type)Config.Type.INSTANCE);
            if (Minecraft.func_71410_x().func_71356_B()) {
                ConfigFlyingThings.updateServerDatas();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerLogued(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player != null && event.player.func_70613_aW()) {
            PacketHandler.INSTANCE.sendTo((IMessage)new UpdateClientMessage(ConfigFlyingThings.general.speedMax, ConfigFlyingThings.general.accelerationMax, ConfigFlyingThings.general.accelerationIncrement, ConfigFlyingThings.general.speedMaxNoEnergy, ConfigFlyingThings.general.maxEnergy, ConfigFlyingThings.general.allowTombstoneSoulbound), (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onWorldLoad(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K) {
            ConfigFlyingThings.updateServerDatas();
        }
    }

    private static void updateServerDatas() {
        General.serverSpeedMax = ConfigFlyingThings.general.speedMax;
        General.serverAccelerationMax = ConfigFlyingThings.general.accelerationMax;
        General.serverAccelerationIncrement = ConfigFlyingThings.general.accelerationIncrement;
        General.serverSpeedMaxNoEnergy = ConfigFlyingThings.general.speedMaxNoEnergy;
        General.serverMaxEnergy = ConfigFlyingThings.general.maxEnergy;
        General.serverAllowTombstoneSoulbound = ConfigFlyingThings.general.allowTombstoneSoulbound;
    }

    public static class DeniedDimensionToFly {
        @Config.Name(value="deniedDimensionBroom")
        @Config.LangKey(value="flying_things.config.denied_dimension_broom")
        @Config.Comment(value={"Dimensions for the brooms"})
        public int[] deniedDimensionBroom = new int[0];
        @Config.Name(value="deniedDimensionCarpet")
        @Config.LangKey(value="flying_things.config.denied_dimension_carpet")
        @Config.Comment(value={"Dimensions for the carpets"})
        public int[] deniedDimensionCarpet = new int[0];
    }

    public static class Client {
        @Config.Name(value="renderEffect")
        @Config.LangKey(value="flying_things.config.render_effect")
        @Config.Comment(value={"Enable rendering effects"})
        public boolean renderEffect = true;
        @Config.Name(value="barLength")
        @Config.LangKey(value="flying_things.config.bar_length")
        @Config.RangeInt(min=9, max=182)
        @Config.Comment(value={"Length of the bars"})
        public int barLength = 182;
        @Config.Name(value="barHeightPos")
        @Config.LangKey(value="flying_things.config.bar_height_pos")
        @Config.RangeInt(min=0)
        @Config.Comment(value={"Height of the position of the bars"})
        public int barHeightPos = 62;
    }

    public static class General {
        @Config.Name(value="speedMax")
        @Config.LangKey(value="flying_things.config.speed_max")
        @Config.RangeInt(min=0, max=300)
        @Config.Comment(value={"Maximum Speed"})
        public int speedMax = 90;
        @Config.Name(value="accelerationMax")
        @Config.LangKey(value="flying_things.config.acceleration_max")
        @Config.RangeInt(min=0, max=100)
        @Config.Comment(value={"Maximum acceleration"})
        public int accelerationMax = 35;
        @Config.Name(value="accelerationIncrement")
        @Config.LangKey(value="flying_things.config.acceleration_increment")
        @Config.RangeInt(min=1, max=20)
        @Config.Comment(value={"Acceleration increment"})
        public int accelerationIncrement = 7;
        @Config.Name(value="speedMaxNoEnergy")
        @Config.LangKey(value="flying_things.config.speed_max_no_energy")
        @Config.RangeInt(min=0, max=300)
        @Config.Comment(value={"Maximum speed with no energy"})
        public int speedMaxNoEnergy = 30;
        @Config.Name(value="maxEnergy")
        @Config.LangKey(value="flying_things.config.max_energy")
        @Config.RangeInt(min=100)
        @Config.Comment(value={"Maximum energy"})
        public int maxEnergy = 1000;
        @Config.Name(value="timeToLoseEnergy")
        @Config.LangKey(value="flying_things.config.time_to_lose_energy")
        @Config.RangeInt(min=5)
        @Config.Comment(value={"Time to lose an energy point"})
        public int timeToLoseEnergy = 5;
        @Config.Name(value="timeToRecoverEnergy")
        @Config.LangKey(value="flying_things.config.time_to_recover_energy")
        @Config.RangeInt(min=5)
        @Config.Comment(value={"Time to recover an energy point"})
        public int timeToRecoverEnergy = 5;
        @Config.Name(value="allowTombstoneSoulbound")
        @Config.LangKey(value="flying_things.config.allow_tombstone_soulbound")
        @Config.Comment(value={"Allow applying Soulbound"})
        public boolean allowTombstoneSoulbound = true;
        @Config.Name(value="allowToFlyInWater")
        @Config.LangKey(value="flying_things.config.allow_to_fly_in_water")
        @Config.Comment(value={"Allow flying in water"})
        public boolean allowToFlyInWater = true;
        @Config.Name(value="allowToBreakPlant")
        @Config.LangKey(value="flying_things.config.allow_to_break_plant")
        @Config.Comment(value={"Allow breaking plants"})
        public boolean allowToBreakPlant = true;
        @Config.Name(value="allowSpecialRegen")
        @Config.LangKey(value="flying_things.config.allow_special_regen")
        @Config.Comment(value={"Allow special regeneration"})
        public boolean allowSpecialRegen = true;
        @Config.Name(value="chanceToFallWithProjectile")
        @Config.LangKey(value="flying_things.config.chance_to_fall_with_projectile")
        @Config.RangeInt(min=0, max=100)
        @Config.Comment(value={"Chance to fall with projectiles"})
        public int chanceToFallWithProjectile = 10;
        @Config.Name(value="persistantHolidays")
        @Config.LangKey(value="flying_things.config.persistant_holidays")
        @Config.Comment(value={"Allow special holiday events outside periods"})
        public boolean persistantHolidays = false;
        @Config.Name(value="chanceDropPumpkinStick")
        @Config.LangKey(value="flying_things.config.chance_drop_pumpkin_stick")
        @Config.RangeInt(min=0, max=100)
        @Config.Comment(value={"Chance to get Halloween Sticks during this event"})
        public int chanceDropPumpkinStick = 5;
        @Config.Name(value="treasureLootTable")
        @Config.LangKey(value="flying_things.config.treasure_loot_table")
        @Config.Comment(value={"Defines the loottables having a chance to contain a Phial of Animation"})
        public String[] treasureLootTable = new String[]{"minecraft:chests/end_city_treasure", "minecraft:chests/abandoned_mineshaft", "minecraft:chests/nether_bridge", "minecraft:chests/stronghold_library", "minecraft:chests/desert_pyramid", "minecraft:chests/jungle_temple", "minecraft:chests/igloo_chest", "minecraft:chests/woodland_mansion"};
        public static int serverSpeedMax;
        public static int serverAccelerationMax;
        public static int serverAccelerationIncrement;
        public static int serverSpeedMaxNoEnergy;
        public static int serverMaxEnergy;
        public static boolean serverAllowTombstoneSoulbound;

        public static int getSpeedMax() {
            return serverSpeedMax;
        }

        public static int getAccelerationMax() {
            return serverAccelerationMax;
        }

        public static int getAccelerationIncrement() {
            return serverAccelerationIncrement;
        }

        public static int getSpeedMaxNoEnergy() {
            return serverSpeedMaxNoEnergy;
        }

        public static int getMaxEnergy() {
            return serverMaxEnergy;
        }

        public static boolean isSoulboundAllowed() {
            return serverAllowTombstoneSoulbound;
        }
    }
}

