/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.flying_things.entity;

import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import ovh.corail.flying_things.ConfigFlyingThings;
import ovh.corail.flying_things.entity.EntityAbstractFlyingThing;
import ovh.corail.flying_things.helper.Helper;
import ovh.corail.flying_things.registry.ModItems;

public class EntityEnchantedBroom
extends EntityAbstractFlyingThing {
    private static final DataParameter<Integer> ENERGY = EntityDataManager.func_187226_a(EntityEnchantedBroom.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TIME_SINCE_HIT = EntityDataManager.func_187226_a(EntityEnchantedBroom.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> DAMAGE_TAKEN = EntityDataManager.func_187226_a(EntityEnchantedBroom.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> FORWARD_DIRECTION = EntityDataManager.func_187226_a(EntityEnchantedBroom.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> MODEL_TYPE = EntityDataManager.func_187226_a(EntityEnchantedBroom.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> HEAD_TYPE = EntityDataManager.func_187226_a(EntityEnchantedBroom.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityEnchantedBroom(World world) {
        super(world);
        this.func_70105_a(1.2f, 0.2f);
    }

    public EntityEnchantedBroom(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y, z);
    }

    @Override
    public ItemStack getStack() {
        ItemStack stack = new ItemStack((Item)ModItems.enchantedBroom, 1, this.getModelType());
        if (this.func_145818_k_()) {
            stack.func_151001_c(this.func_95999_t());
        }
        ModItems.enchantedBroom.setEnergy(stack, this.getEnergy());
        if (this.hasSoulbound()) {
            ModItems.enchantedBroom.setSoulbound(stack);
        }
        if (this.getHeadType() > 0) {
            ModItems.enchantedBroom.setHeadType(stack, this.getHeadType());
        }
        return stack;
    }

    @Override
    public boolean canFlyInDimension(int dimId) {
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        return IntStream.range(0, ConfigFlyingThings.deniedDimensionToFly.deniedDimensionBroom.length).noneMatch(i -> ConfigFlyingThings.deniedDimensionToFly.deniedDimensionBroom[i] == dimId);
    }

    @Override
    public void func_70071_h_() {
        if (ConfigFlyingThings.general.allowSpecialRegen && this.getEnergy() < ConfigFlyingThings.General.getMaxEnergy() && this.field_70173_aa % 10 == 0 && this.field_70170_p.func_175667_e(this.func_180425_c().func_177977_b()) && this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()).func_177230_c() == Blocks.field_150419_aX) {
            if (!this.field_70170_p.field_72995_K) {
                this.setEnergy(this.getEnergy() + 4);
                this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_193784_dd, SoundCategory.PLAYERS, 0.5f, 0.5f);
            } else {
                for (int i = 0; i < Helper.getRandom(10, 45); ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_WITCH, this.field_70165_t + this.field_70146_Z.nextGaussian() * 0.4, this.func_174813_aQ().field_72337_e + this.field_70146_Z.nextGaussian() * (double)0.13f, this.field_70161_v + this.field_70146_Z.nextGaussian() * 0.4, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
        super.func_70071_h_();
    }

    @Override
    public double func_70042_X() {
        return 0.0;
    }

    @Override
    protected boolean onInteractWithPlayerItem(ItemStack stack, EntityPlayer player, EnumHand hand) {
        if (stack.func_77973_b() == Items.field_151100_aR) {
            this.setModelType(-(stack.func_77960_j() - 15));
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return true;
        }
        if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150360_v) && stack.func_77960_j() == 1) {
            this.setModelType(12);
            return true;
        }
        if (Helper.isDateAroundHalloween()) {
            if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150423_aK)) {
                this.setHeadType(1);
                return true;
            }
            if (stack.func_77973_b() == Items.field_151144_bL && stack.func_77960_j() == 0) {
                this.setHeadType(2);
                return true;
            }
        }
        return false;
    }

    @Override
    protected DataParameter<Integer> getDataEnergy() {
        return ENERGY;
    }

    @Override
    public DataParameter<Float> getDataDamageTaken() {
        return DAMAGE_TAKEN;
    }

    @Override
    protected DataParameter<Integer> getDataTimeSinceHit() {
        return TIME_SINCE_HIT;
    }

    @Override
    protected DataParameter<Integer> getDataForwardDirection() {
        return FORWARD_DIRECTION;
    }

    @Override
    protected DataParameter<Integer> getDataModelType() {
        return MODEL_TYPE;
    }

    public int getHeadType() {
        return (Integer)this.field_70180_af.func_187225_a(HEAD_TYPE);
    }

    public void setHeadType(int headType) {
        this.field_70180_af.func_187227_b(HEAD_TYPE, (Object)headType);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HEAD_TYPE, (Object)0);
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("head_type", this.getHeadType());
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_150297_b("head_type", 3)) {
            this.setHeadType(tag.func_74762_e("head_type"));
        }
    }
}

