/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.flying_things.event;

import java.util.Arrays;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.items.ItemHandlerHelper;
import ovh.corail.flying_things.ConfigFlyingThings;
import ovh.corail.flying_things.entity.EntityAbstractFlyingThing;
import ovh.corail.flying_things.helper.Helper;
import ovh.corail.flying_things.registry.ModItems;

@Mod.EventBusSubscriber(modid="flying_things")
public class EventHandler {
    private static ResourceLocation LOOTTABLE_SPECIAL = new ResourceLocation("flying_things", "special");

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLootTableLoad(LootTableLoadEvent event) {
        if (Arrays.stream(ConfigFlyingThings.general.treasureLootTable).anyMatch(p -> event.getName().toString().equals(p))) {
            event.getTable().addPool(event.getLootTableManager().func_186521_a(LOOTTABLE_SPECIAL).getPool("flying_things:chest_treasure"));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBossDrops(LivingDropsEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (Helper.isBoss((Entity)entity)) {
            if (Helper.getRandom(1, 100) <= 10) {
                event.getDrops().add(new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack((Item)ModItems.phialOfAnimation)));
            }
        } else if (entity instanceof EntityMob && Helper.isDateAroundHalloween() && event.getSource() != null && event.getSource().func_76346_g() instanceof EntityPlayer && Helper.getRandom(1, 100) <= ConfigFlyingThings.general.chanceDropPumpkinStick) {
            event.getDrops().add(new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack((Item)ModItems.pumpkinStick)));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingFall(LivingFallEvent event) {
        if (Helper.isRidingFlyingThing((Entity)event.getEntityLiving())) {
            event.setDistance(0.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingInWall(LivingDamageEvent event) {
        if (event.getSource() == DamageSource.field_76368_d && Helper.isRidingFlyingThing((Entity)event.getEntityLiving())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onProjectileImpact(ProjectileImpactEvent event) {
        if (event.getRayTraceResult() == null || event.getRayTraceResult().field_72308_g == null) {
            return;
        }
        Entity rider = event.getRayTraceResult().field_72308_g;
        if (ConfigFlyingThings.general.chanceToFallWithProjectile != 0 && Helper.isRidingFlyingThing(rider) && Helper.getRandom(1, 100) < ConfigFlyingThings.general.chanceToFallWithProjectile) {
            rider.func_184210_p();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingDeath(LivingDeathEvent event) {
        EntityAbstractFlyingThing flying_thing;
        if (Helper.isControllingFlyingThing((Entity)event.getEntityLiving()) && (flying_thing = (EntityAbstractFlyingThing)event.getEntityLiving().func_184187_bx()) != null) {
            if (Helper.isValidPlayer((Entity)event.getEntityLiving()) && flying_thing.hasSoulbound()) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)((EntityPlayer)event.getEntityLiving()), (ItemStack)flying_thing.getStack());
            } else {
                event.getEntityLiving().func_70099_a(flying_thing.getStack(), 0.0f);
            }
            flying_thing.func_70106_y();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (Helper.isValidPlayerMP((Entity)event.player) && Helper.isControllingFlyingThing((Entity)event.player)) {
            EntityAbstractFlyingThing mount = (EntityAbstractFlyingThing)event.player.func_184187_bx();
            event.player.func_184210_p();
            if (mount != null) {
                event.player.field_70170_p.func_72964_e(mount.field_70176_ah, mount.field_70164_aj).func_76630_e();
            }
        }
    }
}

