/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.flying_things.item;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import ovh.corail.flying_things.ConfigFlyingThings;
import ovh.corail.flying_things.entity.EntityAbstractFlyingThing;
import ovh.corail.flying_things.helper.NBTStackHelper;
import ovh.corail.flying_things.item.ItemGeneric;

public abstract class ItemAbstractFlyingThing
extends ItemGeneric {
    private final ResourceLocation soulboundLoc = new ResourceLocation("tombstone", "soulbound");

    abstract Class<? extends EntityAbstractFlyingThing> getEntityClass();

    abstract boolean canFlyInDimension(int var1);

    abstract void onEntitySpawn(ItemStack var1, EntityAbstractFlyingThing var2);

    ItemAbstractFlyingThing(String name) {
        super(name);
        this.func_77625_d(1);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_184218_aH() || player.func_184811_cZ().func_185141_a((Item)this)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
        }
        if (stack.func_77973_b() != this) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        if (!world.field_72995_K) {
            EntityAbstractFlyingThing entity;
            MinecraftServer server = player.field_70170_p.func_73046_m();
            if (server != null && !server.func_71231_X()) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("flying_things.message.flight_not_allowed", new Object[0]));
                return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
            }
            if (!this.canFlyInDimension(world.field_73011_w.getDimension())) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("flying_things.message.denied_dimension_to_fly", new Object[]{stack.func_82833_r()}));
                return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
            }
            player.func_184811_cZ().func_185145_a((Item)this, 100);
            ResourceLocation entityRL = EntityList.func_191306_a(this.getEntityClass());
            if (entityRL != null && (entity = (EntityAbstractFlyingThing)EntityList.func_188429_b((ResourceLocation)entityRL, (World)world)) != null) {
                entity.setModelType(player.func_184586_b(hand).func_77960_j());
                entity.setEnergy(this.getEnergy(stack));
                entity.setSoulbound(this.hasSoulbound(stack));
                if (stack.func_82837_s()) {
                    entity.func_96094_a(stack.func_82833_r());
                }
                entity.func_70080_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, 0.0f);
                entity.func_70034_d(player.field_70177_z);
                this.onEntitySpawn(stack, entity);
                world.func_72838_d((Entity)entity);
                if (!player.func_70093_af()) {
                    player.func_184220_m((Entity)entity);
                }
                player.func_184611_a(hand, ItemStack.field_190927_a);
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getEnergy(stack) < ConfigFlyingThings.General.getMaxEnergy();
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return MathHelper.func_181758_c((float)(Math.max(0.0f, (float)(1.0 - this.getDurabilityForDisplay(stack))) / 1.5f), (float)1.0f, (float)1.0f);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getEnergy(stack) / (double)ConfigFlyingThings.General.getMaxEnergy();
    }

    public void setEnergy(ItemStack stack, int energy) {
        if (stack.func_77973_b() == this) {
            NBTStackHelper.setInteger(stack, "energy", MathHelper.func_76125_a((int)energy, (int)0, (int)ConfigFlyingThings.General.getMaxEnergy()));
        }
    }

    private int getEnergy(ItemStack stack) {
        if (stack.func_77973_b() == this) {
            if (NBTStackHelper.hasKeyName(stack, "energy")) {
                return MathHelper.func_76125_a((int)NBTStackHelper.getInteger(stack, "energy"), (int)0, (int)ConfigFlyingThings.General.getMaxEnergy());
            }
            this.setEnergy(stack, ConfigFlyingThings.General.getMaxEnergy());
            return ConfigFlyingThings.General.getMaxEnergy();
        }
        return 0;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isSelected) {
        if (!world.field_72995_K && this.getEnergy(stack) < ConfigFlyingThings.General.getMaxEnergy() && entity.field_70173_aa % (ConfigFlyingThings.general.timeToRecoverEnergy * 20) == 0) {
            this.setEnergy(stack, this.getEnergy(stack) + this.getActualRegen(stack, world, entity, slot, isSelected));
        }
    }

    public int getActualRegen(ItemStack stack, World world, Entity entity, int slot, boolean isSelected) {
        return 1;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.func_77973_b() != newStack.func_77973_b() || oldStack.func_77960_j() != newStack.func_77960_j();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == null) {
            return false;
        }
        assert (enchantment.getRegistryName() != null);
        return ConfigFlyingThings.General.isSoulboundAllowed() && stack.func_77986_q().func_74745_c() == 0 && enchantment.getRegistryName().equals((Object)this.soulboundLoc);
    }

    public int func_77619_b() {
        return 1;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return ConfigFlyingThings.General.isSoulboundAllowed() && stack.func_77986_q().func_74745_c() == 0 && ItemEnchantedBook.func_92110_g((ItemStack)book).func_74745_c() == 1 && this.hasSoulbound(book);
    }

    public void setSoulbound(ItemStack stack) {
        if (!ConfigFlyingThings.General.isSoulboundAllowed()) {
            return;
        }
        Enchantment soulbound = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(this.soulboundLoc);
        if (soulbound == null) {
            return;
        }
        stack.func_77966_a(soulbound, 1);
    }

    private boolean hasSoulbound(ItemStack stack) {
        if (!ConfigFlyingThings.General.isSoulboundAllowed()) {
            return false;
        }
        Enchantment soulbound = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(this.soulboundLoc);
        if (soulbound == null) {
            return false;
        }
        for (Enchantment enchant : EnchantmentHelper.func_82781_a((ItemStack)stack).keySet()) {
            if (!this.soulboundLoc.equals((Object)enchant.getRegistryName())) continue;
            return true;
        }
        return false;
    }
}

