/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.flying_things.item;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.flying_things.ConfigFlyingThings;
import ovh.corail.flying_things.entity.EntityAbstractFlyingThing;
import ovh.corail.flying_things.entity.EntityMagicCarpet;
import ovh.corail.flying_things.item.ICustomModel;
import ovh.corail.flying_things.item.ItemAbstractFlyingThing;
import ovh.corail.flying_things.render.TEISRMagicCarpet;

public class ItemMagicCarpet
extends ItemAbstractFlyingThing
implements ICustomModel {
    private int CARPET_COUNT = 14;

    public ItemMagicCarpet() {
        super("magic_carpet");
        this.func_77627_a(true);
    }

    @Override
    Class<? extends EntityAbstractFlyingThing> getEntityClass() {
        return EntityMagicCarpet.class;
    }

    @Override
    public boolean canFlyInDimension(int dimId) {
        return Arrays.stream(ConfigFlyingThings.deniedDimensionToFly.deniedDimensionCarpet).noneMatch(p -> p == dimId);
    }

    @Override
    void onEntitySpawn(ItemStack stack, EntityAbstractFlyingThing entity) {
    }

    @Override
    public int getActualRegen(ItemStack stack, World world, Entity entity, int slot, boolean isSelected) {
        boolean hasSpecialRegen = ConfigFlyingThings.general.allowSpecialRegen && world.func_175667_e(entity.func_180425_c().func_177977_b()) && world.func_180495_p(entity.func_180425_c().func_177977_b()).func_177230_c() == Blocks.field_150425_aM;
        return hasSpecialRegen ? 20 : 1;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i < this.CARPET_COUNT; ++i) {
                ItemStack itemStack = new ItemStack((Item)this, 1, i);
                items.add((Object)itemStack);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        if (!GuiScreen.func_146272_n()) {
            list.add(I18n.func_74837_a((String)"flying_things.message.hold_key", (Object[])new Object[]{"SHIFT"}) + " " + I18n.func_74838_a((String)"flying_things.message.for_more_infos"));
        } else {
            list.add(I18n.func_74837_a((String)"flying_things.item.magic_carpet.desc1", (Object[])new Object[0]));
            list.add(I18n.func_74837_a((String)"flying_things.item.magic_carpet.desc2", (Object[])new Object[]{Minecraft.func_71410_x().field_71474_y.field_74311_E.getDisplayName()}));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        this.setTileEntityItemStackRenderer(new TEISRMagicCarpet());
        assert (this.getRegistryName() != null);
        for (int i = 0; i < this.CARPET_COUNT; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)i, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        }
    }

    public String func_77653_i(ItemStack stack) {
        return I18n.func_74838_a((String)(this.func_77657_g(stack) + (stack.func_77960_j() < 9 || stack.func_77960_j() > 13 ? ".name" : ".halloween"))).trim();
    }
}

