/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.flying_things.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.flying_things.ConfigFlyingThings;
import ovh.corail.flying_things.entity.EntityMagicCarpet;
import ovh.corail.flying_things.helper.TextureLocation;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="flying_things")
@SideOnly(value=Side.CLIENT)
public final class RenderMagicCarpet<T extends EntityMagicCarpet>
extends Render<T> {
    private static final float TOP_MIN_U = 0.0f;
    private static final float TOP_MIN_V = 0.0f;
    private static final float TOP_MAX_U = 1.0f;
    private static final float TOP_MAX_V = 1.0f;
    private static final float BOTTOM_MIN_U = 0.0f;
    private static final float BOTTOM_MIN_V = 0.0f;
    private static final float BOTTOM_MAX_U = 1.0f;
    private static final float BOTTOM_MAX_V = 1.0f;
    private static final int FACE_COUNT = 16;
    private static final int VERTEX_COUNT = 17;
    private static final double WIDTH = 1.4;
    private static final double LENGTH = 2.0999999999999996;
    private static final double X1 = 0.7;
    private static final double X0 = -0.7;
    private static final double[] VERT_Y = new double[17];
    private static final double[] VERT_Z = new double[17];

    public RenderMagicCarpet(RenderManager manager) {
        super(manager);
        this.field_76987_f = 0.2f;
        this.field_76989_e = 0.2f;
    }

    public void doRender(T entity, double x, double y, double z, float yaw, float partialTicks) {
        RenderMagicCarpet.render(this.field_76990_c, entity, x, y, z, yaw, ((EntityMagicCarpet)((Object)entity)).field_70173_aa, partialTicks, false);
        super.func_76986_a(entity, x, y, z, yaw, partialTicks);
    }

    public ResourceLocation getEntityTexture(T entity) {
        return RenderMagicCarpet.getTexture(entity);
    }

    private static ResourceLocation getTexture(EntityMagicCarpet entity) {
        return TextureLocation.TEXTURE_CARPET[entity.getModelType() < TextureLocation.TEXTURE_CARPET.length ? entity.getModelType() : 0];
    }

    public static void render(RenderManager renderManager, EntityMagicCarpet entity, double x, double y, double z, float yaw, int ticksExisted, float partialTicks, boolean useMask) {
        float ageInTicks = (float)ticksExisted + partialTicks;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y - 0.7f), (float)((float)z));
        GlStateManager.func_179114_b((float)(180.0f - yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        if (entity.field_70170_p != null) {
            float f = (float)entity.getTimeSinceHit() - partialTicks;
            float f1 = entity.getDamageTaken() - partialTicks;
            if (f1 < 0.0f) {
                f1 = 0.0f;
            }
            if (f > 0.0f) {
                GlStateManager.func_179114_b((float)(MathHelper.func_76126_a((float)f) * f * f1 / 10.0f * (float)entity.getForwardDirection()), (float)1.0f, (float)0.0f, (float)0.0f);
            }
        }
        GlStateManager.func_179089_o();
        renderManager.field_78724_e.func_110577_a(RenderMagicCarpet.getTexture(entity));
        for (int i = 0; i < 17; ++i) {
            RenderMagicCarpet.VERT_Y[i] = (double)MathHelper.func_76126_a((float)(ageInTicks * 0.1f + (float)i * 0.25f)) * 0.065 + 0.95;
            RenderMagicCarpet.VERT_Z[i] = (double)i / 16.0 * 2.0999999999999996 - 1.0499999999999998;
        }
        RenderMagicCarpet.drawCarpet();
        RenderMagicCarpet.renderLayer(renderManager, entity, ticksExisted, partialTicks);
        GlStateManager.func_179129_p();
        GlStateManager.func_179147_l();
        GlStateManager.func_179121_F();
    }

    private static void renderLayer(RenderManager renderManager, EntityMagicCarpet carpet, int ticksExisted, float partialTicks) {
        if (!ConfigFlyingThings.client.renderEffect) {
            return;
        }
        float ageInTicks = (float)ticksExisted + partialTicks;
        GlStateManager.func_179094_E();
        boolean flag = !carpet.func_82150_aj();
        GlStateManager.func_179132_a((!flag ? 1 : 0) != 0);
        renderManager.field_78724_e.func_110577_a(TextureLocation.TEXTURE_EFFECT);
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179096_D();
        GlStateManager.func_179109_b((float)(ageInTicks * 0.01f), (float)(ageInTicks * 0.01f), (float)0.0f);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)0.2f, (float)0.2f, (float)0.2f, (float)0.2f);
        GlStateManager.func_179140_f();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        Minecraft.func_71410_x().field_71460_t.func_191514_d(true);
        RenderMagicCarpet.drawCarpet();
        Minecraft.func_71410_x().field_71460_t.func_191514_d(false);
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179096_D();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)flag);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179121_F();
    }

    private static void drawCarpet() {
        BufferBuilder buf = Tessellator.func_178181_a().func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181710_j);
        for (int i = 0; i < 16; ++i) {
            float t0 = (float)i / 16.0f;
            float t1 = (float)(i + 1) / 16.0f;
            double y0 = VERT_Y[i];
            double y1 = VERT_Y[i + 1];
            double z0 = VERT_Z[i];
            double z1 = VERT_Z[i + 1];
            float v00 = 0.0f + 1.0f * t0;
            float v01 = 0.0f + 1.0f * t1;
            buf.func_181662_b(-0.7, y0, z0).func_187315_a(0.0, (double)v00).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            buf.func_181662_b(-0.7, y1, z1).func_187315_a(0.0, (double)v01).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            buf.func_181662_b(0.7, y1, z1).func_187315_a(1.0, (double)v01).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            buf.func_181662_b(0.7, y0, z0).func_187315_a(1.0, (double)v00).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            float v10 = 0.0f + 1.0f * t0;
            float v11 = 0.0f + 1.0f * t1;
            buf.func_181662_b(-0.7, y1, z1).func_187315_a(0.0, (double)v11).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
            buf.func_181662_b(-0.7, y0, z0).func_187315_a(0.0, (double)v10).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
            buf.func_181662_b(0.7, y0, z0).func_187315_a(1.0, (double)v10).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
            buf.func_181662_b(0.7, y1, z1).func_187315_a(1.0, (double)v11).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        }
        Tessellator.func_178181_a().func_78381_a();
    }
}

