/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.flying_things.entity;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;
import ovh.corail.flying_things.ConfigFlyingThings;
import ovh.corail.flying_things.helper.Helper;

public abstract class EntityAbstractFlyingThing
extends Entity {
    private boolean hasSoulbound = false;
    private boolean wasOnGround = false;
    private double speedFactor = 0.01;
    public double speed;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYaw;
    private double lerpPitch;
    private int lerpSteps;
    @OnlyIn(value=Dist.CLIENT)
    private double velocityX;
    @OnlyIn(value=Dist.CLIENT)
    private double velocityY;
    @OnlyIn(value=Dist.CLIENT)
    private double velocityZ;

    public EntityAbstractFlyingThing(EntityType<?> entityType, World world) {
        super(entityType, world);
        this.field_70156_m = true;
    }

    public EntityAbstractFlyingThing(EntityType<?> entityType, World world, double x, double y, double z) {
        this(entityType, world);
        this.func_70107_b(x, y, z);
        this.field_70179_y = 0.0;
        this.field_70181_x = 0.0;
        this.field_70159_w = 0.0;
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    protected abstract DataParameter<Integer> getDataEnergy();

    protected abstract DataParameter<Float> getDataDamageTaken();

    protected abstract DataParameter<Integer> getDataTimeSinceHit();

    protected abstract DataParameter<Integer> getDataForwardDirection();

    protected abstract DataParameter<Integer> getDataModelType();

    public abstract ItemStack getStack();

    public abstract boolean canFlyInDimension(DimensionType var1);

    protected abstract boolean onInteractWithPlayerItem(ItemStack var1, EntityPlayer var2, EnumHand var3);

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(this.getDataTimeSinceHit(), (Object)0);
        this.field_70180_af.func_187214_a(this.getDataForwardDirection(), (Object)1);
        this.field_70180_af.func_187214_a(this.getDataEnergy(), (Object)ConfigFlyingThings.General.getMaxEnergy());
        this.field_70180_af.func_187214_a(this.getDataDamageTaken(), (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(this.getDataModelType(), (Object)0);
    }

    public void func_70014_b(NBTTagCompound tag) {
        tag.func_74768_a("model_type", this.getModelType());
        tag.func_74768_a("energy", this.getEnergy());
        tag.func_74776_a("damage_taken", this.getDamageTaken());
        tag.func_74757_a("soulbound", this.hasSoulbound);
    }

    public void func_70037_a(NBTTagCompound tag) {
        if (tag.func_150297_b("model_type", 3)) {
            this.setModelType(tag.func_74762_e("model_type"));
        }
        if (tag.func_150297_b("energy", 3)) {
            this.setEnergy(tag.func_74762_e("energy"));
        }
        if (tag.func_150297_b("damage_taken", 5)) {
            this.setDamageTaken(tag.func_74760_g("damage_taken"));
        }
        if (tag.func_150297_b("soulbound", 1)) {
            this.setSoulbound(tag.func_74767_n("soulbound"));
        }
    }

    public boolean hasSoulbound() {
        return this.hasSoulbound;
    }

    public void setSoulbound(boolean flag) {
        this.hasSoulbound = flag;
    }

    public void setEnergy(int energy) {
        this.field_70180_af.func_187227_b(this.getDataEnergy(), (Object)MathHelper.func_76125_a((int)energy, (int)0, (int)ConfigFlyingThings.General.getMaxEnergy()));
    }

    public int getEnergy() {
        return MathHelper.func_76125_a((int)((Integer)this.field_70180_af.func_187225_a(this.getDataEnergy())), (int)0, (int)ConfigFlyingThings.General.getMaxEnergy());
    }

    public void setDamageTaken(float damage) {
        this.field_70180_af.func_187227_b(this.getDataDamageTaken(), (Object)Float.valueOf(damage));
    }

    public float getDamageTaken() {
        return ((Float)this.field_70180_af.func_187225_a(this.getDataDamageTaken())).floatValue();
    }

    public void setTimeSinceHit(int time) {
        this.field_70180_af.func_187227_b(this.getDataTimeSinceHit(), (Object)time);
    }

    public int getTimeSinceHit() {
        return (Integer)this.field_70180_af.func_187225_a(this.getDataTimeSinceHit());
    }

    public void setForwardDirection(int direction) {
        this.field_70180_af.func_187227_b(this.getDataForwardDirection(), (Object)direction);
    }

    public int getForwardDirection() {
        return (Integer)this.field_70180_af.func_187225_a(this.getDataForwardDirection());
    }

    public void setModelType(int modelType) {
        if (modelType >= 0) {
            this.field_70180_af.func_187227_b(this.getDataModelType(), (Object)modelType);
        }
    }

    public int getModelType() {
        return (Integer)this.field_70180_af.func_187225_a(this.getDataModelType());
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && !this.func_184207_aI() && !player.func_70093_af() && this.onInteractWithPlayerItem(stack, player, hand)) {
            return true;
        }
        if (player.func_70093_af()) {
            this.func_184174_b(false);
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)this.getStack());
            this.func_70106_y();
            return true;
        }
        assert (player.field_70170_p.func_73046_m() != null);
        if (player.field_70170_p.func_73046_m().func_71231_X()) {
            if (this.canFlyInDimension(this.field_70170_p.field_73011_w.func_186058_p())) {
                return player.func_184220_m((Entity)this);
            }
            player.func_145747_a((ITextComponent)new TextComponentTranslation("flying_things.message.denied_dimension_to_fly", new Object[]{this.func_145748_c_()}));
            return false;
        }
        if (hand == EnumHand.MAIN_HAND) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("flying_things.message.flight_not_allowed", new Object[0]));
            return false;
        }
        return false;
    }

    public boolean canBeRiddenInWater(Entity rider) {
        return (Boolean)ConfigFlyingThings.general.allowToFlyInWater.get();
    }

    protected void func_184225_p(Entity passenger) {
        boolean valid = !this.field_70170_p.field_72995_K && passenger instanceof EntityPlayer && this.func_184179_bs() == passenger && passenger.func_184187_bx() != this;
        super.func_184225_p(passenger);
        if (valid && this.func_70089_S()) {
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)((EntityPlayer)passenger), (ItemStack)this.getStack());
            this.func_70106_y();
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_184179_bs() != null) {
                if (this.getEnergy() > 0 && this.field_70173_aa % ((Integer)ConfigFlyingThings.general.timeToLoseEnergy.get() * 20) == 0) {
                    this.setEnergy(this.getEnergy() - 1);
                }
            } else if (this.getEnergy() < ConfigFlyingThings.General.getMaxEnergy() && this.field_70173_aa % ((Integer)ConfigFlyingThings.general.timeToRecoverEnergy.get() * 20) == 0) {
                this.setEnergy(this.getEnergy() + 1);
            }
        }
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        double initialSpeed = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y);
        if (this.field_70170_p.field_72995_K && !this.func_184207_aI()) {
            if (this.lerpSteps > 0) {
                double newPosX = this.field_70165_t + (this.lerpX - this.field_70165_t) / (double)this.lerpSteps;
                double newPosY = this.field_70163_u + (this.lerpY - this.field_70163_u) / (double)this.lerpSteps;
                double newPosZ = this.field_70161_v + (this.lerpZ - this.field_70161_v) / (double)this.lerpSteps;
                double d10 = MathHelper.func_76138_g((double)(this.lerpYaw - (double)this.field_70177_z));
                this.field_70177_z = (float)((double)this.field_70177_z + d10 / (double)this.lerpSteps);
                this.field_70125_A = (float)((double)this.field_70125_A + (this.lerpPitch - (double)this.field_70125_A) / (double)this.lerpSteps);
                --this.lerpSteps;
                this.func_70080_a(newPosX, newPosY, newPosZ, this.field_70177_z, this.field_70125_A);
            } else {
                double newPosX = this.field_70165_t + this.field_70159_w;
                double newPosY = this.field_70163_u + this.field_70181_x;
                double newPosZ = this.field_70161_v + this.field_70179_y;
                this.func_70107_b(newPosX, newPosY, newPosZ);
                this.func_70101_b((float)((double)this.field_70177_z + (this.lerpYaw - (double)this.field_70177_z)), (float)((double)this.field_70125_A + (this.lerpPitch - (double)this.field_70125_A)));
                this.field_70159_w *= (double)0.99f;
                this.field_70179_y *= (double)0.99f;
            }
        } else {
            List list;
            double accelerationIncrement = (double)ConfigFlyingThings.General.getAccelerationIncrement() / 100.0;
            if (this.func_184179_bs() instanceof EntityLivingBase) {
                if ((double)((EntityLivingBase)this.func_184179_bs()).field_191988_bg < 0.0) {
                    this.field_70159_w *= 1.0 - accelerationIncrement;
                    this.field_70179_y *= 1.0 - accelerationIncrement;
                } else if ((double)((EntityLivingBase)this.func_184179_bs()).field_191988_bg > 0.0) {
                    double dirX = -Math.sin((double)this.func_184179_bs().field_70177_z * Math.PI / 180.0);
                    double dirZ = Math.cos((double)this.func_184179_bs().field_70177_z * Math.PI / 180.0);
                    double dirY = -Math.sin((double)this.func_184179_bs().field_70125_A * Math.PI / 180.0);
                    double d = dirY > -0.5 && dirY < 0.2 ? 0.0 : 0.5;
                    this.field_70159_w += dirX * this.speedFactor * 0.1;
                    this.field_70179_y += dirZ * this.speedFactor * 0.1;
                    this.field_70181_x = (dirY *= d) * this.speedFactor * 2.0;
                }
            } else if (!this.func_184207_aI()) {
                double moX = this.field_70159_w * 0.9;
                double moZ = this.field_70179_y * 0.9;
                this.field_70159_w = Math.abs(moX) < 0.01 ? 0.0 : moX;
                double d = this.field_70179_y = Math.abs(moZ) < 0.01 ? 0.0 : moZ;
                if (!this.field_70122_E) {
                    this.field_70181_x = -0.2;
                }
            }
            this.speed = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y);
            double speedMax = (double)(this.getEnergy() > 0 ? ConfigFlyingThings.General.getSpeedMax() : ConfigFlyingThings.General.getSpeedMaxNoEnergy()) / 100.0;
            if (this.speed > speedMax) {
                double reducedMotion = speedMax / this.speed;
                this.field_70159_w *= reducedMotion;
                this.field_70179_y *= reducedMotion;
                this.field_70181_x *= reducedMotion;
                this.speed = speedMax;
            }
            double accelerationMax = (double)ConfigFlyingThings.General.getAccelerationMax() / 100.0;
            if (this.speed > initialSpeed && this.speedFactor < accelerationMax) {
                this.speedFactor += (accelerationMax - this.speedFactor) / (double)ConfigFlyingThings.General.getAccelerationMax();
                if (this.speedFactor > accelerationMax) {
                    this.speedFactor = accelerationMax;
                }
            } else if (this.speed < initialSpeed) {
                this.speedFactor -= (this.speedFactor - accelerationIncrement) / (double)ConfigFlyingThings.General.getAccelerationMax();
                if (this.speedFactor < accelerationIncrement) {
                    this.speedFactor = accelerationIncrement;
                }
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            double reducedMotion = !this.wasOnGround && this.field_70122_E ? 0.5 : (double)0.99f;
            this.wasOnGround = this.field_70122_E;
            this.field_70159_w *= reducedMotion;
            this.field_70181_x *= reducedMotion;
            this.field_70179_y *= reducedMotion;
            this.field_70125_A = 0.0f;
            double rotYaw = this.field_70177_z;
            double x = this.field_70169_q - this.field_70165_t;
            double z = this.field_70166_s - this.field_70161_v;
            if (x * x + z * z > 0.001) {
                rotYaw = (float)(Math.atan2(z, x) * 180.0 / Math.PI) + 90.0f;
            }
            double adjust = MathHelper.func_76138_g((double)(rotYaw - (double)this.field_70177_z));
            this.field_70177_z += (float)adjust;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            if (!this.field_70170_p.field_72995_K && !(list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b((double)0.2f, (double)-0.01f, (double)0.2f), p -> !p.func_184191_r((Entity)this))).isEmpty()) {
                for (Entity entity : list) {
                    if (entity.func_184196_w((Entity)this)) continue;
                    if (this.func_184219_q(entity) && !entity.func_184218_aH() && entity.field_70130_N < this.field_70130_N && entity instanceof EntityLivingBase && !(entity instanceof EntityPlayer)) {
                        entity.func_184220_m((Entity)this);
                        continue;
                    }
                    if (!entity.func_70104_M()) continue;
                    this.func_70108_f(entity);
                }
            }
        }
    }

    protected void func_145775_I() {
        AxisAlignedBB bounds = this.func_174813_aQ();
        BlockPos.PooledMutableBlockPos pos0 = BlockPos.PooledMutableBlockPos.func_185345_c((double)(bounds.field_72340_a + 0.001), (double)(bounds.field_72338_b + 0.001), (double)(bounds.field_72339_c + 0.001));
        BlockPos.PooledMutableBlockPos pos1 = BlockPos.PooledMutableBlockPos.func_185345_c((double)(bounds.field_72336_d - 0.001), (double)(bounds.field_72337_e - 0.001), (double)(bounds.field_72334_f - 0.001));
        BlockPos.PooledMutableBlockPos pos2 = BlockPos.PooledMutableBlockPos.func_185346_s();
        if (this.field_70170_p.func_175707_a((BlockPos)pos0, (BlockPos)pos1)) {
            for (int i = pos0.func_177958_n(); i <= pos1.func_177958_n(); ++i) {
                for (int j = pos0.func_177956_o(); j <= pos1.func_177956_o(); ++j) {
                    for (int k = pos0.func_177952_p(); k <= pos1.func_177952_p(); ++k) {
                        pos2.func_181079_c(i, j, k);
                        IBlockState state = this.field_70170_p.func_180495_p((BlockPos)pos2);
                        try {
                            if (state.func_177230_c() != Blocks.field_150425_aM) {
                                if (((Boolean)ConfigFlyingThings.general.allowToBreakPlant.get()).booleanValue() && !this.field_70170_p.field_72995_K && this.speed > 0.4 && !state.func_185904_a().func_76224_d() && (state.func_185904_a().func_76222_j() || state.func_185904_a() == Material.field_151585_k)) {
                                    state.func_177230_c().func_196255_a(state, this.field_70170_p, (BlockPos)pos2, 0.0f, 0);
                                    this.field_70170_p.func_175656_a((BlockPos)pos2, Blocks.field_150350_a.func_176223_P());
                                }
                                state.func_177230_c().func_196262_a(state, this.field_70170_p, (BlockPos)pos2, (Entity)this);
                            }
                            this.func_191955_a(state);
                            continue;
                        }
                        catch (Throwable throwable) {
                            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Colliding entity with block");
                            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block being collided with");
                            CrashReportCategory.func_175750_a((CrashReportCategory)crashreportcategory, (BlockPos)pos2, (IBlockState)state);
                            throw new ReportedException(crashreport);
                        }
                    }
                }
            }
        }
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.canFlyInDimension(this.field_70170_p.field_73011_w.func_186058_p()) && super.func_184219_q(passenger) && passenger instanceof EntityPlayer;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70057_ab() {
        this.setForwardDirection(-this.getForwardDirection());
        this.setTimeSinceHit(10);
        this.setDamageTaken(this.getDamageTaken() * 11.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.velocityX = this.field_70159_w = x;
        this.velocityY = this.field_70181_x = y;
        this.velocityZ = this.field_70179_y = z;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYaw = yaw;
        this.lerpPitch = pitch;
        this.field_70159_w = this.velocityX;
        this.field_70181_x = this.velocityY;
        this.field_70179_y = this.velocityZ;
        if (!this.func_184207_aI()) {
            this.lerpSteps = posRotationIncrements + 5;
        } else {
            double d3 = x - this.field_70165_t;
            double d4 = y - this.field_70163_u;
            double d5 = z - this.field_70161_v;
            double d6 = d3 * d3 + d4 * d4 + d5 * d5;
            if (d6 <= 1.0) {
                return;
            }
            this.lerpSteps = 3;
        }
    }

    protected void func_70081_e(int amount) {
    }

    protected boolean func_70041_e_() {
        return false;
    }

    @Nullable
    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    public boolean func_70067_L() {
        return this.func_70089_S() && !this.func_184207_aI();
    }

    public void func_70108_f(Entity entity) {
        if (entity instanceof EntityAbstractFlyingThing) {
            if (entity.func_174813_aQ().field_72338_b < this.func_174813_aQ().field_72337_e) {
                super.func_70108_f(entity);
            }
        } else if (entity.func_174813_aQ().field_72338_b <= this.func_174813_aQ().field_72338_b) {
            super.func_70108_f(entity);
        }
    }

    public boolean func_70104_M() {
        return true;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.5;
    }

    public double func_70033_W() {
        return 0.0;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            boolean creativeDamage;
            if (source instanceof EntityDamageSourceIndirect && source.func_76346_g() != null && this.func_184196_w(source.func_76346_g())) {
                return false;
            }
            this.setForwardDirection(-this.getForwardDirection());
            this.setTimeSinceHit(10);
            this.setDamageTaken(this.getDamageTaken() + amount * 10.0f);
            this.func_70018_K();
            boolean bl = creativeDamage = source.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)source.func_76346_g()).field_71075_bZ.field_75098_d;
            if (creativeDamage || this.getDamageTaken() > 40.0f) {
                if (Helper.isValidPlayer(this.func_184179_bs())) {
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)((EntityPlayer)this.func_184179_bs()), (ItemStack)this.getStack());
                } else {
                    this.func_70099_a(this.getStack(), 0.0f);
                }
                this.func_70106_y();
            }
        }
        return true;
    }

    protected void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
        if (this.func_184186_bw() && this.lerpSteps > 0) {
            this.lerpSteps = 0;
            this.field_70165_t = this.lerpX;
            this.field_70163_u = this.lerpY;
            this.field_70161_v = this.lerpZ;
            this.field_70177_z = (float)this.lerpYaw;
            this.field_70125_A = (float)this.lerpPitch;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_184190_l(Entity entityToUpdate) {
        float f = MathHelper.func_76142_g((float)(entityToUpdate.field_70177_z - this.field_70177_z));
        float f1 = MathHelper.func_76131_a((float)f, (float)-105.0f, (float)105.0f);
        entityToUpdate.field_70126_B += f1 - f;
        entityToUpdate.field_70177_z += f1 - f;
        entityToUpdate.func_181013_g(this.field_70177_z);
    }

    public ITextComponent func_200200_C_() {
        Entity owner;
        if (!this.field_70170_p.field_72995_K && (owner = this.func_184179_bs()) != null) {
            return owner.func_200200_C_();
        }
        return super.func_200200_C_();
    }
}

