/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.flying_things.entity;

import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import ovh.corail.flying_things.ConfigFlyingThings;
import ovh.corail.flying_things.entity.EntityAbstractFlyingThing;
import ovh.corail.flying_things.helper.Helper;
import ovh.corail.flying_things.item.ItemAbstractFlyingThing;
import ovh.corail.flying_things.registry.ModEntities;
import ovh.corail.flying_things.registry.ModItems;

public class EntityMagicCarpet
extends EntityAbstractFlyingThing {
    private static final DataParameter<Integer> ENERGY = EntityDataManager.func_187226_a(EntityMagicCarpet.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TIME_SINCE_HIT = EntityDataManager.func_187226_a(EntityMagicCarpet.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> DAMAGE_TAKEN = EntityDataManager.func_187226_a(EntityMagicCarpet.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> FORWARD_DIRECTION = EntityDataManager.func_187226_a(EntityMagicCarpet.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> MODEL_TYPE = EntityDataManager.func_187226_a(EntityMagicCarpet.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityMagicCarpet(World world) {
        super(ModEntities.TYPE_CARPET, world);
        this.func_70105_a(1.5f, 0.3f);
    }

    public EntityMagicCarpet(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y, z);
    }

    @Override
    public ItemStack getStack() {
        ItemStack stack = new ItemStack((IItemProvider)ModItems.magicCarpet);
        ItemAbstractFlyingThing.setModelType(stack, this.getModelType());
        if (this.func_145818_k_()) {
            stack.func_200302_a(this.func_200201_e());
        }
        ItemAbstractFlyingThing.setEnergy(stack, this.getEnergy());
        if (this.hasSoulbound()) {
            ItemAbstractFlyingThing.setSoulbound(stack);
        }
        return stack;
    }

    @Override
    public boolean canFlyInDimension(DimensionType dimensionType) {
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        return !((List)ConfigFlyingThings.deniedDimensionToFly.deniedDimensionCarpet.get()).contains(Helper.getDimensionString(dimensionType));
    }

    @Override
    protected boolean onInteractWithPlayerItem(ItemStack stack, EntityPlayer player, EnumHand hand) {
        if (stack.func_77973_b() == ModItems.pumpkinStick) {
            int res = Helper.getRandom(9, 13);
            if (res == this.getModelType()) {
                res = res == 13 ? 9 : res + 1;
            }
            this.setModelType(res);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return true;
        }
        if (stack.func_77973_b() == Items.field_151057_cb && stack.func_82837_s()) {
            this.func_200203_b(stack.func_200301_q());
            stack.func_190918_g(1);
            return true;
        }
        return false;
    }

    @Override
    public void func_70071_h_() {
        if (((Boolean)ConfigFlyingThings.general.allowSpecialRegen.get()).booleanValue() && this.getEnergy() < ConfigFlyingThings.General.getMaxEnergy() && this.field_70173_aa % 10 == 0 && this.field_70170_p.func_175667_e(this.func_180425_c().func_177977_b()) && this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()).func_177230_c() == Blocks.field_150425_aM) {
            if (!this.field_70170_p.field_72995_K) {
                this.setEnergy(this.getEnergy() + 4);
                this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_193784_dd, SoundCategory.PLAYERS, 0.5f, 0.5f);
            } else {
                IntStream.range(0, Helper.getRandom(10, 45)).forEach(i -> this.field_70170_p.func_195594_a((IParticleData)Particles.field_197607_R, this.field_70165_t + this.field_70146_Z.nextGaussian() * 0.4, this.func_174813_aQ().field_72337_e + this.field_70146_Z.nextGaussian() * (double)0.13f, this.field_70161_v + this.field_70146_Z.nextGaussian() * 0.4, 0.0, 0.0, 0.0));
            }
        }
        super.func_70071_h_();
    }

    @Override
    public double func_70042_X() {
        return 0.1;
    }

    @Override
    protected DataParameter<Integer> getDataEnergy() {
        return ENERGY;
    }

    @Override
    protected DataParameter<Float> getDataDamageTaken() {
        return DAMAGE_TAKEN;
    }

    @Override
    protected DataParameter<Integer> getDataTimeSinceHit() {
        return TIME_SINCE_HIT;
    }

    @Override
    protected DataParameter<Integer> getDataForwardDirection() {
        return FORWARD_DIRECTION;
    }

    @Override
    protected DataParameter<Integer> getDataModelType() {
        return MODEL_TYPE;
    }
}

