/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.flying_things.event;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.items.ItemHandlerHelper;
import ovh.corail.flying_things.ConfigFlyingThings;
import ovh.corail.flying_things.entity.EntityAbstractFlyingThing;
import ovh.corail.flying_things.helper.Helper;
import ovh.corail.flying_things.registry.ModItems;

@Mod.EventBusSubscriber(modid="flying_things", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EventHandler {
    private static ResourceLocation LOOTTABLE_SPECIAL = new ResourceLocation("flying_things", "loot_tables/special.json");

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLootTableLoad(LootTableLoadEvent event) {
        if (event.getName().equals((Object)LOOTTABLE_SPECIAL)) {
            LootPool chestTreasure = event.getTable().getPool("flying_things:chest_treasure");
            for (String targetTableString : (List)ConfigFlyingThings.general.treasureLootTable.get()) {
                LootTable targetTable = event.getLootTableManager().func_186521_a(new ResourceLocation(targetTableString));
                if (targetTable == LootTable.field_186464_a) continue;
                ObfuscationReflectionHelper.setPrivateValue(LootTable.class, (Object)targetTable, (Object)false, (String)"isFrozen");
                targetTable.addPool(chestTreasure);
                ObfuscationReflectionHelper.setPrivateValue(LootTable.class, (Object)targetTable, (Object)true, (String)"isFrozen");
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBossDrops(LivingDropsEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (Helper.isBoss((Entity)entity)) {
            if (Helper.getRandom(1, 100) <= 10) {
                event.getDrops().add(new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack((IItemProvider)ModItems.phialOfAnimation)));
            }
        } else if (entity instanceof EntityMob && Helper.isDateAroundHalloween() && event.getSource() != null && event.getSource().func_76346_g() instanceof EntityPlayer && Helper.getRandom(1, 100) <= (Integer)ConfigFlyingThings.general.chanceDropPumpkinStick.get()) {
            event.getDrops().add(new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack((IItemProvider)ModItems.pumpkinStick)));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingFall(LivingFallEvent event) {
        if (Helper.isRidingFlyingThing((Entity)event.getEntityLiving())) {
            event.setDistance(0.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingInWall(LivingDamageEvent event) {
        if (event.getSource() == DamageSource.field_76368_d && Helper.isRidingFlyingThing((Entity)event.getEntityLiving())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onProjectileImpact(ProjectileImpactEvent event) {
        if (event.getRayTraceResult() == null || event.getRayTraceResult().field_72308_g == null) {
            return;
        }
        Entity rider = event.getRayTraceResult().field_72308_g;
        if ((Integer)ConfigFlyingThings.general.chanceToFallWithProjectile.get() != 0 && Helper.isRidingFlyingThing(rider) && Helper.getRandom(1, 100) < (Integer)ConfigFlyingThings.general.chanceToFallWithProjectile.get()) {
            rider.func_184210_p();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingDeath(LivingDeathEvent event) {
        EntityAbstractFlyingThing flying_thing;
        if (Helper.isControllingFlyingThing((Entity)event.getEntityLiving()) && (flying_thing = (EntityAbstractFlyingThing)event.getEntityLiving().func_184187_bx()) != null) {
            if (Helper.isValidPlayer((Entity)event.getEntityLiving()) && flying_thing.hasSoulbound()) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)((EntityPlayer)event.getEntityLiving()), (ItemStack)flying_thing.getStack());
            } else {
                event.getEntityLiving().func_70099_a(flying_thing.getStack(), 0.0f);
            }
            event.getEntityLiving().func_184187_bx().func_70106_y();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (Helper.isValidPlayerMP((Entity)event.getPlayer()) && Helper.isControllingFlyingThing((Entity)event.getPlayer())) {
            EntityAbstractFlyingThing mount = (EntityAbstractFlyingThing)event.getPlayer().func_184187_bx();
            event.getPlayer().func_184210_p();
            if (mount != null) {
                event.getPlayer().field_70170_p.func_72964_e(mount.field_70176_ah, mount.field_70164_aj).func_76630_e();
            }
        }
    }
}

