/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.flying_things.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.flying_things.ConfigFlyingThings;
import ovh.corail.flying_things.entity.EntityAbstractFlyingThing;
import ovh.corail.flying_things.helper.TextureLocation;

@OnlyIn(value=Dist.CLIENT)
public class GuiOverlayEnergy
extends Gui {
    private final Minecraft mc;
    private final int width;
    private final int height;
    private final int guiLeft;
    private final int guiTop;
    private final int barWidth;

    public GuiOverlayEnergy(Minecraft mc) {
        this.mc = mc;
        this.width = this.mc.field_195558_d.func_198107_o();
        this.height = this.mc.field_195558_d.func_198087_p();
        this.barWidth = (Integer)ConfigFlyingThings.client.barLength.get();
        this.guiLeft = (this.width - this.barWidth) / 2;
        this.guiTop = this.height - (Integer)ConfigFlyingThings.client.barHeightPos.get();
        this.drawScreen();
    }

    private void drawScreen() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (!player.func_184218_aH() || !(player.func_184187_bx() instanceof EntityAbstractFlyingThing)) {
            return;
        }
        EntityAbstractFlyingThing mount = (EntityAbstractFlyingThing)player.func_184187_bx();
        this.mc.func_110434_K().func_110577_a(field_110324_m);
        int filled = (int)((double)mount.getEnergy() * (double)this.barWidth / (double)ConfigFlyingThings.General.getMaxEnergy()) + 1;
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 84, this.barWidth, 5);
        if (filled > 0) {
            this.func_73729_b(this.guiLeft, this.guiTop, 0, 89, filled, 5);
        }
        this.mc.func_110434_K().func_110577_a(TextureLocation.BARS);
        float speed = (float)mount.speed * 100.0f;
        float speedMax = ConfigFlyingThings.General.getSpeedMax();
        filled = mount.speed >= (double)speedMax ? this.barWidth + 1 : (int)(speed * (float)this.barWidth / speedMax) + 1;
        this.func_73729_b(this.guiLeft, this.guiTop + 7, 0, 50, this.barWidth, 5);
        if (filled > 0) {
            this.func_73729_b(this.guiLeft, this.guiTop + 7, 0, 55, filled, 5);
        }
        this.func_73729_b(this.guiLeft, this.guiTop + 7, 0, 115, this.barWidth, 5);
    }
}

