/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.flying_things.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.flying_things.ConfigFlyingThings;
import ovh.corail.flying_things.entity.EntityAbstractFlyingThing;
import ovh.corail.flying_things.helper.Helper;
import ovh.corail.flying_things.item.ItemAbstractFlyingThing;
import ovh.corail.flying_things.registry.ModEntities;
import ovh.corail.flying_things.render.TEISRMagicCarpet;

public class ItemMagicCarpet
extends ItemAbstractFlyingThing {
    public ItemMagicCarpet() {
        super("magic_carpet", ItemMagicCarpet.getBuilder(true).func_200917_a(1).setTEISR(() -> TEISRMagicCarpet::new));
    }

    @Override
    EntityType<?> getEntityType() {
        return ModEntities.TYPE_CARPET;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            for (int i = 0; i <= 13; ++i) {
                ItemStack stack = new ItemStack((IItemProvider)this);
                ItemMagicCarpet.setModelType(stack, i);
                items.add((Object)stack);
            }
        }
    }

    @Override
    public boolean canFlyInDimension(DimensionType dimensionType) {
        return !((List)ConfigFlyingThings.deniedDimensionToFly.deniedDimensionCarpet.get()).contains(Helper.getDimensionString(dimensionType));
    }

    @Override
    public int getActualRegen(ItemStack stack, World world, Entity entity, int slot, boolean isSelected) {
        boolean hasSpecialRegen = (Boolean)ConfigFlyingThings.general.allowSpecialRegen.get() != false && world.func_175667_e(entity.func_180425_c().func_177977_b()) && world.func_180495_p(entity.func_180425_c().func_177977_b()).func_177230_c() == Blocks.field_150425_aM;
        return hasSpecialRegen ? 20 : 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (!GuiScreen.func_146272_n()) {
            list.add(new TextComponentTranslation("flying_things.message.hold_key", new Object[]{"SHIFT"}).func_150258_a(" ").func_150257_a((ITextComponent)new TextComponentTranslation("flying_things.message.for_more_infos", new Object[0])));
        } else {
            list.add((ITextComponent)new TextComponentTranslation("flying_things.item.magic_carpet.desc1", new Object[0]));
            list.add((ITextComponent)new TextComponentTranslation("flying_things.item.magic_carpet.desc2", new Object[]{Minecraft.func_71410_x().field_71474_y.field_74311_E.getKey().func_197936_a()}));
        }
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return new TextComponentTranslation(this.func_77667_c(stack) + (ItemMagicCarpet.getModelType(stack) <= 8 ? "" : ".halloween"), new Object[0]);
    }

    @Override
    void onEntitySpawn(ItemStack stack, EntityAbstractFlyingThing entity) {
    }
}

